# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from keplar_api.models.panel_settings import PanelSettings
from keplar_api.models.repdata_survey import RepdataSurvey
from typing import Optional, Set
from typing_extensions import Self

class InviteConfigKeplarPanel(BaseModel):
    """
    InviteConfigKeplarPanel
    """ # noqa: E501
    kind: StrictStr
    allowed_origins: Optional[List[StrictStr]] = Field(default=None, alias="allowedOrigins")
    collect_email: Optional[StrictBool] = Field(default=None, alias="collectEmail")
    require_email: Optional[StrictBool] = Field(default=None, alias="requireEmail")
    panel_settings: PanelSettings = Field(alias="panelSettings")
    rep_data_survey: Optional[RepdataSurvey] = Field(default=None, alias="repDataSurvey")
    title: StrictStr
    description: Optional[StrictStr] = None
    max_responses: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxResponses")
    max_responses_per_participant: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxResponsesPerParticipant")
    __properties: ClassVar[List[str]] = ["kind", "allowedOrigins", "collectEmail", "requireEmail", "panelSettings", "repDataSurvey", "title", "description", "maxResponses", "maxResponsesPerParticipant"]

    @field_validator('kind')
    def kind_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['KEPLAR_PANEL']):
            raise ValueError("must be one of enum values ('KEPLAR_PANEL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InviteConfigKeplarPanel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of panel_settings
        if self.panel_settings:
            _dict['panelSettings'] = self.panel_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rep_data_survey
        if self.rep_data_survey:
            _dict['repDataSurvey'] = self.rep_data_survey.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InviteConfigKeplarPanel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "kind": obj.get("kind"),
            "allowedOrigins": obj.get("allowedOrigins"),
            "collectEmail": obj.get("collectEmail"),
            "requireEmail": obj.get("requireEmail"),
            "panelSettings": PanelSettings.from_dict(obj["panelSettings"]) if obj.get("panelSettings") is not None else None,
            "repDataSurvey": RepdataSurvey.from_dict(obj["repDataSurvey"]) if obj.get("repDataSurvey") is not None else None,
            "title": obj.get("title"),
            "description": obj.get("description"),
            "maxResponses": obj.get("maxResponses"),
            "maxResponsesPerParticipant": obj.get("maxResponsesPerParticipant")
        })
        return _obj


