# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.invite_response_attribute_data import InviteResponseAttributeData
from typing import Optional, Set
from typing_extensions import Self

class InviteResponseAttribute(BaseModel):
    """
    InviteResponseAttribute
    """ # noqa: E501
    invite_response_id: StrictStr = Field(alias="inviteResponseId")
    attribute_id: StrictStr = Field(alias="attributeId")
    data: Optional[InviteResponseAttributeData] = None
    created_at: datetime = Field(alias="createdAt")
    invite_response: Optional[InviteResponse] = Field(default=None, alias="inviteResponse")
    attribute: Optional[Attribute] = None
    __properties: ClassVar[List[str]] = ["inviteResponseId", "attributeId", "data", "createdAt", "inviteResponse", "attribute"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InviteResponseAttribute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invite_response
        if self.invite_response:
            _dict['inviteResponse'] = self.invite_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attribute
        if self.attribute:
            _dict['attribute'] = self.attribute.to_dict()
        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InviteResponseAttribute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "inviteResponseId": obj.get("inviteResponseId"),
            "attributeId": obj.get("attributeId"),
            "data": InviteResponseAttributeData.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "createdAt": obj.get("createdAt"),
            "inviteResponse": InviteResponse.from_dict(obj["inviteResponse"]) if obj.get("inviteResponse") is not None else None,
            "attribute": Attribute.from_dict(obj["attribute"]) if obj.get("attribute") is not None else None
        })
        return _obj

from keplar_api.models.attribute import Attribute
from keplar_api.models.invite_response import InviteResponse
# TODO: Rewrite to not use raise_errors
InviteResponseAttribute.model_rebuild(raise_errors=False)

