# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.screener_question_response import ScreenerQuestionResponse
from typing import Optional, Set
from typing_extensions import Self

class InviteResponseData(BaseModel):
    """
    InviteResponseData
    """ # noqa: E501
    email: Optional[StrictStr] = None
    screener_questions_responses: Optional[List[ScreenerQuestionResponse]] = Field(default=None, alias="screenerQuestionsResponses")
    consented: Optional[StrictBool] = None
    redirected: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["email", "screenerQuestionsResponses", "consented", "redirected"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InviteResponseData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in screener_questions_responses (list)
        _items = []
        if self.screener_questions_responses:
            for _item_screener_questions_responses in self.screener_questions_responses:
                if _item_screener_questions_responses:
                    _items.append(_item_screener_questions_responses.to_dict())
            _dict['screenerQuestionsResponses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InviteResponseData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email": obj.get("email"),
            "screenerQuestionsResponses": [ScreenerQuestionResponse.from_dict(_item) for _item in obj["screenerQuestionsResponses"]] if obj.get("screenerQuestionsResponses") is not None else None,
            "consented": obj.get("consented"),
            "redirected": obj.get("redirected")
        })
        return _obj


