# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from keplar_api.models.response_call_completed_event import ResponseCallCompletedEvent
from keplar_api.models.response_call_failed_event import ResponseCallFailedEvent
from keplar_api.models.response_consent_event import ResponseConsentEvent
from keplar_api.models.response_opt_out_event import ResponseOptOutEvent
from keplar_api.models.response_processing_completed_event import ResponseProcessingCompletedEvent
from keplar_api.models.response_processing_failed_event import ResponseProcessingFailedEvent
from keplar_api.models.response_redirect_event import ResponseRedirectEvent
from keplar_api.models.response_start_call_event import ResponseStartCallEvent
from keplar_api.models.response_submit_email_event import ResponseSubmitEmailEvent
from keplar_api.models.response_submit_screener_event import ResponseSubmitScreenerEvent
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

INVITERESPONSEUPDATEEVENT_ONE_OF_SCHEMAS = ["ResponseCallCompletedEvent", "ResponseCallFailedEvent", "ResponseConsentEvent", "ResponseOptOutEvent", "ResponseProcessingCompletedEvent", "ResponseProcessingFailedEvent", "ResponseRedirectEvent", "ResponseStartCallEvent", "ResponseSubmitEmailEvent", "ResponseSubmitScreenerEvent"]

class InviteResponseUpdateEvent(BaseModel):
    """
    InviteResponseUpdateEvent
    """
    # data type: ResponseSubmitEmailEvent
    oneof_schema_1_validator: Optional[ResponseSubmitEmailEvent] = None
    # data type: ResponseSubmitScreenerEvent
    oneof_schema_2_validator: Optional[ResponseSubmitScreenerEvent] = None
    # data type: ResponseOptOutEvent
    oneof_schema_3_validator: Optional[ResponseOptOutEvent] = None
    # data type: ResponseConsentEvent
    oneof_schema_4_validator: Optional[ResponseConsentEvent] = None
    # data type: ResponseStartCallEvent
    oneof_schema_5_validator: Optional[ResponseStartCallEvent] = None
    # data type: ResponseCallCompletedEvent
    oneof_schema_6_validator: Optional[ResponseCallCompletedEvent] = None
    # data type: ResponseCallFailedEvent
    oneof_schema_7_validator: Optional[ResponseCallFailedEvent] = None
    # data type: ResponseProcessingCompletedEvent
    oneof_schema_8_validator: Optional[ResponseProcessingCompletedEvent] = None
    # data type: ResponseProcessingFailedEvent
    oneof_schema_9_validator: Optional[ResponseProcessingFailedEvent] = None
    # data type: ResponseRedirectEvent
    oneof_schema_10_validator: Optional[ResponseRedirectEvent] = None
    actual_instance: Optional[Union[ResponseCallCompletedEvent, ResponseCallFailedEvent, ResponseConsentEvent, ResponseOptOutEvent, ResponseProcessingCompletedEvent, ResponseProcessingFailedEvent, ResponseRedirectEvent, ResponseStartCallEvent, ResponseSubmitEmailEvent, ResponseSubmitScreenerEvent]] = None
    one_of_schemas: Set[str] = { "ResponseCallCompletedEvent", "ResponseCallFailedEvent", "ResponseConsentEvent", "ResponseOptOutEvent", "ResponseProcessingCompletedEvent", "ResponseProcessingFailedEvent", "ResponseRedirectEvent", "ResponseStartCallEvent", "ResponseSubmitEmailEvent", "ResponseSubmitScreenerEvent" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = InviteResponseUpdateEvent.model_construct()
        error_messages = []
        match = 0
        # validate data type: ResponseSubmitEmailEvent
        if not isinstance(v, ResponseSubmitEmailEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseSubmitEmailEvent`")
        else:
            match += 1
        # validate data type: ResponseSubmitScreenerEvent
        if not isinstance(v, ResponseSubmitScreenerEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseSubmitScreenerEvent`")
        else:
            match += 1
        # validate data type: ResponseOptOutEvent
        if not isinstance(v, ResponseOptOutEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseOptOutEvent`")
        else:
            match += 1
        # validate data type: ResponseConsentEvent
        if not isinstance(v, ResponseConsentEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseConsentEvent`")
        else:
            match += 1
        # validate data type: ResponseStartCallEvent
        if not isinstance(v, ResponseStartCallEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseStartCallEvent`")
        else:
            match += 1
        # validate data type: ResponseCallCompletedEvent
        if not isinstance(v, ResponseCallCompletedEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseCallCompletedEvent`")
        else:
            match += 1
        # validate data type: ResponseCallFailedEvent
        if not isinstance(v, ResponseCallFailedEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseCallFailedEvent`")
        else:
            match += 1
        # validate data type: ResponseProcessingCompletedEvent
        if not isinstance(v, ResponseProcessingCompletedEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseProcessingCompletedEvent`")
        else:
            match += 1
        # validate data type: ResponseProcessingFailedEvent
        if not isinstance(v, ResponseProcessingFailedEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseProcessingFailedEvent`")
        else:
            match += 1
        # validate data type: ResponseRedirectEvent
        if not isinstance(v, ResponseRedirectEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseRedirectEvent`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in InviteResponseUpdateEvent with oneOf schemas: ResponseCallCompletedEvent, ResponseCallFailedEvent, ResponseConsentEvent, ResponseOptOutEvent, ResponseProcessingCompletedEvent, ResponseProcessingFailedEvent, ResponseRedirectEvent, ResponseStartCallEvent, ResponseSubmitEmailEvent, ResponseSubmitScreenerEvent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in InviteResponseUpdateEvent with oneOf schemas: ResponseCallCompletedEvent, ResponseCallFailedEvent, ResponseConsentEvent, ResponseOptOutEvent, ResponseProcessingCompletedEvent, ResponseProcessingFailedEvent, ResponseRedirectEvent, ResponseStartCallEvent, ResponseSubmitEmailEvent, ResponseSubmitScreenerEvent. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into ResponseSubmitEmailEvent
        try:
            instance.actual_instance = ResponseSubmitEmailEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseSubmitScreenerEvent
        try:
            instance.actual_instance = ResponseSubmitScreenerEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseOptOutEvent
        try:
            instance.actual_instance = ResponseOptOutEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseConsentEvent
        try:
            instance.actual_instance = ResponseConsentEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseStartCallEvent
        try:
            instance.actual_instance = ResponseStartCallEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseCallCompletedEvent
        try:
            instance.actual_instance = ResponseCallCompletedEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseCallFailedEvent
        try:
            instance.actual_instance = ResponseCallFailedEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseProcessingCompletedEvent
        try:
            instance.actual_instance = ResponseProcessingCompletedEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseProcessingFailedEvent
        try:
            instance.actual_instance = ResponseProcessingFailedEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseRedirectEvent
        try:
            instance.actual_instance = ResponseRedirectEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into InviteResponseUpdateEvent with oneOf schemas: ResponseCallCompletedEvent, ResponseCallFailedEvent, ResponseConsentEvent, ResponseOptOutEvent, ResponseProcessingCompletedEvent, ResponseProcessingFailedEvent, ResponseRedirectEvent, ResponseStartCallEvent, ResponseSubmitEmailEvent, ResponseSubmitScreenerEvent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into InviteResponseUpdateEvent with oneOf schemas: ResponseCallCompletedEvent, ResponseCallFailedEvent, ResponseConsentEvent, ResponseOptOutEvent, ResponseProcessingCompletedEvent, ResponseProcessingFailedEvent, ResponseRedirectEvent, ResponseStartCallEvent, ResponseSubmitEmailEvent, ResponseSubmitScreenerEvent. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ResponseCallCompletedEvent, ResponseCallFailedEvent, ResponseConsentEvent, ResponseOptOutEvent, ResponseProcessingCompletedEvent, ResponseProcessingFailedEvent, ResponseRedirectEvent, ResponseStartCallEvent, ResponseSubmitEmailEvent, ResponseSubmitScreenerEvent]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


