# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.call_summary import CallSummary
from keplar_api.models.invite import Invite
from keplar_api.models.invite_response_attribute import InviteResponseAttribute
from keplar_api.models.invite_response_data import InviteResponseData
from keplar_api.models.invite_response_kind import InviteResponseKind
from keplar_api.models.invite_response_metadata import InviteResponseMetadata
from keplar_api.models.invite_response_status import InviteResponseStatus
from keplar_api.models.participant import Participant
from typing import Optional, Set
from typing_extensions import Self

class InviteResponseWithCallSummary(BaseModel):
    """
    InviteResponseWithCallSummary
    """ # noqa: E501
    id: StrictStr
    kind: InviteResponseKind
    status: InviteResponseStatus
    data: Optional[InviteResponseData] = None
    metadata: Optional[InviteResponseMetadata] = None
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    invite_id: StrictStr = Field(alias="inviteId")
    vendor_participant_id: Optional[StrictStr] = Field(default=None, alias="vendorParticipantId")
    participant_id: Optional[StrictStr] = Field(default=None, alias="participantId")
    invite: Optional[Invite] = None
    participant: Optional[Participant] = None
    calls: List[CallSummary]
    invite_response_attributes: Optional[List[InviteResponseAttribute]] = Field(default=None, alias="inviteResponseAttributes")
    __properties: ClassVar[List[str]] = ["id", "kind", "status", "data", "metadata", "createdAt", "updatedAt", "inviteId", "vendorParticipantId", "participantId", "invite", "participant", "calls", "inviteResponseAttributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InviteResponseWithCallSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invite
        if self.invite:
            _dict['invite'] = self.invite.to_dict()
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in calls (list)
        _items = []
        if self.calls:
            for _item_calls in self.calls:
                if _item_calls:
                    _items.append(_item_calls.to_dict())
            _dict['calls'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in invite_response_attributes (list)
        _items = []
        if self.invite_response_attributes:
            for _item_invite_response_attributes in self.invite_response_attributes:
                if _item_invite_response_attributes:
                    _items.append(_item_invite_response_attributes.to_dict())
            _dict['inviteResponseAttributes'] = _items
        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if vendor_participant_id (nullable) is None
        # and model_fields_set contains the field
        if self.vendor_participant_id is None and "vendor_participant_id" in self.model_fields_set:
            _dict['vendorParticipantId'] = None

        # set to None if participant_id (nullable) is None
        # and model_fields_set contains the field
        if self.participant_id is None and "participant_id" in self.model_fields_set:
            _dict['participantId'] = None

        # set to None if participant (nullable) is None
        # and model_fields_set contains the field
        if self.participant is None and "participant" in self.model_fields_set:
            _dict['participant'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InviteResponseWithCallSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "kind": obj.get("kind"),
            "status": obj.get("status"),
            "data": InviteResponseData.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "metadata": InviteResponseMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "inviteId": obj.get("inviteId"),
            "vendorParticipantId": obj.get("vendorParticipantId"),
            "participantId": obj.get("participantId"),
            "invite": Invite.from_dict(obj["invite"]) if obj.get("invite") is not None else None,
            "participant": Participant.from_dict(obj["participant"]) if obj.get("participant") is not None else None,
            "calls": [CallSummary.from_dict(_item) for _item in obj["calls"]] if obj.get("calls") is not None else None,
            "inviteResponseAttributes": [InviteResponseAttribute.from_dict(_item) for _item in obj["inviteResponseAttributes"]] if obj.get("inviteResponseAttributes") is not None else None
        })
        return _obj


