# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from keplar_api.models.project_file_public import ProjectFilePublic
from keplar_api.models.screener_question_public import ScreenerQuestionPublic
from typing import Optional, Set
from typing_extensions import Self

class JoinCodeInvite302ResponseSettings(BaseModel):
    """
    JoinCodeInvite302ResponseSettings
    """ # noqa: E501
    max_duration_seconds: Union[StrictFloat, StrictInt] = Field(alias="maxDurationSeconds")
    screener_questions: Optional[List[ScreenerQuestionPublic]] = Field(default=None, alias="screenerQuestions")
    files: Optional[List[ProjectFilePublic]] = None
    __properties: ClassVar[List[str]] = ["maxDurationSeconds", "screenerQuestions", "files"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JoinCodeInvite302ResponseSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in screener_questions (list)
        _items = []
        if self.screener_questions:
            for _item_screener_questions in self.screener_questions:
                if _item_screener_questions:
                    _items.append(_item_screener_questions.to_dict())
            _dict['screenerQuestions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files:
                    _items.append(_item_files.to_dict())
            _dict['files'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JoinCodeInvite302ResponseSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "maxDurationSeconds": obj.get("maxDurationSeconds"),
            "screenerQuestions": [ScreenerQuestionPublic.from_dict(_item) for _item in obj["screenerQuestions"]] if obj.get("screenerQuestions") is not None else None,
            "files": [ProjectFilePublic.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None
        })
        return _obj


