# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from keplar_api.models.login200_response_any_of import Login200ResponseAnyOf
from keplar_api.models.user import User
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

LOGIN200RESPONSE_ANY_OF_SCHEMAS = ["Login200ResponseAnyOf", "User"]

class Login200Response(BaseModel):
    """
    Login200Response
    """

    # data type: User
    anyof_schema_1_validator: Optional[User] = None
    # data type: Login200ResponseAnyOf
    anyof_schema_2_validator: Optional[Login200ResponseAnyOf] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[Login200ResponseAnyOf, User]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "Login200ResponseAnyOf", "User" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = Login200Response.model_construct()
        error_messages = []
        # validate data type: User
        if not isinstance(v, User):
            error_messages.append(f"Error! Input type `{type(v)}` is not `User`")
        else:
            return v

        # validate data type: Login200ResponseAnyOf
        if not isinstance(v, Login200ResponseAnyOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Login200ResponseAnyOf`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in Login200Response with anyOf schemas: Login200ResponseAnyOf, User. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[User] = None
        try:
            instance.actual_instance = User.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[Login200ResponseAnyOf] = None
        try:
            instance.actual_instance = Login200ResponseAnyOf.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Login200Response with anyOf schemas: Login200ResponseAnyOf, User. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Login200ResponseAnyOf, User]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


