# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.moderator_vendor import ModeratorVendor
from keplar_api.models.moderator_visibility import ModeratorVisibility
from keplar_api.models.vapi_assistant_config import VapiAssistantConfig
from typing import Optional, Set
from typing_extensions import Self

class Moderator(BaseModel):
    """
    Moderator
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    description: Optional[StrictStr] = None
    visibility: ModeratorVisibility
    config: VapiAssistantConfig
    vendor: ModeratorVendor
    vendor_id: Optional[StrictStr] = Field(default=None, alias="vendorId")
    vendor_data: Optional[Any] = Field(default=None, alias="vendorData")
    workspace_id: StrictStr = Field(alias="workspaceId")
    created_by_id: StrictStr = Field(alias="createdById")
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    parent_moderator_id: Optional[StrictStr] = Field(default=None, alias="parentModeratorId")
    workspace: Optional[Workspace] = None
    created_by: Optional[User] = Field(default=None, alias="createdBy")
    parent_moderator: Optional[Moderator] = Field(default=None, alias="parentModerator")
    child_moderators: Optional[List[Moderator]] = Field(default=None, alias="childModerators")
    projects: Optional[List[Project]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "visibility", "config", "vendor", "vendorId", "vendorData", "workspaceId", "createdById", "createdAt", "updatedAt", "parentModeratorId", "workspace", "createdBy", "parentModerator", "childModerators", "projects"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Moderator from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workspace
        if self.workspace:
            _dict['workspace'] = self.workspace.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent_moderator
        if self.parent_moderator:
            _dict['parentModerator'] = self.parent_moderator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in child_moderators (list)
        _items = []
        if self.child_moderators:
            for _item_child_moderators in self.child_moderators:
                if _item_child_moderators:
                    _items.append(_item_child_moderators.to_dict())
            _dict['childModerators'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item_projects in self.projects:
                if _item_projects:
                    _items.append(_item_projects.to_dict())
            _dict['projects'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if vendor_id (nullable) is None
        # and model_fields_set contains the field
        if self.vendor_id is None and "vendor_id" in self.model_fields_set:
            _dict['vendorId'] = None

        # set to None if vendor_data (nullable) is None
        # and model_fields_set contains the field
        if self.vendor_data is None and "vendor_data" in self.model_fields_set:
            _dict['vendorData'] = None

        # set to None if parent_moderator_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_moderator_id is None and "parent_moderator_id" in self.model_fields_set:
            _dict['parentModeratorId'] = None

        # set to None if parent_moderator (nullable) is None
        # and model_fields_set contains the field
        if self.parent_moderator is None and "parent_moderator" in self.model_fields_set:
            _dict['parentModerator'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Moderator from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "visibility": obj.get("visibility"),
            "config": VapiAssistantConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "vendor": obj.get("vendor"),
            "vendorId": obj.get("vendorId"),
            "vendorData": obj.get("vendorData"),
            "workspaceId": obj.get("workspaceId"),
            "createdById": obj.get("createdById"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "parentModeratorId": obj.get("parentModeratorId"),
            "workspace": Workspace.from_dict(obj["workspace"]) if obj.get("workspace") is not None else None,
            "createdBy": User.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "parentModerator": Moderator.from_dict(obj["parentModerator"]) if obj.get("parentModerator") is not None else None,
            "childModerators": [Moderator.from_dict(_item) for _item in obj["childModerators"]] if obj.get("childModerators") is not None else None,
            "projects": [Project.from_dict(_item) for _item in obj["projects"]] if obj.get("projects") is not None else None
        })
        return _obj

from keplar_api.models.project import Project
from keplar_api.models.user import User
from keplar_api.models.workspace import Workspace
# TODO: Rewrite to not use raise_errors
Moderator.model_rebuild(raise_errors=False)

