# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from keplar_api.models.panel_respondent_attribute import PanelRespondentAttribute
from typing import Optional, Set
from typing_extensions import Self

class PanelSettings(BaseModel):
    """
    PanelSettings
    """ # noqa: E501
    respondent_attributes: List[PanelRespondentAttribute]
    country_code: Optional[StrictStr] = None
    language_code: Optional[StrictStr] = None
    length_of_interview: Optional[Union[StrictFloat, StrictInt]] = None
    incidence_rate: Optional[Union[StrictFloat, StrictInt]] = None
    compensation: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["respondent_attributes", "country_code", "language_code", "length_of_interview", "incidence_rate", "compensation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PanelSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in respondent_attributes (list)
        _items = []
        if self.respondent_attributes:
            for _item_respondent_attributes in self.respondent_attributes:
                if _item_respondent_attributes:
                    _items.append(_item_respondent_attributes.to_dict())
            _dict['respondent_attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PanelSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "respondent_attributes": [PanelRespondentAttribute.from_dict(_item) for _item in obj["respondent_attributes"]] if obj.get("respondent_attributes") is not None else None,
            "country_code": obj.get("country_code"),
            "language_code": obj.get("language_code"),
            "length_of_interview": obj.get("length_of_interview"),
            "incidence_rate": obj.get("incidence_rate"),
            "compensation": obj.get("compensation")
        })
        return _obj


