# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Participant(BaseModel):
    """
    Participant
    """ # noqa: E501
    id: StrictStr
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    email: Optional[StrictStr] = None
    phone_number: Optional[StrictStr] = Field(default=None, alias="phoneNumber")
    name: Optional[StrictStr] = None
    data: Optional[Dict[str, Any]] = None
    workspace_id: StrictStr = Field(alias="workspaceId")
    workspace: Optional[Workspace] = None
    participant_invites: Optional[List[ParticipantInvite]] = Field(default=None, alias="participantInvites")
    invite_responses: Optional[List[InviteResponse]] = Field(default=None, alias="inviteResponses")
    calls: Optional[List[Call]] = None
    participant_attributes: Optional[List[ParticipantAttribute]] = Field(default=None, alias="participantAttributes")
    __properties: ClassVar[List[str]] = ["id", "createdAt", "updatedAt", "email", "phoneNumber", "name", "data", "workspaceId", "workspace", "participantInvites", "inviteResponses", "calls", "participantAttributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Participant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of workspace
        if self.workspace:
            _dict['workspace'] = self.workspace.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in participant_invites (list)
        _items = []
        if self.participant_invites:
            for _item_participant_invites in self.participant_invites:
                if _item_participant_invites:
                    _items.append(_item_participant_invites.to_dict())
            _dict['participantInvites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in invite_responses (list)
        _items = []
        if self.invite_responses:
            for _item_invite_responses in self.invite_responses:
                if _item_invite_responses:
                    _items.append(_item_invite_responses.to_dict())
            _dict['inviteResponses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in calls (list)
        _items = []
        if self.calls:
            for _item_calls in self.calls:
                if _item_calls:
                    _items.append(_item_calls.to_dict())
            _dict['calls'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in participant_attributes (list)
        _items = []
        if self.participant_attributes:
            for _item_participant_attributes in self.participant_attributes:
                if _item_participant_attributes:
                    _items.append(_item_participant_attributes.to_dict())
            _dict['participantAttributes'] = _items
        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if phone_number (nullable) is None
        # and model_fields_set contains the field
        if self.phone_number is None and "phone_number" in self.model_fields_set:
            _dict['phoneNumber'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Participant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "email": obj.get("email"),
            "phoneNumber": obj.get("phoneNumber"),
            "name": obj.get("name"),
            "data": obj.get("data"),
            "workspaceId": obj.get("workspaceId"),
            "workspace": Workspace.from_dict(obj["workspace"]) if obj.get("workspace") is not None else None,
            "participantInvites": [ParticipantInvite.from_dict(_item) for _item in obj["participantInvites"]] if obj.get("participantInvites") is not None else None,
            "inviteResponses": [InviteResponse.from_dict(_item) for _item in obj["inviteResponses"]] if obj.get("inviteResponses") is not None else None,
            "calls": [Call.from_dict(_item) for _item in obj["calls"]] if obj.get("calls") is not None else None,
            "participantAttributes": [ParticipantAttribute.from_dict(_item) for _item in obj["participantAttributes"]] if obj.get("participantAttributes") is not None else None
        })
        return _obj

from keplar_api.models.call import Call
from keplar_api.models.invite_response import InviteResponse
from keplar_api.models.participant_attribute import ParticipantAttribute
from keplar_api.models.participant_invite import ParticipantInvite
from keplar_api.models.workspace import Workspace
# TODO: Rewrite to not use raise_errors
Participant.model_rebuild(raise_errors=False)

