# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ParticipantAttribute(BaseModel):
    """
    ParticipantAttribute
    """ # noqa: E501
    participant_id: StrictStr = Field(alias="participantId")
    attribute_id: StrictStr = Field(alias="attributeId")
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    participant: Optional[Participant] = None
    attribute: Optional[Attribute] = None
    __properties: ClassVar[List[str]] = ["participantId", "attributeId", "createdAt", "updatedAt", "participant", "attribute"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ParticipantAttribute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attribute
        if self.attribute:
            _dict['attribute'] = self.attribute.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ParticipantAttribute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "participantId": obj.get("participantId"),
            "attributeId": obj.get("attributeId"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "participant": Participant.from_dict(obj["participant"]) if obj.get("participant") is not None else None,
            "attribute": Attribute.from_dict(obj["attribute"]) if obj.get("attribute") is not None else None
        })
        return _obj

from keplar_api.models.attribute import Attribute
from keplar_api.models.participant import Participant
# TODO: Rewrite to not use raise_errors
ParticipantAttribute.model_rebuild(raise_errors=False)

