# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.project_analysis import ProjectAnalysis
from keplar_api.models.project_config import ProjectConfig
from keplar_api.models.project_conversation_config import ProjectConversationConfig
from keplar_api.models.project_status import ProjectStatus
from typing import Optional, Set
from typing_extensions import Self

class Project(BaseModel):
    """
    Project
    """ # noqa: E501
    id: StrictStr
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    name: StrictStr
    description: Optional[StrictStr] = None
    status: ProjectStatus
    created_by_id: StrictStr = Field(alias="createdById")
    workspace_id: StrictStr = Field(alias="workspaceId")
    moderator_id: StrictStr = Field(alias="moderatorId")
    config: ProjectConfig
    conversation_config: ProjectConversationConfig = Field(alias="conversationConfig")
    analysis: Optional[ProjectAnalysis] = None
    created_by: Optional[User] = Field(default=None, alias="createdBy")
    workspace: Optional[Workspace] = None
    moderator: Optional[Moderator] = None
    invites: Optional[List[Invite]] = None
    chat_sessions: Optional[List[ChatSession]] = Field(default=None, alias="chatSessions")
    project_files: Optional[List[ProjectFile]] = Field(default=None, alias="projectFiles")
    threads: Optional[List[Thread]] = None
    attribute_kind_group: Optional[List[AttributeKindGroup]] = Field(default=None, alias="AttributeKindGroup")
    artifacts: Optional[List[Artifact]] = None
    artifact_version_group: Optional[List[ArtifactVersionGroup]] = Field(default=None, alias="ArtifactVersionGroup")
    __properties: ClassVar[List[str]] = ["id", "createdAt", "updatedAt", "name", "description", "status", "createdById", "workspaceId", "moderatorId", "config", "conversationConfig", "analysis", "createdBy", "workspace", "moderator", "invites", "chatSessions", "projectFiles", "threads", "AttributeKindGroup", "artifacts", "ArtifactVersionGroup"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Project from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conversation_config
        if self.conversation_config:
            _dict['conversationConfig'] = self.conversation_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of analysis
        if self.analysis:
            _dict['analysis'] = self.analysis.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workspace
        if self.workspace:
            _dict['workspace'] = self.workspace.to_dict()
        # override the default output from pydantic by calling `to_dict()` of moderator
        if self.moderator:
            _dict['moderator'] = self.moderator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in invites (list)
        _items = []
        if self.invites:
            for _item_invites in self.invites:
                if _item_invites:
                    _items.append(_item_invites.to_dict())
            _dict['invites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in chat_sessions (list)
        _items = []
        if self.chat_sessions:
            for _item_chat_sessions in self.chat_sessions:
                if _item_chat_sessions:
                    _items.append(_item_chat_sessions.to_dict())
            _dict['chatSessions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in project_files (list)
        _items = []
        if self.project_files:
            for _item_project_files in self.project_files:
                if _item_project_files:
                    _items.append(_item_project_files.to_dict())
            _dict['projectFiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in threads (list)
        _items = []
        if self.threads:
            for _item_threads in self.threads:
                if _item_threads:
                    _items.append(_item_threads.to_dict())
            _dict['threads'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attribute_kind_group (list)
        _items = []
        if self.attribute_kind_group:
            for _item_attribute_kind_group in self.attribute_kind_group:
                if _item_attribute_kind_group:
                    _items.append(_item_attribute_kind_group.to_dict())
            _dict['AttributeKindGroup'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in artifacts (list)
        _items = []
        if self.artifacts:
            for _item_artifacts in self.artifacts:
                if _item_artifacts:
                    _items.append(_item_artifacts.to_dict())
            _dict['artifacts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in artifact_version_group (list)
        _items = []
        if self.artifact_version_group:
            for _item_artifact_version_group in self.artifact_version_group:
                if _item_artifact_version_group:
                    _items.append(_item_artifact_version_group.to_dict())
            _dict['ArtifactVersionGroup'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if analysis (nullable) is None
        # and model_fields_set contains the field
        if self.analysis is None and "analysis" in self.model_fields_set:
            _dict['analysis'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Project from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "createdById": obj.get("createdById"),
            "workspaceId": obj.get("workspaceId"),
            "moderatorId": obj.get("moderatorId"),
            "config": ProjectConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "conversationConfig": ProjectConversationConfig.from_dict(obj["conversationConfig"]) if obj.get("conversationConfig") is not None else None,
            "analysis": ProjectAnalysis.from_dict(obj["analysis"]) if obj.get("analysis") is not None else None,
            "createdBy": User.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "workspace": Workspace.from_dict(obj["workspace"]) if obj.get("workspace") is not None else None,
            "moderator": Moderator.from_dict(obj["moderator"]) if obj.get("moderator") is not None else None,
            "invites": [Invite.from_dict(_item) for _item in obj["invites"]] if obj.get("invites") is not None else None,
            "chatSessions": [ChatSession.from_dict(_item) for _item in obj["chatSessions"]] if obj.get("chatSessions") is not None else None,
            "projectFiles": [ProjectFile.from_dict(_item) for _item in obj["projectFiles"]] if obj.get("projectFiles") is not None else None,
            "threads": [Thread.from_dict(_item) for _item in obj["threads"]] if obj.get("threads") is not None else None,
            "AttributeKindGroup": [AttributeKindGroup.from_dict(_item) for _item in obj["AttributeKindGroup"]] if obj.get("AttributeKindGroup") is not None else None,
            "artifacts": [Artifact.from_dict(_item) for _item in obj["artifacts"]] if obj.get("artifacts") is not None else None,
            "ArtifactVersionGroup": [ArtifactVersionGroup.from_dict(_item) for _item in obj["ArtifactVersionGroup"]] if obj.get("ArtifactVersionGroup") is not None else None
        })
        return _obj

from keplar_api.models.artifact import Artifact
from keplar_api.models.artifact_version_group import ArtifactVersionGroup
from keplar_api.models.attribute_kind_group import AttributeKindGroup
from keplar_api.models.chat_session import ChatSession
from keplar_api.models.invite import Invite
from keplar_api.models.moderator import Moderator
from keplar_api.models.project_file import ProjectFile
from keplar_api.models.thread import Thread
from keplar_api.models.user import User
from keplar_api.models.workspace import Workspace
# TODO: Rewrite to not use raise_errors
Project.model_rebuild(raise_errors=False)

