# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from keplar_api.models.panel_settings import PanelSettings
from keplar_api.models.participant_create import ParticipantCreate
from typing import Optional, Set
from typing_extensions import Self

class ProjectAudience(BaseModel):
    """
    ProjectAudience
    """ # noqa: E501
    sample_size: Union[StrictFloat, StrictInt] = Field(alias="sampleSize")
    invite_title: Optional[StrictStr] = Field(default=None, alias="inviteTitle")
    invite_description: Optional[StrictStr] = Field(default=None, alias="inviteDescription")
    participants: Optional[List[ParticipantCreate]] = None
    panel_settings: Optional[PanelSettings] = Field(default=None, alias="panelSettings")
    use_public_link: Optional[StrictBool] = Field(default=None, alias="usePublicLink")
    __properties: ClassVar[List[str]] = ["sampleSize", "inviteTitle", "inviteDescription", "participants", "panelSettings", "usePublicLink"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectAudience from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in participants (list)
        _items = []
        if self.participants:
            for _item_participants in self.participants:
                if _item_participants:
                    _items.append(_item_participants.to_dict())
            _dict['participants'] = _items
        # override the default output from pydantic by calling `to_dict()` of panel_settings
        if self.panel_settings:
            _dict['panelSettings'] = self.panel_settings.to_dict()
        # set to None if participants (nullable) is None
        # and model_fields_set contains the field
        if self.participants is None and "participants" in self.model_fields_set:
            _dict['participants'] = None

        # set to None if panel_settings (nullable) is None
        # and model_fields_set contains the field
        if self.panel_settings is None and "panel_settings" in self.model_fields_set:
            _dict['panelSettings'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectAudience from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sampleSize": obj.get("sampleSize"),
            "inviteTitle": obj.get("inviteTitle"),
            "inviteDescription": obj.get("inviteDescription"),
            "participants": [ParticipantCreate.from_dict(_item) for _item in obj["participants"]] if obj.get("participants") is not None else None,
            "panelSettings": PanelSettings.from_dict(obj["panelSettings"]) if obj.get("panelSettings") is not None else None,
            "usePublicLink": obj.get("usePublicLink")
        })
        return _obj


