# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.project_file_category import ProjectFileCategory
from keplar_api.models.project_file_metadata import ProjectFileMetadata
from typing import Optional, Set
from typing_extensions import Self

class ProjectFile(BaseModel):
    """
    ProjectFile
    """ # noqa: E501
    id: StrictStr
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    project_id: StrictStr = Field(alias="projectId")
    file_id: StrictStr = Field(alias="fileId")
    description: Optional[StrictStr] = None
    category: Optional[ProjectFileCategory] = None
    metadata: Optional[ProjectFileMetadata] = None
    project: Optional[Project] = None
    file: Optional[File] = None
    __properties: ClassVar[List[str]] = ["id", "createdAt", "updatedAt", "projectId", "fileId", "description", "category", "metadata", "project", "file"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "projectId": obj.get("projectId"),
            "fileId": obj.get("fileId"),
            "description": obj.get("description"),
            "category": obj.get("category"),
            "metadata": ProjectFileMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "file": File.from_dict(obj["file"]) if obj.get("file") is not None else None
        })
        return _obj

from keplar_api.models.file import File
from keplar_api.models.project import Project
# TODO: Rewrite to not use raise_errors
ProjectFile.model_rebuild(raise_errors=False)

