# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.file_mime_type import FileMimeType
from typing import Optional, Set
from typing_extensions import Self

class ProjectFilePublicFile(BaseModel):
    """
    ProjectFilePublicFile
    """ # noqa: E501
    description: Optional[StrictStr] = None
    mime_type: FileMimeType = Field(alias="mimeType")
    public_url: Optional[StrictStr] = Field(default=None, alias="publicUrl")
    public_url_expires_at: Optional[datetime] = Field(default=None, alias="publicUrlExpiresAt")
    __properties: ClassVar[List[str]] = ["description", "mimeType", "publicUrl", "publicUrlExpiresAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectFilePublicFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if public_url (nullable) is None
        # and model_fields_set contains the field
        if self.public_url is None and "public_url" in self.model_fields_set:
            _dict['publicUrl'] = None

        # set to None if public_url_expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.public_url_expires_at is None and "public_url_expires_at" in self.model_fields_set:
            _dict['publicUrlExpiresAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectFilePublicFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "mimeType": obj.get("mimeType"),
            "publicUrl": obj.get("publicUrl"),
            "publicUrlExpiresAt": obj.get("publicUrlExpiresAt")
        })
        return _obj


