# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from keplar_api.models.repdata_qualification_allowed_option_ids_inner import RepdataQualificationAllowedOptionIdsInner
from typing import Optional, Set
from typing_extensions import Self

class RepdataQualification(BaseModel):
    """
    RepdataQualification
    """ # noqa: E501
    question_id: Union[StrictFloat, StrictInt]
    allowed_option_ids: List[RepdataQualificationAllowedOptionIdsInner]
    __properties: ClassVar[List[str]] = ["question_id", "allowed_option_ids"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepdataQualification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in allowed_option_ids (list)
        _items = []
        if self.allowed_option_ids:
            for _item_allowed_option_ids in self.allowed_option_ids:
                if _item_allowed_option_ids:
                    _items.append(_item_allowed_option_ids.to_dict())
            _dict['allowed_option_ids'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepdataQualification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "question_id": obj.get("question_id"),
            "allowed_option_ids": [RepdataQualificationAllowedOptionIdsInner.from_dict(_item) for _item in obj["allowed_option_ids"]] if obj.get("allowed_option_ids") is not None else None
        })
        return _obj


