# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List
from keplar_api.models.repdata_respondent_attribute import RepdataRespondentAttribute
from keplar_api.models.repdata_survey_attributes import RepdataSurveyAttributes
from typing import Optional, Set
from typing_extensions import Self

class RepdataSurvey(BaseModel):
    """
    RepdataSurvey
    """ # noqa: E501
    id: StrictStr
    project_id: StrictStr
    name: StrictStr
    status: StrictStr
    survey_attributes: RepdataSurveyAttributes
    respondent_attributes: List[RepdataRespondentAttribute]
    __properties: ClassVar[List[str]] = ["id", "project_id", "name", "status", "survey_attributes", "respondent_attributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepdataSurvey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of survey_attributes
        if self.survey_attributes:
            _dict['survey_attributes'] = self.survey_attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in respondent_attributes (list)
        _items = []
        if self.respondent_attributes:
            for _item_respondent_attributes in self.respondent_attributes:
                if _item_respondent_attributes:
                    _items.append(_item_respondent_attributes.to_dict())
            _dict['respondent_attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepdataSurvey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "project_id": obj.get("project_id"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "survey_attributes": RepdataSurveyAttributes.from_dict(obj["survey_attributes"]) if obj.get("survey_attributes") is not None else None,
            "respondent_attributes": [RepdataRespondentAttribute.from_dict(_item) for _item in obj["respondent_attributes"]] if obj.get("respondent_attributes") is not None else None
        })
        return _obj


