# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from keplar_api.models.repdata_survey_redirects import RepdataSurveyRedirects
from typing import Optional, Set
from typing_extensions import Self

class RepdataSurveyAttributes(BaseModel):
    """
    RepdataSurveyAttributes
    """ # noqa: E501
    respondents: Union[StrictFloat, StrictInt]
    country_code: StrictStr
    language_code: StrictStr
    length_of_interview: Union[StrictFloat, StrictInt]
    incidence_rate: Union[StrictFloat, StrictInt]
    minimum_price_per_complete: Union[StrictFloat, StrictInt]
    offered_price_per_complete: Union[StrictFloat, StrictInt]
    device_compatibilities: List[StrictStr]
    collects_pii: StrictBool
    hashing_enabled: StrictBool
    calculation_type: StrictStr
    traffic_control_limit_type: StrictStr
    out_of_field_date: StrictStr
    out_of_field_timezone: StrictStr
    entry_link: StrictStr
    redirects: RepdataSurveyRedirects
    __properties: ClassVar[List[str]] = ["respondents", "country_code", "language_code", "length_of_interview", "incidence_rate", "minimum_price_per_complete", "offered_price_per_complete", "device_compatibilities", "collects_pii", "hashing_enabled", "calculation_type", "traffic_control_limit_type", "out_of_field_date", "out_of_field_timezone", "entry_link", "redirects"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepdataSurveyAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of redirects
        if self.redirects:
            _dict['redirects'] = self.redirects.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepdataSurveyAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "respondents": obj.get("respondents"),
            "country_code": obj.get("country_code"),
            "language_code": obj.get("language_code"),
            "length_of_interview": obj.get("length_of_interview"),
            "incidence_rate": obj.get("incidence_rate"),
            "minimum_price_per_complete": obj.get("minimum_price_per_complete"),
            "offered_price_per_complete": obj.get("offered_price_per_complete"),
            "device_compatibilities": obj.get("device_compatibilities"),
            "collects_pii": obj.get("collects_pii"),
            "hashing_enabled": obj.get("hashing_enabled"),
            "calculation_type": obj.get("calculation_type"),
            "traffic_control_limit_type": obj.get("traffic_control_limit_type"),
            "out_of_field_date": obj.get("out_of_field_date"),
            "out_of_field_timezone": obj.get("out_of_field_timezone"),
            "entry_link": obj.get("entry_link"),
            "redirects": RepdataSurveyRedirects.from_dict(obj["redirects"]) if obj.get("redirects") is not None else None
        })
        return _obj


