# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from keplar_api.models.screener_question_choose_multiple_options_value import ScreenerQuestionChooseMultipleOptionsValue
from typing import Optional, Set
from typing_extensions import Self

class ScreenerQuestionChooseMultiple(BaseModel):
    """
    ScreenerQuestionChooseMultiple
    """ # noqa: E501
    type: StrictStr
    question: StrictStr
    image_file_id: Optional[Annotated[str, Field(strict=True, max_length=36)]] = Field(default=None, description="File ID for question image", alias="imageFileId")
    options: Dict[str, ScreenerQuestionChooseMultipleOptionsValue]
    min_passing_options: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(alias="minPassingOptions")
    randomize_order: Optional[StrictBool] = Field(default=None, alias="randomizeOrder")
    show_select_all_of_above: StrictBool = Field(alias="showSelectAllOfAbove")
    show_select_none_of_above: StrictBool = Field(alias="showSelectNoneOfAbove")
    __properties: ClassVar[List[str]] = ["type", "question", "imageFileId", "options", "minPassingOptions", "randomizeOrder", "showSelectAllOfAbove", "showSelectNoneOfAbove"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['chooseMultiple']):
            raise ValueError("must be one of enum values ('chooseMultiple')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScreenerQuestionChooseMultiple from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in options (dict)
        _field_dict = {}
        if self.options:
            for _key_options in self.options:
                if self.options[_key_options]:
                    _field_dict[_key_options] = self.options[_key_options].to_dict()
            _dict['options'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScreenerQuestionChooseMultiple from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "question": obj.get("question"),
            "imageFileId": obj.get("imageFileId"),
            "options": dict(
                (_k, ScreenerQuestionChooseMultipleOptionsValue.from_dict(_v))
                for _k, _v in obj["options"].items()
            )
            if obj.get("options") is not None
            else None,
            "minPassingOptions": obj.get("minPassingOptions"),
            "randomizeOrder": obj.get("randomizeOrder"),
            "showSelectAllOfAbove": obj.get("showSelectAllOfAbove"),
            "showSelectNoneOfAbove": obj.get("showSelectNoneOfAbove")
        })
        return _obj


