# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from keplar_api.models.share_entity_config import ShareEntityConfig
from keplar_api.models.share_entity_created_by_kind import ShareEntityCreatedByKind
from keplar_api.models.share_entity_kind import ShareEntityKind
from typing import Optional, Set
from typing_extensions import Self

class ShareEntity(BaseModel):
    """
    ShareEntity
    """ # noqa: E501
    id: StrictStr
    token: StrictStr
    entity_kind: ShareEntityKind = Field(alias="entityKind")
    entity_id: StrictStr = Field(alias="entityId")
    created_at: datetime = Field(alias="createdAt")
    expires_at: Optional[datetime] = Field(default=None, alias="expiresAt")
    access_count: Union[StrictFloat, StrictInt] = Field(alias="accessCount")
    is_active: StrictBool = Field(alias="isActive")
    created_by_kind: Optional[ShareEntityCreatedByKind] = Field(default=None, alias="createdByKind")
    created_by_id: Optional[StrictStr] = Field(default=None, alias="createdById")
    config: ShareEntityConfig
    email_shares: Optional[List[EmailShare]] = Field(default=None, alias="emailShares")
    __properties: ClassVar[List[str]] = ["id", "token", "entityKind", "entityId", "createdAt", "expiresAt", "accessCount", "isActive", "createdByKind", "createdById", "config", "emailShares"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShareEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in email_shares (list)
        _items = []
        if self.email_shares:
            for _item_email_shares in self.email_shares:
                if _item_email_shares:
                    _items.append(_item_email_shares.to_dict())
            _dict['emailShares'] = _items
        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expiresAt'] = None

        # set to None if created_by_kind (nullable) is None
        # and model_fields_set contains the field
        if self.created_by_kind is None and "created_by_kind" in self.model_fields_set:
            _dict['createdByKind'] = None

        # set to None if created_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.created_by_id is None and "created_by_id" in self.model_fields_set:
            _dict['createdById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShareEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "token": obj.get("token"),
            "entityKind": obj.get("entityKind"),
            "entityId": obj.get("entityId"),
            "createdAt": obj.get("createdAt"),
            "expiresAt": obj.get("expiresAt"),
            "accessCount": obj.get("accessCount"),
            "isActive": obj.get("isActive"),
            "createdByKind": obj.get("createdByKind"),
            "createdById": obj.get("createdById"),
            "config": ShareEntityConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "emailShares": [EmailShare.from_dict(_item) for _item in obj["emailShares"]] if obj.get("emailShares") is not None else None
        })
        return _obj

from keplar_api.models.email_share import EmailShare
# TODO: Rewrite to not use raise_errors
ShareEntity.model_rebuild(raise_errors=False)

