# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.thematic_analysis_artifact_create_data_themes_inner import ThematicAnalysisArtifactCreateDataThemesInner
from keplar_api.models.thematic_analysis_response_code import ThematicAnalysisResponseCode
from typing import Optional, Set
from typing_extensions import Self

class ThematicAnalysisArtifactCreateData(BaseModel):
    """
    ThematicAnalysisArtifactCreateData
    """ # noqa: E501
    kind: StrictStr
    query: Optional[StrictStr] = None
    summary: Optional[StrictStr] = None
    themes: List[ThematicAnalysisArtifactCreateDataThemesInner]
    coded_responses: List[ThematicAnalysisResponseCode] = Field(alias="codedResponses")
    __properties: ClassVar[List[str]] = ["kind", "query", "summary", "themes", "codedResponses"]

    @field_validator('kind')
    def kind_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['thematic_analysis']):
            raise ValueError("must be one of enum values ('thematic_analysis')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ThematicAnalysisArtifactCreateData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in themes (list)
        _items = []
        if self.themes:
            for _item_themes in self.themes:
                if _item_themes:
                    _items.append(_item_themes.to_dict())
            _dict['themes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in coded_responses (list)
        _items = []
        if self.coded_responses:
            for _item_coded_responses in self.coded_responses:
                if _item_coded_responses:
                    _items.append(_item_coded_responses.to_dict())
            _dict['codedResponses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ThematicAnalysisArtifactCreateData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "kind": obj.get("kind"),
            "query": obj.get("query"),
            "summary": obj.get("summary"),
            "themes": [ThematicAnalysisArtifactCreateDataThemesInner.from_dict(_item) for _item in obj["themes"]] if obj.get("themes") is not None else None,
            "codedResponses": [ThematicAnalysisResponseCode.from_dict(_item) for _item in obj["codedResponses"]] if obj.get("codedResponses") is not None else None
        })
        return _obj


