# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.thread_kind import ThreadKind
from keplar_api.models.thread_metadata import ThreadMetadata
from typing import Optional, Set
from typing_extensions import Self

class Thread(BaseModel):
    """
    Thread
    """ # noqa: E501
    id: StrictStr
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    name: StrictStr
    kind: Optional[ThreadKind] = None
    description: Optional[StrictStr] = None
    metadata: Optional[ThreadMetadata] = None
    created_by_id: StrictStr = Field(alias="createdById")
    workspace_id: StrictStr = Field(alias="workspaceId")
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    created_by: Optional[User] = Field(default=None, alias="createdBy")
    workspace: Optional[Workspace] = None
    project: Optional[Project] = None
    thread_files: Optional[List[ThreadFile]] = Field(default=None, alias="threadFiles")
    __properties: ClassVar[List[str]] = ["id", "createdAt", "updatedAt", "name", "kind", "description", "metadata", "createdById", "workspaceId", "projectId", "createdBy", "workspace", "project", "threadFiles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Thread from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workspace
        if self.workspace:
            _dict['workspace'] = self.workspace.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in thread_files (list)
        _items = []
        if self.thread_files:
            for _item_thread_files in self.thread_files:
                if _item_thread_files:
                    _items.append(_item_thread_files.to_dict())
            _dict['threadFiles'] = _items
        # set to None if kind (nullable) is None
        # and model_fields_set contains the field
        if self.kind is None and "kind" in self.model_fields_set:
            _dict['kind'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if project_id (nullable) is None
        # and model_fields_set contains the field
        if self.project_id is None and "project_id" in self.model_fields_set:
            _dict['projectId'] = None

        # set to None if project (nullable) is None
        # and model_fields_set contains the field
        if self.project is None and "project" in self.model_fields_set:
            _dict['project'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Thread from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "name": obj.get("name"),
            "kind": obj.get("kind"),
            "description": obj.get("description"),
            "metadata": ThreadMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "createdById": obj.get("createdById"),
            "workspaceId": obj.get("workspaceId"),
            "projectId": obj.get("projectId"),
            "createdBy": User.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "workspace": Workspace.from_dict(obj["workspace"]) if obj.get("workspace") is not None else None,
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "threadFiles": [ThreadFile.from_dict(_item) for _item in obj["threadFiles"]] if obj.get("threadFiles") is not None else None
        })
        return _obj

from keplar_api.models.project import Project
from keplar_api.models.thread_file import ThreadFile
from keplar_api.models.user import User
from keplar_api.models.workspace import Workspace
# TODO: Rewrite to not use raise_errors
Thread.model_rebuild(raise_errors=False)

