# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.project_brief import ProjectBrief
from typing import Optional, Set
from typing_extensions import Self

class ThreadMetadata(BaseModel):
    """
    ThreadMetadata
    """ # noqa: E501
    status: Optional[StrictStr] = None
    project_brief_drafts: Optional[List[ProjectBrief]] = Field(default=None, alias="projectBriefDrafts")
    __properties: ClassVar[List[str]] = ["status", "projectBriefDrafts"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['draft', 'completed']):
            raise ValueError("must be one of enum values ('draft', 'completed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ThreadMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in project_brief_drafts (list)
        _items = []
        if self.project_brief_drafts:
            for _item_project_brief_drafts in self.project_brief_drafts:
                if _item_project_brief_drafts:
                    _items.append(_item_project_brief_drafts.to_dict())
            _dict['projectBriefDrafts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ThreadMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "projectBriefDrafts": [ProjectBrief.from_dict(_item) for _item in obj["projectBriefDrafts"]] if obj.get("projectBriefDrafts") is not None else None
        })
        return _obj


