# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from keplar_api.models.artifact import Artifact
from keplar_api.models.attribute_kind_group import AttributeKindGroup
from keplar_api.models.chat_session import ChatSession
from keplar_api.models.feature_config import FeatureConfig
from keplar_api.models.file import File
from keplar_api.models.invite import Invite
from keplar_api.models.moderator import Moderator
from keplar_api.models.org import Org
from keplar_api.models.project import Project
from keplar_api.models.thread import Thread
from keplar_api.models.token_kind import TokenKind
from keplar_api.models.user_account_status import UserAccountStatus
from keplar_api.models.user_data import UserData
from keplar_api.models.user_provider import UserProvider
from keplar_api.models.workspace import Workspace
from keplar_api.models.workspace_member import WorkspaceMember
from typing import Optional, Set
from typing_extensions import Self

class UserWithConfig(BaseModel):
    """
    UserWithConfig
    """ # noqa: E501
    id: StrictStr
    seq: Union[StrictFloat, StrictInt]
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    provider: UserProvider
    user_id: StrictStr = Field(alias="userId")
    email: StrictStr
    name: StrictStr
    account_status: UserAccountStatus = Field(alias="accountStatus")
    location: Optional[StrictStr] = None
    profile_image_url: Optional[StrictStr] = Field(default=None, alias="profileImageUrl")
    data: Optional[UserData] = None
    password_hash: Optional[StrictStr] = Field(default=None, alias="passwordHash")
    email_verified_at: Optional[datetime] = Field(default=None, alias="emailVerifiedAt")
    token: Optional[StrictStr] = None
    token_kind: Optional[TokenKind] = Field(default=None, alias="tokenKind")
    token_expiry: Optional[datetime] = Field(default=None, alias="tokenExpiry")
    org_id: Optional[StrictStr] = Field(default=None, alias="orgId")
    default_workspace_id: StrictStr = Field(alias="defaultWorkspaceId")
    org: Optional[Org] = None
    default_workspace: Optional[Workspace] = Field(default=None, alias="defaultWorkspace")
    workspace_members: Optional[List[WorkspaceMember]] = Field(default=None, alias="workspaceMembers")
    projects: Optional[List[Project]] = None
    invites: Optional[List[Invite]] = None
    chat_sessions: Optional[List[ChatSession]] = Field(default=None, alias="chatSessions")
    moderators: Optional[List[Moderator]] = None
    uploaded_files: Optional[List[File]] = Field(default=None, alias="uploadedFiles")
    threads: Optional[List[Thread]] = None
    attribute_kind_group: Optional[List[AttributeKindGroup]] = Field(default=None, alias="AttributeKindGroup")
    artifact: Optional[List[Artifact]] = Field(default=None, alias="Artifact")
    feature_config: Optional[FeatureConfig] = Field(default=None, alias="featureConfig")
    __properties: ClassVar[List[str]] = ["id", "seq", "createdAt", "updatedAt", "provider", "userId", "email", "name", "accountStatus", "location", "profileImageUrl", "data", "passwordHash", "emailVerifiedAt", "token", "tokenKind", "tokenExpiry", "orgId", "defaultWorkspaceId", "org", "defaultWorkspace", "workspaceMembers", "projects", "invites", "chatSessions", "moderators", "uploadedFiles", "threads", "AttributeKindGroup", "Artifact", "featureConfig"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserWithConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of org
        if self.org:
            _dict['org'] = self.org.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_workspace
        if self.default_workspace:
            _dict['defaultWorkspace'] = self.default_workspace.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in workspace_members (list)
        _items = []
        if self.workspace_members:
            for _item_workspace_members in self.workspace_members:
                if _item_workspace_members:
                    _items.append(_item_workspace_members.to_dict())
            _dict['workspaceMembers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item_projects in self.projects:
                if _item_projects:
                    _items.append(_item_projects.to_dict())
            _dict['projects'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in invites (list)
        _items = []
        if self.invites:
            for _item_invites in self.invites:
                if _item_invites:
                    _items.append(_item_invites.to_dict())
            _dict['invites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in chat_sessions (list)
        _items = []
        if self.chat_sessions:
            for _item_chat_sessions in self.chat_sessions:
                if _item_chat_sessions:
                    _items.append(_item_chat_sessions.to_dict())
            _dict['chatSessions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in moderators (list)
        _items = []
        if self.moderators:
            for _item_moderators in self.moderators:
                if _item_moderators:
                    _items.append(_item_moderators.to_dict())
            _dict['moderators'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in uploaded_files (list)
        _items = []
        if self.uploaded_files:
            for _item_uploaded_files in self.uploaded_files:
                if _item_uploaded_files:
                    _items.append(_item_uploaded_files.to_dict())
            _dict['uploadedFiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in threads (list)
        _items = []
        if self.threads:
            for _item_threads in self.threads:
                if _item_threads:
                    _items.append(_item_threads.to_dict())
            _dict['threads'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attribute_kind_group (list)
        _items = []
        if self.attribute_kind_group:
            for _item_attribute_kind_group in self.attribute_kind_group:
                if _item_attribute_kind_group:
                    _items.append(_item_attribute_kind_group.to_dict())
            _dict['AttributeKindGroup'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in artifact (list)
        _items = []
        if self.artifact:
            for _item_artifact in self.artifact:
                if _item_artifact:
                    _items.append(_item_artifact.to_dict())
            _dict['Artifact'] = _items
        # override the default output from pydantic by calling `to_dict()` of feature_config
        if self.feature_config:
            _dict['featureConfig'] = self.feature_config.to_dict()
        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if profile_image_url (nullable) is None
        # and model_fields_set contains the field
        if self.profile_image_url is None and "profile_image_url" in self.model_fields_set:
            _dict['profileImageUrl'] = None

        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        # set to None if password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.password_hash is None and "password_hash" in self.model_fields_set:
            _dict['passwordHash'] = None

        # set to None if email_verified_at (nullable) is None
        # and model_fields_set contains the field
        if self.email_verified_at is None and "email_verified_at" in self.model_fields_set:
            _dict['emailVerifiedAt'] = None

        # set to None if token (nullable) is None
        # and model_fields_set contains the field
        if self.token is None and "token" in self.model_fields_set:
            _dict['token'] = None

        # set to None if token_kind (nullable) is None
        # and model_fields_set contains the field
        if self.token_kind is None and "token_kind" in self.model_fields_set:
            _dict['tokenKind'] = None

        # set to None if token_expiry (nullable) is None
        # and model_fields_set contains the field
        if self.token_expiry is None and "token_expiry" in self.model_fields_set:
            _dict['tokenExpiry'] = None

        # set to None if org_id (nullable) is None
        # and model_fields_set contains the field
        if self.org_id is None and "org_id" in self.model_fields_set:
            _dict['orgId'] = None

        # set to None if org (nullable) is None
        # and model_fields_set contains the field
        if self.org is None and "org" in self.model_fields_set:
            _dict['org'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserWithConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "seq": obj.get("seq"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "provider": obj.get("provider"),
            "userId": obj.get("userId"),
            "email": obj.get("email"),
            "name": obj.get("name"),
            "accountStatus": obj.get("accountStatus"),
            "location": obj.get("location"),
            "profileImageUrl": obj.get("profileImageUrl"),
            "data": UserData.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "passwordHash": obj.get("passwordHash"),
            "emailVerifiedAt": obj.get("emailVerifiedAt"),
            "token": obj.get("token"),
            "tokenKind": obj.get("tokenKind"),
            "tokenExpiry": obj.get("tokenExpiry"),
            "orgId": obj.get("orgId"),
            "defaultWorkspaceId": obj.get("defaultWorkspaceId"),
            "org": Org.from_dict(obj["org"]) if obj.get("org") is not None else None,
            "defaultWorkspace": Workspace.from_dict(obj["defaultWorkspace"]) if obj.get("defaultWorkspace") is not None else None,
            "workspaceMembers": [WorkspaceMember.from_dict(_item) for _item in obj["workspaceMembers"]] if obj.get("workspaceMembers") is not None else None,
            "projects": [Project.from_dict(_item) for _item in obj["projects"]] if obj.get("projects") is not None else None,
            "invites": [Invite.from_dict(_item) for _item in obj["invites"]] if obj.get("invites") is not None else None,
            "chatSessions": [ChatSession.from_dict(_item) for _item in obj["chatSessions"]] if obj.get("chatSessions") is not None else None,
            "moderators": [Moderator.from_dict(_item) for _item in obj["moderators"]] if obj.get("moderators") is not None else None,
            "uploadedFiles": [File.from_dict(_item) for _item in obj["uploadedFiles"]] if obj.get("uploadedFiles") is not None else None,
            "threads": [Thread.from_dict(_item) for _item in obj["threads"]] if obj.get("threads") is not None else None,
            "AttributeKindGroup": [AttributeKindGroup.from_dict(_item) for _item in obj["AttributeKindGroup"]] if obj.get("AttributeKindGroup") is not None else None,
            "Artifact": [Artifact.from_dict(_item) for _item in obj["Artifact"]] if obj.get("Artifact") is not None else None,
            "featureConfig": FeatureConfig.from_dict(obj["featureConfig"]) if obj.get("featureConfig") is not None else None
        })
        return _obj


