# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Workspace(BaseModel):
    """
    Workspace
    """ # noqa: E501
    id: StrictStr
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    name: StrictStr
    projects: Optional[List[Project]] = None
    participants: Optional[List[Participant]] = None
    moderators: Optional[List[Moderator]] = None
    files: Optional[List[File]] = None
    threads: Optional[List[Thread]] = None
    attribute_kind_groups: Optional[List[AttributeKindGroup]] = Field(default=None, alias="attributeKindGroups")
    workspace_members: Optional[List[WorkspaceMember]] = Field(default=None, alias="workspaceMembers")
    default_for_users: Optional[List[User]] = Field(default=None, alias="defaultForUsers")
    __properties: ClassVar[List[str]] = ["id", "createdAt", "updatedAt", "name", "projects", "participants", "moderators", "files", "threads", "attributeKindGroups", "workspaceMembers", "defaultForUsers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Workspace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item_projects in self.projects:
                if _item_projects:
                    _items.append(_item_projects.to_dict())
            _dict['projects'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in participants (list)
        _items = []
        if self.participants:
            for _item_participants in self.participants:
                if _item_participants:
                    _items.append(_item_participants.to_dict())
            _dict['participants'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in moderators (list)
        _items = []
        if self.moderators:
            for _item_moderators in self.moderators:
                if _item_moderators:
                    _items.append(_item_moderators.to_dict())
            _dict['moderators'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files:
                    _items.append(_item_files.to_dict())
            _dict['files'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in threads (list)
        _items = []
        if self.threads:
            for _item_threads in self.threads:
                if _item_threads:
                    _items.append(_item_threads.to_dict())
            _dict['threads'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attribute_kind_groups (list)
        _items = []
        if self.attribute_kind_groups:
            for _item_attribute_kind_groups in self.attribute_kind_groups:
                if _item_attribute_kind_groups:
                    _items.append(_item_attribute_kind_groups.to_dict())
            _dict['attributeKindGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in workspace_members (list)
        _items = []
        if self.workspace_members:
            for _item_workspace_members in self.workspace_members:
                if _item_workspace_members:
                    _items.append(_item_workspace_members.to_dict())
            _dict['workspaceMembers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in default_for_users (list)
        _items = []
        if self.default_for_users:
            for _item_default_for_users in self.default_for_users:
                if _item_default_for_users:
                    _items.append(_item_default_for_users.to_dict())
            _dict['defaultForUsers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Workspace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "name": obj.get("name"),
            "projects": [Project.from_dict(_item) for _item in obj["projects"]] if obj.get("projects") is not None else None,
            "participants": [Participant.from_dict(_item) for _item in obj["participants"]] if obj.get("participants") is not None else None,
            "moderators": [Moderator.from_dict(_item) for _item in obj["moderators"]] if obj.get("moderators") is not None else None,
            "files": [File.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None,
            "threads": [Thread.from_dict(_item) for _item in obj["threads"]] if obj.get("threads") is not None else None,
            "attributeKindGroups": [AttributeKindGroup.from_dict(_item) for _item in obj["attributeKindGroups"]] if obj.get("attributeKindGroups") is not None else None,
            "workspaceMembers": [WorkspaceMember.from_dict(_item) for _item in obj["workspaceMembers"]] if obj.get("workspaceMembers") is not None else None,
            "defaultForUsers": [User.from_dict(_item) for _item in obj["defaultForUsers"]] if obj.get("defaultForUsers") is not None else None
        })
        return _obj

from keplar_api.models.attribute_kind_group import AttributeKindGroup
from keplar_api.models.file import File
from keplar_api.models.moderator import Moderator
from keplar_api.models.participant import Participant
from keplar_api.models.project import Project
from keplar_api.models.thread import Thread
from keplar_api.models.user import User
from keplar_api.models.workspace_member import WorkspaceMember
# TODO: Rewrite to not use raise_errors
Workspace.model_rebuild(raise_errors=False)

