
treem - Neuron Morphology Processing Tool
=========================================

The `treem` module (pronounced "trim") provides data structures and
command-line tools for accessing and manipulating digital reconstructions
of neuronal morphology in the Stockley-Wheal-Cannon (SWC) format.

[![PyPI - Version](https://img.shields.io/pypi/v/treem)](https://pypi.org/project/treem/)
[![Python Versions Tested](https://img.shields.io/badge/python-3.9%20%7C%203.12-blue.svg)](https://www.python.org/)
[![License: MIT](https://img.shields.io/badge/License-MIT-brightgreen.svg)](https://github.com/a1eko/treem/blob/master/LICENSE)

[![Build Status](https://github.com/a1eko/treem/actions/workflows/build.yml/badge.svg)](https://github.com/a1eko/treem/actions/workflows/build.yml)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=a1eko_treem&metric=alert_status)](https://sonarcloud.io/dashboard?id=a1eko_treem)
[![codecov.io](https://codecov.io/gh/a1eko/treem/coverage.svg)](https://codecov.io/gh/a1eko/treem)
[![Documentation Status](https://readthedocs.org/projects/treem/badge/?version=latest)](https://treem.readthedocs.io/en/latest/?badge=latest)

![Linux](https://img.shields.io/badge/tested%20on-Linux-fcc624?style=flat&logo=linux&logoColor=black)
![macOS](https://img.shields.io/badge/tested%20on-macOS-000000?style=flat&logo=apple&logoColor=white)
![Windows](https://img.shields.io/badge/tested%20on-Windows-0078D4?style=flat&logo=windows&logoColor=white)

[![Citation](https://zenodo.org/badge/DOI/10.5281/zenodo.4890844.svg)](https://doi.org/10.5281/zenodo.4890844)

Main classes
------------

Access to morphological data from the source code is provided through the
classes ``Tree``, ``Node``, ``Morph``, and ``SWC``:

* ``Tree``   - recursive tree data structure
* ``Node``   - morphology data storage
* ``Morph``  - neuron morphology representation
* ``SWC``    - definitions of the data format


Commands
--------

Common operations with SWC files can be performed using the ``swc``
command-line tool:

    swc <command> [options] file

Alternatively:

    swc <command> file [file ...] [options] 

List of ``swc`` commands:

* ``check``    - tests morphology reconstruction for structural consistency
* ``convert``  - converts morphology to compliant SWC format
* ``find``     - locates single nodes in the reconstruction
* ``measure``  - calculates morphometric features
* ``modify``   - manipulates morphology reconstruction
* ``render``   - displays 3D model of the reconstruction
* ``repair``   - corrects reconstruction errors
* ``view``     - shows morphology structure


Installation
------------

Install the latest stable release:

    pip install treem

Install a development version:

    pip install git+https://github.com/a1eko/treem

See also ``pip`` documentation for installation alternatives.


Dependencies
------------

The ``treem`` module has minimal runtime dependencies:

* Python >= 3.7
* ``matplotlib``
* ``numpy``
* ``PyOpenGL`` (optional, enables ``swc render`` command)

For testing and documentation, ``treem`` requires additional development packages with
third-party extensions:

* ``sphinx`` with ``napoleon`` and ``programoutput`` extensions
* ``pytest`` with ``pytest-cov`` plugin
* ``sphinx-rtd-theme``
* ``coverage``


Documentation
-------------

Documentation is available online at [Read the
Docs](https://treem.readthedocs.io/en/latest/).


Citation
--------

* Hjorth JJJ, Hellgren Kotaleski J, Kozlov A (2021) Predicting
Synaptic Connectivity for Large-Scale Microcircuit Simulations
Using Snudda. *Neuroinformatics*, **19**(4):685-701. DOI:
[10.1007/s12021-021-09531-w](https://doi.org/10.1007/s12021-021-09531-w).

* Kozlov AK (2021) Treem - neuron morphology processing tool. *Zenodo*.
DOI: [10.5281/zenodo.4890844](https://doi.org/10.5281/zenodo.4890844).


Funding
-------

Horizon 2020 Framework Programme (785907, HBP SGA2); Horizon 2020
Framework Programme (945539, HBP SGA3); Vetenskapsrådet (VR-M-2017-02806,
VR-M-2020-01652); Swedish e-science Research Center (SeRC); KTH Digital
Futures.

We acknowledge the use of Fenix Infrastructure resources, which are
partially funded from the European Union's Horizon 2020 research and
innovation programme through the ICEI project under the grant agreement
No. 800858.

The computations and testing were enabled by resources provided by the National 
Academic Infrastructure for Supercomputing in Sweden (NAISS), partially funded by 
the Swedish Research Council through grant agreement no. 2022-06725, also by
the Swedish National Infrastructure for Computing (SNIC) at PDC KTH
partially funded by the Swedish Research Council through grant agreement
no. 2018-05973.
