#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# ================================================== #
# This file is a part of PYGPT package               #
# Website: https://pygpt.net                         #
# GitHub:  https://github.com/szczyglis-dev/py-gpt   #
# MIT License                                        #
# Created By  : Marcin Szczygliński                  #
# Updated Date: 2025.09.01 23:00:00                  #
# ================================================== #

VIDEO_AVAILABLE_ASPECT_RATIOS = {
    "16:9": "16:9",
    "9:16": "9:16",
}


IMAGE_AVAILABLE_RESOLUTIONS = {
    "gpt-image": {
        "auto": "auto",
        "1024x1024": "1024x1024",
        "1536x1024": "1536x1024",
        "1024x1536": "1024x1536"
    },
    "dall-e-3": {
        "1792x1024": "1792x1024",
        "1024x1792": "1024x1792",
        "1024x1024": "1024x1024"
    },
    "dall-e-2": {
        "1024x1024": "1024x1024",
        "512x512": "512x512",
        "256x256": "256x256"
    },
    "imagen-3.0": {
        "1024x1024": "1024x1024",
        "896x1280": "896x1280",
        "1280x896": "1280x896",
        "768x1408": "768x1408",
        "1408x768": "1408x768"
    },
    "imagen-4.0": {
        "1024x1024": "1024x1024",
        "896x1280": "896x1280",
        "1280x896": "1280x896",
        "768x1408": "768x1408",
        "1408x768": "1408x768",
        "2048x2048": "2048x2048",
        "1792x2560": "1792x2560",
        "2560x1792": "2560x1792",
        "1536x2816": "1536x2816",
        "2816x1536": "2816x1536"
    }
}