//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.0

use pyo3::prelude::*;
use sea_orm::entity::prelude::*;

#[pyclass(name = "QuebecJob", subclass)]
#[derive(Clone, Debug, PartialEq, DeriveEntityModel, Eq)]
#[sea_orm(table_name = "solid_queue_jobs")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub id: i64,
    pub queue_name: String,
    pub class_name: String,
    #[sea_orm(column_type = "Text", nullable)]
    pub arguments: Option<String>,
    pub priority: i32,
    pub failed_attempts: i32,
    pub active_job_id: Option<String>,
    pub scheduled_at: Option<DateTime>,
    pub finished_at: Option<DateTime>,
    pub concurrency_key: Option<String>,
    pub created_at: DateTime,
    pub updated_at: DateTime,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(has_one = "super::solid_queue_blocked_executions::Entity")]
    SolidQueueBlockedExecutions,
    #[sea_orm(has_one = "super::solid_queue_claimed_executions::Entity")]
    SolidQueueClaimedExecutions,
    #[sea_orm(has_one = "super::solid_queue_failed_executions::Entity")]
    SolidQueueFailedExecutions,
    #[sea_orm(has_one = "super::solid_queue_ready_executions::Entity")]
    SolidQueueReadyExecutions,
    #[sea_orm(has_one = "super::solid_queue_recurring_executions::Entity")]
    SolidQueueRecurringExecutions,
    #[sea_orm(has_one = "super::solid_queue_scheduled_executions::Entity")]
    SolidQueueScheduledExecutions,
}

impl Related<super::solid_queue_blocked_executions::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::SolidQueueBlockedExecutions.def()
    }
}

impl Related<super::solid_queue_claimed_executions::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::SolidQueueClaimedExecutions.def()
    }
}

impl Related<super::solid_queue_failed_executions::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::SolidQueueFailedExecutions.def()
    }
}

impl Related<super::solid_queue_ready_executions::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::SolidQueueReadyExecutions.def()
    }
}

impl Related<super::solid_queue_recurring_executions::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::SolidQueueRecurringExecutions.def()
    }
}

impl Related<super::solid_queue_scheduled_executions::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::SolidQueueScheduledExecutions.def()
    }
}

impl ActiveModelBehavior for ActiveModel {}
