# -*- coding: utf-8 -*-

import unittest
import numpy as np
import numpy
from simplification.util import simplify_coords, simplify_coords_vw
from simplification.cutil import simplify_coords as csimplify_coords
from simplification.cutil import simplify_coords_idx as csimplify_coords_idx
from simplification.cutil import simplify_coords_vw as csimplify_coords_vw
from simplification.cutil import simplify_coords_vw_idx as csimplify_coords_vw_idx
from simplification.cutil import simplify_coords_vwp as csimplify_coords_vwp


class PolylineTests(unittest.TestCase):
    """Tests for simplification"""

    def setUp(self):
        """make these available to all tests"""
        self.coords = [[0.0, 0.0], [5.0, 4.0], [11.0, 5.5], [17.3, 3.2], [27.8, 0.1]]

        self.coordsvw = [[5.0, 2.0], [3.0, 8.0], [6.0, 20.0], [7.0, 25.0], [10.0, 10.0]]

        self.result = [[0.0, 0.0], [5.0, 4.0], [11.0, 5.5], [27.8, 0.1]]

        self.result_rdp_idx = [0, 1, 2, 4]

        self.resultvw = [[5.0, 2.0], [7.0, 25.0], [10.0, 10.0]]

        self.resultvw_idx = [0, 3, 4]

        self.single = [[5.0, 4.0]]

        self.empty = []

        self.bad_coords = [
            [9.390000000000000000e02, 6.260000000000000000e02],
            [9.380000000000000000e02, 6.270000000000000000e02],
            [9.370000000000000000e02, 6.270000000000000000e02],
            [9.360000000000000000e02, 6.270000000000000000e02],
            [9.350000000000000000e02, 6.270000000000000000e02],
            [9.340000000000000000e02, 6.270000000000000000e02],
            [9.330000000000000000e02, 6.270000000000000000e02],
            [9.320000000000000000e02, 6.280000000000000000e02],
            [9.310000000000000000e02, 6.280000000000000000e02],
            [9.300000000000000000e02, 6.280000000000000000e02],
            [9.290000000000000000e02, 6.280000000000000000e02],
            [9.280000000000000000e02, 6.290000000000000000e02],
            [9.270000000000000000e02, 6.290000000000000000e02],
            [9.260000000000000000e02, 6.300000000000000000e02],
            [9.250000000000000000e02, 6.300000000000000000e02],
            [9.240000000000000000e02, 6.310000000000000000e02],
            [9.230000000000000000e02, 6.310000000000000000e02],
            [9.220000000000000000e02, 6.320000000000000000e02],
            [9.210000000000000000e02, 6.320000000000000000e02],
            [9.200000000000000000e02, 6.330000000000000000e02],
            [9.190000000000000000e02, 6.330000000000000000e02],
            [9.180000000000000000e02, 6.330000000000000000e02],
            [9.170000000000000000e02, 6.340000000000000000e02],
            [9.160000000000000000e02, 6.340000000000000000e02],
            [9.150000000000000000e02, 6.350000000000000000e02],
            [9.140000000000000000e02, 6.350000000000000000e02],
            [9.130000000000000000e02, 6.360000000000000000e02],
            [9.120000000000000000e02, 6.360000000000000000e02],
            [9.110000000000000000e02, 6.370000000000000000e02],
            [9.100000000000000000e02, 6.370000000000000000e02],
            [9.090000000000000000e02, 6.380000000000000000e02],
            [9.080000000000000000e02, 6.380000000000000000e02],
            [9.070000000000000000e02, 6.390000000000000000e02],
            [9.060000000000000000e02, 6.400000000000000000e02],
            [9.050000000000000000e02, 6.400000000000000000e02],
            [9.040000000000000000e02, 6.410000000000000000e02],
            [9.030000000000000000e02, 6.410000000000000000e02],
            [9.020000000000000000e02, 6.420000000000000000e02],
            [9.010000000000000000e02, 6.420000000000000000e02],
            [9.000000000000000000e02, 6.430000000000000000e02],
            [8.990000000000000000e02, 6.430000000000000000e02],
            [8.980000000000000000e02, 6.440000000000000000e02],
            [8.970000000000000000e02, 6.440000000000000000e02],
            [8.960000000000000000e02, 6.450000000000000000e02],
            [8.950000000000000000e02, 6.460000000000000000e02],
            [8.940000000000000000e02, 6.460000000000000000e02],
            [8.930000000000000000e02, 6.470000000000000000e02],
            [8.920000000000000000e02, 6.470000000000000000e02],
            [8.910000000000000000e02, 6.480000000000000000e02],
            [8.900000000000000000e02, 6.490000000000000000e02],
            [8.890000000000000000e02, 6.490000000000000000e02],
            [8.880000000000000000e02, 6.500000000000000000e02],
            [8.870000000000000000e02, 6.510000000000000000e02],
            [8.860000000000000000e02, 6.520000000000000000e02],
            [8.850000000000000000e02, 6.520000000000000000e02],
            [8.840000000000000000e02, 6.530000000000000000e02],
            [8.830000000000000000e02, 6.530000000000000000e02],
            [8.830000000000000000e02, 6.540000000000000000e02],
            [8.820000000000000000e02, 6.550000000000000000e02],
            [8.810000000000000000e02, 6.560000000000000000e02],
            [8.800000000000000000e02, 6.570000000000000000e02],
            [8.800000000000000000e02, 6.580000000000000000e02],
            [8.790000000000000000e02, 6.590000000000000000e02],
            [8.780000000000000000e02, 6.600000000000000000e02],
            [8.770000000000000000e02, 6.610000000000000000e02],
            [8.760000000000000000e02, 6.620000000000000000e02],
            [8.750000000000000000e02, 6.620000000000000000e02],
            [8.740000000000000000e02, 6.630000000000000000e02],
            [8.730000000000000000e02, 6.630000000000000000e02],
            [8.720000000000000000e02, 6.640000000000000000e02],
            [8.710000000000000000e02, 6.650000000000000000e02],
            [8.700000000000000000e02, 6.660000000000000000e02],
            [8.700000000000000000e02, 6.670000000000000000e02],
            [8.690000000000000000e02, 6.680000000000000000e02],
            [8.690000000000000000e02, 6.690000000000000000e02],
            [8.680000000000000000e02, 6.700000000000000000e02],
            [8.680000000000000000e02, 6.710000000000000000e02],
            [8.670000000000000000e02, 6.720000000000000000e02],
            [8.670000000000000000e02, 6.730000000000000000e02],
            [8.670000000000000000e02, 6.740000000000000000e02],
            [8.660000000000000000e02, 6.750000000000000000e02],
            [8.660000000000000000e02, 6.760000000000000000e02],
            [8.660000000000000000e02, 6.770000000000000000e02],
            [8.660000000000000000e02, 6.780000000000000000e02],
            [8.650000000000000000e02, 6.790000000000000000e02],
            [8.650000000000000000e02, 6.800000000000000000e02],
            [8.650000000000000000e02, 6.810000000000000000e02],
            [8.650000000000000000e02, 6.820000000000000000e02],
            [8.650000000000000000e02, 6.830000000000000000e02],
            [8.650000000000000000e02, 6.840000000000000000e02],
            [8.650000000000000000e02, 6.850000000000000000e02],
            [8.650000000000000000e02, 6.860000000000000000e02],
            [8.650000000000000000e02, 6.870000000000000000e02],
            [8.640000000000000000e02, 6.880000000000000000e02],
            [8.640000000000000000e02, 6.890000000000000000e02],
            [8.640000000000000000e02, 6.900000000000000000e02],
            [8.640000000000000000e02, 6.910000000000000000e02],
            [8.640000000000000000e02, 6.920000000000000000e02],
            [8.640000000000000000e02, 6.930000000000000000e02],
            [8.640000000000000000e02, 6.940000000000000000e02],
            [8.640000000000000000e02, 6.950000000000000000e02],
            [8.640000000000000000e02, 6.960000000000000000e02],
            [8.640000000000000000e02, 6.970000000000000000e02],
            [8.640000000000000000e02, 6.980000000000000000e02],
            [8.640000000000000000e02, 6.990000000000000000e02],
            [8.640000000000000000e02, 7.000000000000000000e02],
            [8.640000000000000000e02, 7.010000000000000000e02],
            [8.640000000000000000e02, 7.020000000000000000e02],
            [8.640000000000000000e02, 7.030000000000000000e02],
            [8.650000000000000000e02, 7.040000000000000000e02],
            [8.650000000000000000e02, 7.050000000000000000e02],
            [8.650000000000000000e02, 7.060000000000000000e02],
            [8.650000000000000000e02, 7.070000000000000000e02],
            [8.650000000000000000e02, 7.080000000000000000e02],
            [8.650000000000000000e02, 7.090000000000000000e02],
            [8.660000000000000000e02, 7.100000000000000000e02],
            [8.660000000000000000e02, 7.110000000000000000e02],
            [8.660000000000000000e02, 7.120000000000000000e02],
            [8.670000000000000000e02, 7.130000000000000000e02],
            [8.670000000000000000e02, 7.140000000000000000e02],
            [8.670000000000000000e02, 7.150000000000000000e02],
            [8.670000000000000000e02, 7.160000000000000000e02],
            [8.670000000000000000e02, 7.170000000000000000e02],
            [8.680000000000000000e02, 7.180000000000000000e02],
            [8.680000000000000000e02, 7.190000000000000000e02],
            [8.680000000000000000e02, 7.200000000000000000e02],
            [8.690000000000000000e02, 7.210000000000000000e02],
            [8.690000000000000000e02, 7.220000000000000000e02],
            [8.700000000000000000e02, 7.230000000000000000e02],
            [8.700000000000000000e02, 7.240000000000000000e02],
            [8.710000000000000000e02, 7.250000000000000000e02],
            [8.710000000000000000e02, 7.260000000000000000e02],
            [8.720000000000000000e02, 7.270000000000000000e02],
            [8.730000000000000000e02, 7.280000000000000000e02],
            [8.740000000000000000e02, 7.280000000000000000e02],
            [8.750000000000000000e02, 7.290000000000000000e02],
            [8.760000000000000000e02, 7.290000000000000000e02],
            [8.770000000000000000e02, 7.300000000000000000e02],
            [8.780000000000000000e02, 7.310000000000000000e02],
            [8.790000000000000000e02, 7.310000000000000000e02],
            [8.800000000000000000e02, 7.320000000000000000e02],
            [8.810000000000000000e02, 7.320000000000000000e02],
            [8.820000000000000000e02, 7.320000000000000000e02],
            [8.830000000000000000e02, 7.330000000000000000e02],
            [8.840000000000000000e02, 7.330000000000000000e02],
            [8.850000000000000000e02, 7.330000000000000000e02],
            [8.860000000000000000e02, 7.330000000000000000e02],
            [8.870000000000000000e02, 7.330000000000000000e02],
            [8.880000000000000000e02, 7.330000000000000000e02],
            [8.890000000000000000e02, 7.330000000000000000e02],
            [8.900000000000000000e02, 7.340000000000000000e02],
            [8.910000000000000000e02, 7.340000000000000000e02],
            [8.920000000000000000e02, 7.340000000000000000e02],
            [8.930000000000000000e02, 7.340000000000000000e02],
            [8.940000000000000000e02, 7.340000000000000000e02],
            [8.950000000000000000e02, 7.340000000000000000e02],
            [8.960000000000000000e02, 7.350000000000000000e02],
            [8.970000000000000000e02, 7.350000000000000000e02],
            [8.980000000000000000e02, 7.360000000000000000e02],
            [8.990000000000000000e02, 7.360000000000000000e02],
            [9.000000000000000000e02, 7.360000000000000000e02],
            [9.010000000000000000e02, 7.370000000000000000e02],
            [9.020000000000000000e02, 7.370000000000000000e02],
            [9.030000000000000000e02, 7.370000000000000000e02],
            [9.040000000000000000e02, 7.380000000000000000e02],
            [9.050000000000000000e02, 7.380000000000000000e02],
            [9.060000000000000000e02, 7.380000000000000000e02],
            [9.070000000000000000e02, 7.380000000000000000e02],
            [9.080000000000000000e02, 7.390000000000000000e02],
            [9.090000000000000000e02, 7.390000000000000000e02],
            [9.100000000000000000e02, 7.390000000000000000e02],
            [9.110000000000000000e02, 7.390000000000000000e02],
            [9.120000000000000000e02, 7.390000000000000000e02],
            [9.130000000000000000e02, 7.400000000000000000e02],
            [9.140000000000000000e02, 7.400000000000000000e02],
            [9.150000000000000000e02, 7.410000000000000000e02],
            [9.160000000000000000e02, 7.410000000000000000e02],
            [9.170000000000000000e02, 7.410000000000000000e02],
            [9.180000000000000000e02, 7.420000000000000000e02],
            [9.190000000000000000e02, 7.420000000000000000e02],
            [9.200000000000000000e02, 7.420000000000000000e02],
            [9.210000000000000000e02, 7.430000000000000000e02],
            [9.220000000000000000e02, 7.430000000000000000e02],
            [9.230000000000000000e02, 7.430000000000000000e02],
            [9.240000000000000000e02, 7.430000000000000000e02],
            [9.250000000000000000e02, 7.430000000000000000e02],
            [9.260000000000000000e02, 7.430000000000000000e02],
            [9.270000000000000000e02, 7.430000000000000000e02],
            [9.280000000000000000e02, 7.430000000000000000e02],
            [9.290000000000000000e02, 7.430000000000000000e02],
            [9.300000000000000000e02, 7.430000000000000000e02],
            [9.310000000000000000e02, 7.430000000000000000e02],
            [9.320000000000000000e02, 7.430000000000000000e02],
            [9.330000000000000000e02, 7.430000000000000000e02],
            [9.340000000000000000e02, 7.430000000000000000e02],
            [9.350000000000000000e02, 7.430000000000000000e02],
            [9.360000000000000000e02, 7.430000000000000000e02],
            [9.370000000000000000e02, 7.430000000000000000e02],
            [9.380000000000000000e02, 7.430000000000000000e02],
            [9.390000000000000000e02, 7.430000000000000000e02],
            [9.400000000000000000e02, 7.430000000000000000e02],
            [9.410000000000000000e02, 7.430000000000000000e02],
            [9.420000000000000000e02, 7.430000000000000000e02],
            [9.430000000000000000e02, 7.430000000000000000e02],
            [9.440000000000000000e02, 7.430000000000000000e02],
            [9.450000000000000000e02, 7.430000000000000000e02],
            [9.460000000000000000e02, 7.430000000000000000e02],
            [9.470000000000000000e02, 7.430000000000000000e02],
            [9.480000000000000000e02, 7.430000000000000000e02],
            [9.490000000000000000e02, 7.430000000000000000e02],
            [9.500000000000000000e02, 7.430000000000000000e02],
            [9.510000000000000000e02, 7.420000000000000000e02],
            [9.520000000000000000e02, 7.420000000000000000e02],
            [9.530000000000000000e02, 7.420000000000000000e02],
            [9.540000000000000000e02, 7.420000000000000000e02],
            [9.550000000000000000e02, 7.410000000000000000e02],
            [9.560000000000000000e02, 7.410000000000000000e02],
            [9.570000000000000000e02, 7.410000000000000000e02],
            [9.580000000000000000e02, 7.400000000000000000e02],
            [9.590000000000000000e02, 7.400000000000000000e02],
            [9.600000000000000000e02, 7.390000000000000000e02],
            [9.610000000000000000e02, 7.390000000000000000e02],
            [9.620000000000000000e02, 7.380000000000000000e02],
            [9.630000000000000000e02, 7.370000000000000000e02],
            [9.640000000000000000e02, 7.360000000000000000e02],
            [9.650000000000000000e02, 7.350000000000000000e02],
            [9.660000000000000000e02, 7.340000000000000000e02],
            [9.670000000000000000e02, 7.330000000000000000e02],
            [9.680000000000000000e02, 7.320000000000000000e02],
            [9.690000000000000000e02, 7.310000000000000000e02],
            [9.690000000000000000e02, 7.300000000000000000e02],
            [9.700000000000000000e02, 7.290000000000000000e02],
            [9.710000000000000000e02, 7.280000000000000000e02],
            [9.720000000000000000e02, 7.270000000000000000e02],
            [9.730000000000000000e02, 7.260000000000000000e02],
            [9.740000000000000000e02, 7.250000000000000000e02],
            [9.750000000000000000e02, 7.250000000000000000e02],
            [9.760000000000000000e02, 7.240000000000000000e02],
            [9.770000000000000000e02, 7.240000000000000000e02],
            [9.780000000000000000e02, 7.230000000000000000e02],
            [9.790000000000000000e02, 7.220000000000000000e02],
            [9.800000000000000000e02, 7.220000000000000000e02],
            [9.810000000000000000e02, 7.220000000000000000e02],
            [9.820000000000000000e02, 7.210000000000000000e02],
            [9.830000000000000000e02, 7.210000000000000000e02],
            [9.840000000000000000e02, 7.200000000000000000e02],
            [9.850000000000000000e02, 7.190000000000000000e02],
            [9.860000000000000000e02, 7.190000000000000000e02],
            [9.870000000000000000e02, 7.180000000000000000e02],
            [9.880000000000000000e02, 7.170000000000000000e02],
            [9.890000000000000000e02, 7.160000000000000000e02],
            [9.900000000000000000e02, 7.150000000000000000e02],
            [9.910000000000000000e02, 7.140000000000000000e02],
            [9.920000000000000000e02, 7.130000000000000000e02],
            [9.930000000000000000e02, 7.130000000000000000e02],
            [9.940000000000000000e02, 7.130000000000000000e02],
            [9.950000000000000000e02, 7.130000000000000000e02],
            [9.960000000000000000e02, 7.120000000000000000e02],
            [9.970000000000000000e02, 7.120000000000000000e02],
            [9.980000000000000000e02, 7.120000000000000000e02],
            [9.990000000000000000e02, 7.110000000000000000e02],
            [1.000000000000000000e03, 7.100000000000000000e02],
            [1.001000000000000000e03, 7.100000000000000000e02],
            [1.002000000000000000e03, 7.100000000000000000e02],
            [1.003000000000000000e03, 7.090000000000000000e02],
            [1.004000000000000000e03, 7.080000000000000000e02],
            [1.005000000000000000e03, 7.080000000000000000e02],
            [1.006000000000000000e03, 7.070000000000000000e02],
            [1.007000000000000000e03, 7.070000000000000000e02],
            [1.008000000000000000e03, 7.060000000000000000e02],
            [1.009000000000000000e03, 7.060000000000000000e02],
            [1.010000000000000000e03, 7.050000000000000000e02],
            [1.011000000000000000e03, 7.050000000000000000e02],
            [1.012000000000000000e03, 7.040000000000000000e02],
            [1.013000000000000000e03, 7.040000000000000000e02],
            [1.014000000000000000e03, 7.030000000000000000e02],
            [1.015000000000000000e03, 7.030000000000000000e02],
            [1.016000000000000000e03, 7.030000000000000000e02],
            [1.017000000000000000e03, 7.020000000000000000e02],
            [1.018000000000000000e03, 7.020000000000000000e02],
            [1.019000000000000000e03, 7.020000000000000000e02],
            [1.020000000000000000e03, 7.020000000000000000e02],
            [1.021000000000000000e03, 7.010000000000000000e02],
            [1.022000000000000000e03, 7.010000000000000000e02],
            [1.023000000000000000e03, 7.010000000000000000e02],
            [1.024000000000000000e03, 7.010000000000000000e02],
            [1.025000000000000000e03, 7.010000000000000000e02],
            [1.026000000000000000e03, 7.010000000000000000e02],
            [1.027000000000000000e03, 7.010000000000000000e02],
            [1.028000000000000000e03, 7.000000000000000000e02],
            [1.029000000000000000e03, 7.000000000000000000e02],
            [1.030000000000000000e03, 7.000000000000000000e02],
            [1.031000000000000000e03, 7.000000000000000000e02],
            [1.032000000000000000e03, 7.000000000000000000e02],
            [1.033000000000000000e03, 7.000000000000000000e02],
            [1.034000000000000000e03, 7.000000000000000000e02],
            [1.035000000000000000e03, 7.000000000000000000e02],
            [1.036000000000000000e03, 7.000000000000000000e02],
            [1.037000000000000000e03, 7.000000000000000000e02],
            [1.038000000000000000e03, 7.000000000000000000e02],
            [1.039000000000000000e03, 6.990000000000000000e02],
            [1.040000000000000000e03, 6.990000000000000000e02],
            [1.041000000000000000e03, 6.990000000000000000e02],
            [1.042000000000000000e03, 6.990000000000000000e02],
            [1.043000000000000000e03, 6.980000000000000000e02],
            [1.044000000000000000e03, 6.980000000000000000e02],
            [1.045000000000000000e03, 6.980000000000000000e02],
            [1.046000000000000000e03, 6.970000000000000000e02],
            [1.047000000000000000e03, 6.960000000000000000e02],
            [1.048000000000000000e03, 6.960000000000000000e02],
            [1.049000000000000000e03, 6.950000000000000000e02],
            [1.049000000000000000e03, 6.940000000000000000e02],
            [1.050000000000000000e03, 6.930000000000000000e02],
            [1.051000000000000000e03, 6.920000000000000000e02],
            [1.052000000000000000e03, 6.910000000000000000e02],
            [1.053000000000000000e03, 6.900000000000000000e02],
            [1.054000000000000000e03, 6.890000000000000000e02],
            [1.054000000000000000e03, 6.880000000000000000e02],
            [1.055000000000000000e03, 6.870000000000000000e02],
            [1.055000000000000000e03, 6.860000000000000000e02],
            [1.056000000000000000e03, 6.850000000000000000e02],
            [1.056000000000000000e03, 6.840000000000000000e02],
            [1.057000000000000000e03, 6.830000000000000000e02],
            [1.057000000000000000e03, 6.820000000000000000e02],
            [1.057000000000000000e03, 6.810000000000000000e02],
            [1.057000000000000000e03, 6.800000000000000000e02],
            [1.057000000000000000e03, 6.790000000000000000e02],
            [1.057000000000000000e03, 6.780000000000000000e02],
            [1.058000000000000000e03, 6.770000000000000000e02],
            [1.058000000000000000e03, 6.760000000000000000e02],
            [1.058000000000000000e03, 6.750000000000000000e02],
            [1.058000000000000000e03, 6.740000000000000000e02],
            [1.058000000000000000e03, 6.730000000000000000e02],
            [1.058000000000000000e03, 6.720000000000000000e02],
            [1.059000000000000000e03, 6.710000000000000000e02],
            [1.059000000000000000e03, 6.700000000000000000e02],
            [1.059000000000000000e03, 6.690000000000000000e02],
            [1.059000000000000000e03, 6.680000000000000000e02],
            [1.059000000000000000e03, 6.670000000000000000e02],
            [1.059000000000000000e03, 6.660000000000000000e02],
            [1.059000000000000000e03, 6.650000000000000000e02],
            [1.059000000000000000e03, 6.640000000000000000e02],
            [1.059000000000000000e03, 6.630000000000000000e02],
            [1.059000000000000000e03, 6.620000000000000000e02],
            [1.059000000000000000e03, 6.610000000000000000e02],
            [1.059000000000000000e03, 6.600000000000000000e02],
            [1.059000000000000000e03, 6.590000000000000000e02],
            [1.059000000000000000e03, 6.580000000000000000e02],
            [1.059000000000000000e03, 6.570000000000000000e02],
            [1.059000000000000000e03, 6.560000000000000000e02],
            [1.059000000000000000e03, 6.550000000000000000e02],
            [1.059000000000000000e03, 6.540000000000000000e02],
            [1.059000000000000000e03, 6.530000000000000000e02],
            [1.059000000000000000e03, 6.520000000000000000e02],
            [1.059000000000000000e03, 6.510000000000000000e02],
            [1.058000000000000000e03, 6.500000000000000000e02],
            [1.058000000000000000e03, 6.490000000000000000e02],
            [1.058000000000000000e03, 6.480000000000000000e02],
            [1.057000000000000000e03, 6.470000000000000000e02],
            [1.057000000000000000e03, 6.460000000000000000e02],
            [1.056000000000000000e03, 6.450000000000000000e02],
            [1.056000000000000000e03, 6.440000000000000000e02],
            [1.055000000000000000e03, 6.430000000000000000e02],
            [1.054000000000000000e03, 6.430000000000000000e02],
            [1.053000000000000000e03, 6.420000000000000000e02],
            [1.052000000000000000e03, 6.410000000000000000e02],
            [1.051000000000000000e03, 6.410000000000000000e02],
            [1.050000000000000000e03, 6.400000000000000000e02],
            [1.049000000000000000e03, 6.400000000000000000e02],
            [1.048000000000000000e03, 6.390000000000000000e02],
            [1.047000000000000000e03, 6.390000000000000000e02],
            [1.046000000000000000e03, 6.380000000000000000e02],
            [1.045000000000000000e03, 6.380000000000000000e02],
            [1.044000000000000000e03, 6.380000000000000000e02],
            [1.043000000000000000e03, 6.370000000000000000e02],
            [1.042000000000000000e03, 6.360000000000000000e02],
            [1.041000000000000000e03, 6.360000000000000000e02],
            [1.040000000000000000e03, 6.360000000000000000e02],
            [1.039000000000000000e03, 6.360000000000000000e02],
            [1.038000000000000000e03, 6.350000000000000000e02],
            [1.037000000000000000e03, 6.350000000000000000e02],
            [1.036000000000000000e03, 6.350000000000000000e02],
            [1.035000000000000000e03, 6.350000000000000000e02],
            [1.034000000000000000e03, 6.340000000000000000e02],
            [1.033000000000000000e03, 6.340000000000000000e02],
            [1.032000000000000000e03, 6.340000000000000000e02],
            [1.031000000000000000e03, 6.330000000000000000e02],
            [1.030000000000000000e03, 6.330000000000000000e02],
            [1.029000000000000000e03, 6.330000000000000000e02],
            [1.028000000000000000e03, 6.330000000000000000e02],
            [1.027000000000000000e03, 6.320000000000000000e02],
            [1.026000000000000000e03, 6.320000000000000000e02],
            [1.025000000000000000e03, 6.320000000000000000e02],
            [1.024000000000000000e03, 6.320000000000000000e02],
            [1.023000000000000000e03, 6.320000000000000000e02],
            [1.022000000000000000e03, 6.320000000000000000e02],
            [1.021000000000000000e03, 6.310000000000000000e02],
            [1.020000000000000000e03, 6.310000000000000000e02],
            [1.019000000000000000e03, 6.320000000000000000e02],
            [1.018000000000000000e03, 6.320000000000000000e02],
            [1.017000000000000000e03, 6.320000000000000000e02],
            [1.016000000000000000e03, 6.320000000000000000e02],
            [1.015000000000000000e03, 6.320000000000000000e02],
            [1.014000000000000000e03, 6.320000000000000000e02],
            [1.013000000000000000e03, 6.320000000000000000e02],
            [1.012000000000000000e03, 6.320000000000000000e02],
            [1.011000000000000000e03, 6.320000000000000000e02],
            [1.010000000000000000e03, 6.310000000000000000e02],
            [1.009000000000000000e03, 6.310000000000000000e02],
            [1.008000000000000000e03, 6.310000000000000000e02],
            [1.007000000000000000e03, 6.310000000000000000e02],
            [1.006000000000000000e03, 6.310000000000000000e02],
            [1.005000000000000000e03, 6.310000000000000000e02],
            [1.004000000000000000e03, 6.310000000000000000e02],
            [1.003000000000000000e03, 6.310000000000000000e02],
            [1.002000000000000000e03, 6.310000000000000000e02],
            [1.001000000000000000e03, 6.310000000000000000e02],
            [1.000000000000000000e03, 6.310000000000000000e02],
            [9.990000000000000000e02, 6.310000000000000000e02],
            [9.980000000000000000e02, 6.310000000000000000e02],
            [9.970000000000000000e02, 6.310000000000000000e02],
            [9.960000000000000000e02, 6.300000000000000000e02],
            [9.950000000000000000e02, 6.300000000000000000e02],
            [9.940000000000000000e02, 6.300000000000000000e02],
            [9.930000000000000000e02, 6.300000000000000000e02],
            [9.920000000000000000e02, 6.300000000000000000e02],
            [9.910000000000000000e02, 6.300000000000000000e02],
            [9.900000000000000000e02, 6.290000000000000000e02],
            [9.890000000000000000e02, 6.290000000000000000e02],
            [9.880000000000000000e02, 6.280000000000000000e02],
            [9.870000000000000000e02, 6.280000000000000000e02],
            [9.860000000000000000e02, 6.280000000000000000e02],
            [9.850000000000000000e02, 6.280000000000000000e02],
            [9.840000000000000000e02, 6.270000000000000000e02],
            [9.830000000000000000e02, 6.270000000000000000e02],
            [9.820000000000000000e02, 6.270000000000000000e02],
            [9.810000000000000000e02, 6.270000000000000000e02],
            [9.800000000000000000e02, 6.270000000000000000e02],
            [9.790000000000000000e02, 6.270000000000000000e02],
            [9.780000000000000000e02, 6.270000000000000000e02],
            [9.770000000000000000e02, 6.270000000000000000e02],
            [9.760000000000000000e02, 6.270000000000000000e02],
            [9.750000000000000000e02, 6.270000000000000000e02],
            [9.740000000000000000e02, 6.270000000000000000e02],
            [9.730000000000000000e02, 6.270000000000000000e02],
            [9.720000000000000000e02, 6.270000000000000000e02],
            [9.710000000000000000e02, 6.270000000000000000e02],
            [9.700000000000000000e02, 6.270000000000000000e02],
            [9.690000000000000000e02, 6.270000000000000000e02],
            [9.680000000000000000e02, 6.270000000000000000e02],
            [9.670000000000000000e02, 6.270000000000000000e02],
            [9.660000000000000000e02, 6.270000000000000000e02],
            [9.650000000000000000e02, 6.270000000000000000e02],
            [9.640000000000000000e02, 6.260000000000000000e02],
            [9.630000000000000000e02, 6.260000000000000000e02],
            [9.620000000000000000e02, 6.260000000000000000e02],
            [9.610000000000000000e02, 6.260000000000000000e02],
            [9.600000000000000000e02, 6.260000000000000000e02],
            [9.590000000000000000e02, 6.260000000000000000e02],
            [9.580000000000000000e02, 6.260000000000000000e02],
            [9.570000000000000000e02, 6.260000000000000000e02],
            [9.560000000000000000e02, 6.260000000000000000e02],
            [9.550000000000000000e02, 6.260000000000000000e02],
            [9.540000000000000000e02, 6.260000000000000000e02],
            [9.530000000000000000e02, 6.260000000000000000e02],
            [9.520000000000000000e02, 6.260000000000000000e02],
            [9.510000000000000000e02, 6.260000000000000000e02],
            [9.500000000000000000e02, 6.260000000000000000e02],
            [9.490000000000000000e02, 6.260000000000000000e02],
            [9.480000000000000000e02, 6.260000000000000000e02],
            [9.470000000000000000e02, 6.260000000000000000e02],
            [9.460000000000000000e02, 6.260000000000000000e02],
            [9.450000000000000000e02, 6.260000000000000000e02],
            [9.440000000000000000e02, 6.260000000000000000e02],
            [9.430000000000000000e02, 6.260000000000000000e02],
            [9.420000000000000000e02, 6.260000000000000000e02],
            [9.410000000000000000e02, 6.260000000000000000e02],
            [9.400000000000000000e02, 6.260000000000000000e02],
        ]

    def testNumpy_optional_error(self):
        """This test only fails when called with numpy arrays"""
        result = csimplify_coords_vw(np.array(self.bad_coords), 30)
        self.assertEqual(result[0][0], 939.0)

    def testSimplify_rdp_numpy(self):
        """Test that numpy arrays can be consumed and returned"""
        npcoords = np.array(self.coords)
        result = csimplify_coords(npcoords, 1.0)
        self.assertEqual(type(result), numpy.ndarray)

    def testSimplify_rdp(self):
        """Test that a LineString can be simplified using RDP (Ctypes)"""
        expected = self.result
        result = simplify_coords(self.coords, 1.0)
        for _ in range(100):
            self.assertEqual(result, expected)

    def testSimplify_vw(self):
        """Test that a LineString can be simplified using VW (Ctypes)"""
        expected = self.resultvw
        result = simplify_coords_vw(self.coordsvw, 30.0)
        for _ in range(100):
            self.assertEqual(result, expected)

    def testCSimplify_rdp(self):
        """Test that a LineString can be simplified using RDP (Cython)"""
        expected = self.result
        result = csimplify_coords(self.coords, 1.0)
        for _ in range(100):
            self.assertEqual(result, expected)

    def testCSimplify_rdp_idx(self):
        """Test that a LineString can be simplified using RDP (Cython)"""
        expected = self.result_rdp_idx
        result = csimplify_coords_idx(self.coords, 1.0)
        for _ in range(100):
            self.assertEqual(result, expected)

    def testCSimplify_vw(self):
        """Test that a LineString can be simplified using VW (Cython)"""
        expected = self.resultvw
        result = csimplify_coords_vw(self.coordsvw, 30.0)
        for _ in range(100):
            self.assertEqual(result, expected)

    def testCSimplify_vw_idx(self):
        """Test that a LineString can be simplified using VW (Cython)"""
        expected = self.resultvw_idx
        result = csimplify_coords_vw_idx(self.coordsvw, 30.0)
        for _ in range(100):
            self.assertEqual(result, expected)

    def testCSimplify_vw_preserve(self):
        """Test that a LineString can be simplified using topology-preserving VW (Cython)"""
        expected = self.resultvw
        result = csimplify_coords_vwp(self.coordsvw, 30.0)
        for _ in range(100):
            self.assertEqual(result, expected)

    # def testCSingle_rdp(self):
    #     """ Test that a one-element LineString is returned unaltered from RDP (Cython) """
    #     result = csimplify_coords(self.single, 1.0)
    #     self.assertEqual(result, self.single)

    # def testCSingle_vw(self):
    #     """ Test that a one-element LineString is returned unaltered from VW (Cython) """
    #     result = csimplify_coords_vw(self.single, 1.0)
    #     self.assertEqual(result, self.single)

    def testCEmpty_rdp(self):
        """Test that an empty LineString is returned unaltered from RDP (Cython)"""
        result = csimplify_coords(self.empty, 1.0)
        self.assertEqual(result, [])

    def testCEmpty_vw(self):
        """Test that an empty LineString is returned unaltered from VW (Cython)"""
        result = csimplify_coords_vw(self.empty, 1.0)
        self.assertEqual(result, [])
