# This file is part of the faebryk project
# SPDX-License-Identifier: MIT

# This file is auto-generated by nanobind.
# Do not edit this file directly; edit the corresponding
# C++ file instead.
import enum
from collections.abc import Callable, Sequence, Set
from typing import overload

def add(i: int, j: int = 1) -> int:
    """A function that adds two numbers"""

def call_python_function(func: Callable[[], int]) -> int: ...
def set_leak_warnings(value: bool) -> None: ...
def print_obj(obj: object) -> None: ...
def find_paths(src: Node, dst: Sequence[Node]) -> tuple[list[Path], list[Counter]]: ...
def set_indiv_measure(value: bool) -> None: ...
def set_max_paths(arg0: int, arg1: int, arg2: int, /) -> None: ...

class GraphInterface:
    def __init__(self) -> None: ...
    def __repr__(self) -> str: ...
    def get_graph(self) -> Graph: ...
    @property
    def G(self) -> Graph: ...
    def get_gif_edges(self) -> set[GraphInterface]: ...
    @property
    def edges(self) -> dict[GraphInterface, Link]: ...
    @property
    def node(self) -> Node: ...
    @node.setter
    def node(self, arg: Node, /) -> None: ...
    def is_connected_to(self, arg: GraphInterface, /) -> Link | None: ...
    @property
    def name(self) -> str: ...
    @name.setter
    def name(self, arg: str, /) -> None: ...
    def get_connected_nodes(self, types: Sequence[type]) -> set[Node]: ...
    @overload
    def connect(self, other: GraphInterface) -> None: ...
    @overload
    def connect(self, others: Sequence[GraphInterface]) -> None: ...
    @overload
    def connect(self, other: GraphInterface, link: Link) -> None: ...
    @overload
    def connect(self, others: Sequence[GraphInterface], link: Link) -> None: ...

class Graph:
    def __init__(self) -> None: ...
    def get_edges(self, arg: GraphInterface, /) -> dict[GraphInterface, Link]: ...
    @property
    def edges(self) -> list[tuple[GraphInterface, GraphInterface, Link]]: ...
    def get_gifs(self) -> set[GraphInterface]: ...
    def invalidate(self) -> None: ...
    @property
    def node_count(self) -> int: ...
    @property
    def edge_count(self) -> int: ...
    def node_projection(self) -> set[Node]: ...
    def nodes_by_names(self, arg: Set[str], /) -> list[tuple[Node, str]]: ...
    def bfs_visit(
        self,
        filter: Callable[[Sequence[GraphInterface], Link], bool],
        start: Sequence[GraphInterface],
    ) -> set[GraphInterface]: ...
    def __repr__(self) -> str: ...

class LinkExists(Exception):
    pass

class GraphInterfaceSelf(GraphInterface):
    def __init__(self) -> None: ...

class GraphInterfaceReference(GraphInterface):
    def __init__(self) -> None: ...
    def get_referenced_gif(self) -> GraphInterfaceSelf: ...
    def get_reference(self) -> Node: ...

class GraphInterfaceReferenceUnboundError(Exception):
    pass

class GraphInterfaceHierarchical(GraphInterface):
    def __init__(self, is_parent: bool) -> None: ...
    def get_parent(self) -> tuple[Node, str] | None: ...
    def get_children(self) -> list[Node]: ...
    @property
    def is_parent(self) -> bool: ...
    def disconnect_parent(self) -> None: ...

class GraphInterfaceModuleSibling(GraphInterfaceHierarchical):
    def __init__(self, is_parent: bool) -> None: ...

class GraphInterfaceModuleConnection(GraphInterface):
    def __init__(self) -> None: ...

class Link:
    def __eq__(self, arg: Link, /) -> bool: ...
    def is_cloneable(self) -> bool: ...

class LinkParent(Link):
    def __init__(self) -> None: ...

class LinkNamedParent(LinkParent):
    def __init__(self, arg: str, /) -> None: ...

class LinkDirect(Link):
    def __init__(self) -> None: ...

class LinkPointer(Link):
    def __init__(self) -> None: ...

class LinkSibling(LinkPointer):
    def __init__(self) -> None: ...

class LinkDirectConditional(LinkDirect):
    def __init__(
        self,
        filter: Callable[[Path], LinkDirectConditionalFilterResult],
        needs_only_first_in_path: bool = False,
    ) -> None: ...

class LinkDirectDerived(LinkDirectConditional):
    def __init__(self, arg: Path, /) -> None: ...

class LinkFilteredException(Exception):
    pass

class LinkDirectConditionalFilterResult(enum.Enum):
    FILTER_PASS = 0

    FILTER_FAIL_RECOVERABLE = 1

    FILTER_FAIL_UNRECOVERABLE = 2

class Node:
    def __init__(self) -> None: ...
    @staticmethod
    def transfer_ownership(arg: Node, /) -> Node: ...
    def get_graph(self) -> Graph: ...
    @property
    def self_gif(self) -> GraphInterfaceSelf: ...
    @property
    def children(self) -> GraphInterfaceHierarchical: ...
    @property
    def parent(self) -> GraphInterfaceHierarchical: ...
    def get_children(
        self,
        direct_only: bool,
        types: Sequence[type] | None = None,
        include_root: bool = False,
        f_filter: Callable[[Node], bool] | None = None,
        sort: bool = True,
    ) -> list[Node]: ...
    def get_parent(self) -> tuple[Node, str] | None: ...
    def get_parent_force(self) -> tuple[Node, str]: ...
    def get_name(self, accept_no_parent: bool = False) -> str: ...
    def get_hierarchy(self) -> list[tuple[Node, str]]: ...
    def get_full_name(self, types: bool = False) -> str: ...
    @overload
    def isinstance(self, type: type) -> bool: ...
    @overload
    def isinstance(self, types: Sequence[type]) -> bool: ...
    def bfs_node(self, filter: Callable[[Path], bool]) -> set[Node]: ...
    @property
    def no_include_parents_in_full_name(self) -> bool: ...
    @no_include_parents_in_full_name.setter
    def no_include_parents_in_full_name(self, arg: bool, /) -> None: ...
    def get_root_id(self) -> str: ...
    def __repr__(self) -> str: ...

class NodeException(Exception):
    pass

class NodeNoParent(Exception):
    pass

class Counter:
    @property
    def in_cnt(self) -> int: ...
    @property
    def weak_in_cnt(self) -> int: ...
    @property
    def out_weaker(self) -> int: ...
    @property
    def out_stronger(self) -> int: ...
    @property
    def out_cnt(self) -> int: ...
    @property
    def time_spent_s(self) -> float: ...
    @property
    def hide(self) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def multi(self) -> bool: ...
    @property
    def total_counter(self) -> bool: ...

class Edge:
    def __repr__(self) -> str: ...
    @property
    def to(self) -> GraphInterface: ...

class Path:
    def __repr__(self) -> str: ...
    def __len__(self) -> int: ...
    def contains(self, arg: GraphInterface, /) -> bool: ...
    def last(self) -> GraphInterface: ...
    def first(self) -> GraphInterface: ...
    def get_link(self, arg: Edge, /) -> Link: ...
    def iterate_edges(self, arg: Callable[[Edge], bool], /) -> None: ...
    def __getitem__(self, arg: int, /) -> GraphInterface: ...
