"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for an ECS Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom ECS Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class EcsDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom ECS deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromEcsDeploymentConfigName(_scope, _id, ecsDeploymentConfigName) {
        return deploymentConfig(ecsDeploymentConfigName);
    }
}
exports.EcsDeploymentConfig = EcsDeploymentConfig;
EcsDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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