"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
module.exports = {
    'CodeDeploy DeploymentConfig': {
        'can be created by specifying only minHealthyHostCount'(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.count(1),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                'MinimumHealthyHosts': {
                    'Type': 'HOST_COUNT',
                    'Value': 1,
                },
            }));
            test.done();
        },
        'can be created by specifying only minHealthyHostPercentage'(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.percentage(75),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                'MinimumHealthyHosts': {
                    'Type': 'FLEET_PERCENT',
                    'Value': 75,
                },
            }));
            test.done();
        },
        'can be imported'(test) {
            const stack = new cdk.Stack();
            const deploymentConfig = codedeploy.ServerDeploymentConfig.fromServerDeploymentConfigName(stack, 'MyDC', 'MyDC');
            test.notEqual(deploymentConfig, undefined);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5kZXBsb3ltZW50LWNvbmZpZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3QuZGVwbG95bWVudC1jb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLDRDQUF1RDtBQUN2RCxxQ0FBcUM7QUFFckMsd0NBQXdDO0FBSXhDLGlCQUFTO0lBQ1AsNkJBQTZCLEVBQUU7UUFDN0IsdURBQXVELENBQUMsSUFBVTtZQUNoRSxNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztZQUU5QixJQUFJLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxLQUFLLEVBQUUsa0JBQWtCLEVBQUU7Z0JBQy9ELG1CQUFtQixFQUFFLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO2FBQzdELENBQUMsQ0FBQztZQUVILGVBQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMscUJBQVksQ0FBQyxtQ0FBbUMsRUFBRTtnQkFDakUscUJBQXFCLEVBQUU7b0JBQ3JCLE1BQU0sRUFBRSxZQUFZO29CQUNwQixPQUFPLEVBQUUsQ0FBQztpQkFDWDthQUNGLENBQUMsQ0FBQyxDQUFDO1lBRUosSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ2QsQ0FBQztRQUVELDREQUE0RCxDQUFDLElBQVU7WUFDckUsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7WUFFOUIsSUFBSSxVQUFVLENBQUMsc0JBQXNCLENBQUMsS0FBSyxFQUFFLGtCQUFrQixFQUFFO2dCQUMvRCxtQkFBbUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLEVBQUUsQ0FBQzthQUNuRSxDQUFDLENBQUM7WUFFSCxlQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLHFCQUFZLENBQUMsbUNBQW1DLEVBQUU7Z0JBQ2pFLHFCQUFxQixFQUFFO29CQUNyQixNQUFNLEVBQUUsZUFBZTtvQkFDdkIsT0FBTyxFQUFFLEVBQUU7aUJBQ1o7YUFDRixDQUFDLENBQUMsQ0FBQztZQUVKLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUNkLENBQUM7UUFFRCxpQkFBaUIsQ0FBQyxJQUFVO1lBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1lBRTlCLE1BQU0sZ0JBQWdCLEdBQUcsVUFBVSxDQUFDLHNCQUFzQixDQUFDLDhCQUE4QixDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7WUFFakgsSUFBSSxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0IsRUFBRSxTQUFTLENBQUMsQ0FBQztZQUUzQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7UUFDZCxDQUFDO0tBQ0Y7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZXhwZWN0LCBoYXZlUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9hc3NlcnQnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgVGVzdCB9IGZyb20gJ25vZGV1bml0JztcbmltcG9ydCAqIGFzIGNvZGVkZXBsb3kgZnJvbSAnLi4vLi4vbGliJztcblxuLy8gdHNsaW50OmRpc2FibGU6b2JqZWN0LWxpdGVyYWwta2V5LXF1b3Rlc1xuXG5leHBvcnQgPSB7XG4gICdDb2RlRGVwbG95IERlcGxveW1lbnRDb25maWcnOiB7XG4gICAgJ2NhbiBiZSBjcmVhdGVkIGJ5IHNwZWNpZnlpbmcgb25seSBtaW5IZWFsdGh5SG9zdENvdW50Jyh0ZXN0OiBUZXN0KSB7XG4gICAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcblxuICAgICAgbmV3IGNvZGVkZXBsb3kuU2VydmVyRGVwbG95bWVudENvbmZpZyhzdGFjaywgJ0RlcGxveW1lbnRDb25maWcnLCB7XG4gICAgICAgIG1pbmltdW1IZWFsdGh5SG9zdHM6IGNvZGVkZXBsb3kuTWluaW11bUhlYWx0aHlIb3N0cy5jb3VudCgxKSxcbiAgICAgIH0pO1xuXG4gICAgICBleHBlY3Qoc3RhY2spLnRvKGhhdmVSZXNvdXJjZSgnQVdTOjpDb2RlRGVwbG95OjpEZXBsb3ltZW50Q29uZmlnJywge1xuICAgICAgICAnTWluaW11bUhlYWx0aHlIb3N0cyc6IHtcbiAgICAgICAgICAnVHlwZSc6ICdIT1NUX0NPVU5UJyxcbiAgICAgICAgICAnVmFsdWUnOiAxLFxuICAgICAgICB9LFxuICAgICAgfSkpO1xuXG4gICAgICB0ZXN0LmRvbmUoKTtcbiAgICB9LFxuXG4gICAgJ2NhbiBiZSBjcmVhdGVkIGJ5IHNwZWNpZnlpbmcgb25seSBtaW5IZWFsdGh5SG9zdFBlcmNlbnRhZ2UnKHRlc3Q6IFRlc3QpIHtcbiAgICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuXG4gICAgICBuZXcgY29kZWRlcGxveS5TZXJ2ZXJEZXBsb3ltZW50Q29uZmlnKHN0YWNrLCAnRGVwbG95bWVudENvbmZpZycsIHtcbiAgICAgICAgbWluaW11bUhlYWx0aHlIb3N0czogY29kZWRlcGxveS5NaW5pbXVtSGVhbHRoeUhvc3RzLnBlcmNlbnRhZ2UoNzUpLFxuICAgICAgfSk7XG5cbiAgICAgIGV4cGVjdChzdGFjaykudG8oaGF2ZVJlc291cmNlKCdBV1M6OkNvZGVEZXBsb3k6OkRlcGxveW1lbnRDb25maWcnLCB7XG4gICAgICAgICdNaW5pbXVtSGVhbHRoeUhvc3RzJzoge1xuICAgICAgICAgICdUeXBlJzogJ0ZMRUVUX1BFUkNFTlQnLFxuICAgICAgICAgICdWYWx1ZSc6IDc1LFxuICAgICAgICB9LFxuICAgICAgfSkpO1xuXG4gICAgICB0ZXN0LmRvbmUoKTtcbiAgICB9LFxuXG4gICAgJ2NhbiBiZSBpbXBvcnRlZCcodGVzdDogVGVzdCkge1xuICAgICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKCk7XG5cbiAgICAgIGNvbnN0IGRlcGxveW1lbnRDb25maWcgPSBjb2RlZGVwbG95LlNlcnZlckRlcGxveW1lbnRDb25maWcuZnJvbVNlcnZlckRlcGxveW1lbnRDb25maWdOYW1lKHN0YWNrLCAnTXlEQycsICdNeURDJyk7XG5cbiAgICAgIHRlc3Qubm90RXF1YWwoZGVwbG95bWVudENvbmZpZywgdW5kZWZpbmVkKTtcblxuICAgICAgdGVzdC5kb25lKCk7XG4gICAgfSxcbiAgfSxcbn07XG4iXX0=