# Contributing to pynamicalsys

We appreciate your interest in contributing to pynamicalsys! Whether you're fixing a bug, suggesting an improvement, or adding a new feature, your help is welcome.

## How to Contribute

1. **Fork the Repository**  
   Create a personal copy of this repository.

2. **Create a Feature Branch**  
   Use a descriptive branch name:

   ```bash
   $ git checkout -b fix-typo-in-readme
   ```

3. **Make Changes**

   Follow the coding style and ensure existing functionality it not broken. Add tests if relevant.

4. **Submit a Pull Request**

   Push your branch and open a pull request on GitHub. Include a clear description of your changes.

5. **Wait for Review**

   We'll review your PR and may request changes or offer suggestions.

## Coding Style

- Follow **PEP8** standards for Pycode code.
- Use **docstrings** (PEP257) for public classes, functions, and modules.
- Include **type hints** where appropriate.
- Keep commits clean and descriptive.

## Bug Reports & Feature Requests

- Submit an [issue](https://github.com/mrolims/pynamicalsys/issues) to report bugs or suggest new features.
- Include steps to reproduce, error messages, or use cases when possible.

## Code of Conduct

We strive to maintain a respectful and inclusive community. Please follow our [code of conduct](https://pynamicalsys.readthedocs.io/en/latest/) when interacting.

## Thank You

Your contributions help improve the project and support the community — thank you!
