# calcasa.api
The Calcasa API is used to connect to Calcasa provided services.
For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.4.0-rc4
- Package version: 1.4.0-rc4
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.calcasa.nl/contact](https://www.calcasa.nl/contact)

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import calcasa.api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import calcasa.api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import calcasa.api
from calcasa.api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.calcasa.nl/api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = calcasa.api.Configuration(
    host = "https://api.calcasa.nl/api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
with calcasa.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = calcasa.api.AdressenApi(api_client)
    bag_nummeraanduiding_id = 56 # int | Een BAG Nummeraanduiding ID om een adres te specificeren.

    try:
        # Adres info op basis van BAG Nummeraanduiding Id.
        api_response = api_instance.get_adres(bag_nummeraanduiding_id)
        print("The response of AdressenApi->get_adres:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdressenApi->get_adres: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.calcasa.nl/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdressenApi* | [**get_adres**](docs/AdressenApi.md#get_adres) | **GET** /adressen/{bagNummeraanduidingId} | Adres info op basis van BAG Nummeraanduiding Id.
*AdressenApi* | [**search_adres**](docs/AdressenApi.md#search_adres) | **POST** /adressen/zoeken | Zoek adres info op basis van het gegeven adres.
*BestemmingsplannenApi* | [**get_bestemming_by_id**](docs/BestemmingsplannenApi.md#get_bestemming_by_id) | **GET** /bestemmingsplannen/{bagNummeraanduidingId} | Gegevens over de bestemmingsplannen op de locatie van een adres (BAG Nummeraanduiding ID).
*BodemApi* | [**get_bodem_by_id**](docs/BodemApi.md#get_bodem_by_id) | **GET** /bodem/{bagNummeraanduidingId} | Gegevens over de bodemkwaliteit op de locatie van een adres (BAG Nummeraanduiding ID).
*BuurtApi* | [**get_buurt**](docs/BuurtApi.md#get_buurt) | **GET** /buurt/{buurtCode} | Gegevens over een buurt en de wijk, gemeente en land waarin deze buurt gesitueerd is.
*CallbacksApi* | [**add_or_update_callback_subscription**](docs/CallbacksApi.md#add_or_update_callback_subscription) | **POST** /callbacks/inschrijvingen | Voeg een callback inschrijving toe (of werk bij) voor de huidige client voor een adres.
*CallbacksApi* | [**delete_notification_subscription**](docs/CallbacksApi.md#delete_notification_subscription) | **DELETE** /callbacks/inschrijvingen/{bagNummeraanduidingId} | Verwijder de callback inschrijving voor deze client, dit adres en optioneel een geldverstrekker.
*CallbacksApi* | [**get_notification_subscription**](docs/CallbacksApi.md#get_notification_subscription) | **GET** /callbacks/inschrijvingen/{bagNummeraanduidingId} | Haal de callback inschrijving op voor deze client, dit adres en eventueel opgegeven geldverstrekker.
*CallbacksApi* | [**get_notification_subscriptions**](docs/CallbacksApi.md#get_notification_subscriptions) | **GET** /callbacks/inschrijvingen | Haal de callback inschrijvingen binnen voor deze client.
*ConfiguratieApi* | [**get_callbacks**](docs/ConfiguratieApi.md#get_callbacks) | **GET** /configuratie/callbacks | Haal de geconfigureerde callback URL&#39;s op voor de huidige client.
*ConfiguratieApi* | [**update_callbacks**](docs/ConfiguratieApi.md#update_callbacks) | **POST** /configuratie/callbacks | Configureer callback URL voor een specifieke API versie voor de huidige client.
*FacturenApi* | [**get_factuur**](docs/FacturenApi.md#get_factuur) | **GET** /facturen/{id} | Factuur op basis van een waardering Id.
*FotosApi* | [**get_foto**](docs/FotosApi.md#get_foto) | **GET** /fotos/{id} | Foto op basis van een foto Id.
*FunderingenApi* | [**get_fundering_by_id**](docs/FunderingenApi.md#get_fundering_by_id) | **GET** /funderingen/{bagNummeraanduidingId} | Gegevens over de fundering op de locatie van een adres (BAG Nummeraanduiding ID).
*GeldverstrekkersApi* | [**get_geldverstrekkers**](docs/GeldverstrekkersApi.md#get_geldverstrekkers) | **GET** /geldverstrekkers/{productType} | Alle geldverstrekkers die te gebruiken zijn voor aanvragen.
*RapportenApi* | [**get_rapport**](docs/RapportenApi.md#get_rapport) | **GET** /rapporten/{id} | Rapport op basis van waardering Id.
*WaarderingenApi* | [**create_waardering**](docs/WaarderingenApi.md#create_waardering) | **POST** /waarderingen | Creërt een waardering.
*WaarderingenApi* | [**get_waardering**](docs/WaarderingenApi.md#get_waardering) | **GET** /waarderingen/{id} | Waardering op basis van Id.
*WaarderingenApi* | [**get_waardering_ontwikkeling**](docs/WaarderingenApi.md#get_waardering_ontwikkeling) | **GET** /waarderingen/{id}/ontwikkeling | Waardering ontwikkeling op basis van waardering Id.
*WaarderingenApi* | [**patch_waarderingen**](docs/WaarderingenApi.md#patch_waarderingen) | **PATCH** /waarderingen/{id} | Patcht een waardering.
*WaarderingenApi* | [**search_waarderingen**](docs/WaarderingenApi.md#search_waarderingen) | **POST** /waarderingen/zoeken | Zoek waardering op basis van input parameters.


## Documentation For Models

 - [Aanvraagdoel](docs/Aanvraagdoel.md)
 - [Adres](docs/Adres.md)
 - [AdresInfo](docs/AdresInfo.md)
 - [Bestemmingsdata](docs/Bestemmingsdata.md)
 - [BodemStatusType](docs/BodemStatusType.md)
 - [Bodemdata](docs/Bodemdata.md)
 - [BusinessRulesCode](docs/BusinessRulesCode.md)
 - [BusinessRulesProblemDetails](docs/BusinessRulesProblemDetails.md)
 - [Callback](docs/Callback.md)
 - [CallbackInschrijving](docs/CallbackInschrijving.md)
 - [CbsIndeling](docs/CbsIndeling.md)
 - [DeelWaarderingWebhookPayload](docs/DeelWaarderingWebhookPayload.md)
 - [Energielabel](docs/Energielabel.md)
 - [EnergielabelData](docs/EnergielabelData.md)
 - [Factuur](docs/Factuur.md)
 - [Foto](docs/Foto.md)
 - [FunderingDataBron](docs/FunderingDataBron.md)
 - [FunderingHerstelType](docs/FunderingHerstelType.md)
 - [FunderingRisico](docs/FunderingRisico.md)
 - [FunderingRisicoLabel](docs/FunderingRisicoLabel.md)
 - [FunderingSoortBron](docs/FunderingSoortBron.md)
 - [FunderingType](docs/FunderingType.md)
 - [FunderingTypering](docs/FunderingTypering.md)
 - [Funderingdata](docs/Funderingdata.md)
 - [Gebiedsdata](docs/Gebiedsdata.md)
 - [Geldverstrekker](docs/Geldverstrekker.md)
 - [InvalidArgumentProblemDetails](docs/InvalidArgumentProblemDetails.md)
 - [KlantwaardeType](docs/KlantwaardeType.md)
 - [Kwartaal](docs/Kwartaal.md)
 - [Modeldata](docs/Modeldata.md)
 - [NotFoundProblemDetails](docs/NotFoundProblemDetails.md)
 - [Notitie](docs/Notitie.md)
 - [Notities](docs/Notities.md)
 - [Objectdata](docs/Objectdata.md)
 - [Omgevingsdata](docs/Omgevingsdata.md)
 - [Operation](docs/Operation.md)
 - [OperationType](docs/OperationType.md)
 - [PermissionsDeniedProblemDetails](docs/PermissionsDeniedProblemDetails.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [ProductType](docs/ProductType.md)
 - [Rapport](docs/Rapport.md)
 - [Referentieobject](docs/Referentieobject.md)
 - [ResourceExhaustedProblemDetails](docs/ResourceExhaustedProblemDetails.md)
 - [Taxatiedata](docs/Taxatiedata.md)
 - [Taxatiestatus](docs/Taxatiestatus.md)
 - [UnauthorizedProblemDetails](docs/UnauthorizedProblemDetails.md)
 - [ValidationProblemDetails](docs/ValidationProblemDetails.md)
 - [VerkoopBijzonderheden](docs/VerkoopBijzonderheden.md)
 - [VersionNames](docs/VersionNames.md)
 - [VorigeVerkoop](docs/VorigeVerkoop.md)
 - [Waardering](docs/Waardering.md)
 - [WaarderingInputParameters](docs/WaarderingInputParameters.md)
 - [WaarderingOntwikkeling](docs/WaarderingOntwikkeling.md)
 - [WaarderingOntwikkelingKwartaal](docs/WaarderingOntwikkelingKwartaal.md)
 - [WaarderingStatus](docs/WaarderingStatus.md)
 - [WaarderingWebhookPayload](docs/WaarderingWebhookPayload.md)
 - [WaarderingZoekParameters](docs/WaarderingZoekParameters.md)
 - [WebhookPayload](docs/WebhookPayload.md)
 - [WoningType](docs/WoningType.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="oauth"></a>
### oauth

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **api:adressen:read**: 
 - **api:bestemmingsplannen:read**: 
 - **api:bodem:read**: 
 - **api:buurt:read**: 
 - **api:callback:read**: 
 - **api:callback:write**: 
 - **api:configuratie:read**: 
 - **api:configuratie:write**: 
 - **api:facturen:read**: 
 - **api:fotos:read**: 
 - **api:funderingen:read**: 
 - **api:geldverstrekkers:read**: 
 - **api:rapporten:read**: 
 - **api:waarderingen:read**: 
 - **api:waarderingen:patch**: 
 - **api:waarderingen:ontwikkeling**: 
 - **api:waarderingen:create**: 


## Author

info@calcasa.nl


