# coding: utf-8

# flake8: noqa

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

__version__ = "1.4.0-rc4"

# Define package exports
__all__ = [
    "AdressenApi",
    "BestemmingsplannenApi",
    "BodemApi",
    "BuurtApi",
    "CallbacksApi",
    "ConfiguratieApi",
    "FacturenApi",
    "FotosApi",
    "FunderingenApi",
    "GeldverstrekkersApi",
    "RapportenApi",
    "WaarderingenApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "Aanvraagdoel",
    "Adres",
    "AdresInfo",
    "Bestemmingsdata",
    "BodemStatusType",
    "Bodemdata",
    "BusinessRulesCode",
    "BusinessRulesProblemDetails",
    "Callback",
    "CallbackInschrijving",
    "CbsIndeling",
    "DeelWaarderingWebhookPayload",
    "Energielabel",
    "EnergielabelData",
    "Factuur",
    "Foto",
    "FunderingDataBron",
    "FunderingHerstelType",
    "FunderingRisico",
    "FunderingRisicoLabel",
    "FunderingSoortBron",
    "FunderingType",
    "FunderingTypering",
    "Funderingdata",
    "Gebiedsdata",
    "Geldverstrekker",
    "InvalidArgumentProblemDetails",
    "KlantwaardeType",
    "Kwartaal",
    "Modeldata",
    "NotFoundProblemDetails",
    "Notitie",
    "Notities",
    "Objectdata",
    "Omgevingsdata",
    "Operation",
    "OperationType",
    "PermissionsDeniedProblemDetails",
    "ProblemDetails",
    "ProductType",
    "Rapport",
    "Referentieobject",
    "ResourceExhaustedProblemDetails",
    "Taxatiedata",
    "Taxatiestatus",
    "UnauthorizedProblemDetails",
    "ValidationProblemDetails",
    "VerkoopBijzonderheden",
    "VersionNames",
    "VorigeVerkoop",
    "Waardering",
    "WaarderingInputParameters",
    "WaarderingOntwikkeling",
    "WaarderingOntwikkelingKwartaal",
    "WaarderingStatus",
    "WaarderingWebhookPayload",
    "WaarderingZoekParameters",
    "WebhookPayload",
    "WoningType",
]

# import apis into sdk package
from calcasa.api.api.adressen_api import AdressenApi as AdressenApi
from calcasa.api.api.bestemmingsplannen_api import (
    BestemmingsplannenApi as BestemmingsplannenApi,
)
from calcasa.api.api.bodem_api import BodemApi as BodemApi
from calcasa.api.api.buurt_api import BuurtApi as BuurtApi
from calcasa.api.api.callbacks_api import CallbacksApi as CallbacksApi
from calcasa.api.api.configuratie_api import ConfiguratieApi as ConfiguratieApi
from calcasa.api.api.facturen_api import FacturenApi as FacturenApi
from calcasa.api.api.fotos_api import FotosApi as FotosApi
from calcasa.api.api.funderingen_api import FunderingenApi as FunderingenApi
from calcasa.api.api.geldverstrekkers_api import (
    GeldverstrekkersApi as GeldverstrekkersApi,
)
from calcasa.api.api.rapporten_api import RapportenApi as RapportenApi
from calcasa.api.api.waarderingen_api import WaarderingenApi as WaarderingenApi

# import ApiClient
from calcasa.api.api_response import ApiResponse as ApiResponse
from calcasa.api.api_client import ApiClient as ApiClient
from calcasa.api.configuration import Configuration as Configuration
from calcasa.api.exceptions import OpenApiException as OpenApiException
from calcasa.api.exceptions import ApiTypeError as ApiTypeError
from calcasa.api.exceptions import ApiValueError as ApiValueError
from calcasa.api.exceptions import ApiKeyError as ApiKeyError
from calcasa.api.exceptions import ApiAttributeError as ApiAttributeError
from calcasa.api.exceptions import ApiException as ApiException

# import models into sdk package
from calcasa.api.models.aanvraagdoel import Aanvraagdoel as Aanvraagdoel
from calcasa.api.models.adres import Adres as Adres
from calcasa.api.models.adres_info import AdresInfo as AdresInfo
from calcasa.api.models.bestemmingsdata import Bestemmingsdata as Bestemmingsdata
from calcasa.api.models.bodem_status_type import BodemStatusType as BodemStatusType
from calcasa.api.models.bodemdata import Bodemdata as Bodemdata
from calcasa.api.models.business_rules_code import (
    BusinessRulesCode as BusinessRulesCode,
)
from calcasa.api.models.business_rules_problem_details import (
    BusinessRulesProblemDetails as BusinessRulesProblemDetails,
)
from calcasa.api.models.callback import Callback as Callback
from calcasa.api.models.callback_inschrijving import (
    CallbackInschrijving as CallbackInschrijving,
)
from calcasa.api.models.cbs_indeling import CbsIndeling as CbsIndeling
from calcasa.api.models.deel_waardering_webhook_payload import (
    DeelWaarderingWebhookPayload as DeelWaarderingWebhookPayload,
)
from calcasa.api.models.energielabel import Energielabel as Energielabel
from calcasa.api.models.energielabel_data import EnergielabelData as EnergielabelData
from calcasa.api.models.factuur import Factuur as Factuur
from calcasa.api.models.foto import Foto as Foto
from calcasa.api.models.fundering_data_bron import (
    FunderingDataBron as FunderingDataBron,
)
from calcasa.api.models.fundering_herstel_type import (
    FunderingHerstelType as FunderingHerstelType,
)
from calcasa.api.models.fundering_risico import FunderingRisico as FunderingRisico
from calcasa.api.models.fundering_risico_label import (
    FunderingRisicoLabel as FunderingRisicoLabel,
)
from calcasa.api.models.fundering_soort_bron import (
    FunderingSoortBron as FunderingSoortBron,
)
from calcasa.api.models.fundering_type import FunderingType as FunderingType
from calcasa.api.models.fundering_typering import FunderingTypering as FunderingTypering
from calcasa.api.models.funderingdata import Funderingdata as Funderingdata
from calcasa.api.models.gebiedsdata import Gebiedsdata as Gebiedsdata
from calcasa.api.models.geldverstrekker import Geldverstrekker as Geldverstrekker
from calcasa.api.models.invalid_argument_problem_details import (
    InvalidArgumentProblemDetails as InvalidArgumentProblemDetails,
)
from calcasa.api.models.klantwaarde_type import KlantwaardeType as KlantwaardeType
from calcasa.api.models.kwartaal import Kwartaal as Kwartaal
from calcasa.api.models.modeldata import Modeldata as Modeldata
from calcasa.api.models.not_found_problem_details import (
    NotFoundProblemDetails as NotFoundProblemDetails,
)
from calcasa.api.models.notitie import Notitie as Notitie
from calcasa.api.models.notities import Notities as Notities
from calcasa.api.models.objectdata import Objectdata as Objectdata
from calcasa.api.models.omgevingsdata import Omgevingsdata as Omgevingsdata
from calcasa.api.models.operation import Operation as Operation
from calcasa.api.models.operation_type import OperationType as OperationType
from calcasa.api.models.permissions_denied_problem_details import (
    PermissionsDeniedProblemDetails as PermissionsDeniedProblemDetails,
)
from calcasa.api.models.problem_details import ProblemDetails as ProblemDetails
from calcasa.api.models.product_type import ProductType as ProductType
from calcasa.api.models.rapport import Rapport as Rapport
from calcasa.api.models.referentieobject import Referentieobject as Referentieobject
from calcasa.api.models.resource_exhausted_problem_details import (
    ResourceExhaustedProblemDetails as ResourceExhaustedProblemDetails,
)
from calcasa.api.models.taxatiedata import Taxatiedata as Taxatiedata
from calcasa.api.models.taxatiestatus import Taxatiestatus as Taxatiestatus
from calcasa.api.models.unauthorized_problem_details import (
    UnauthorizedProblemDetails as UnauthorizedProblemDetails,
)
from calcasa.api.models.validation_problem_details import (
    ValidationProblemDetails as ValidationProblemDetails,
)
from calcasa.api.models.verkoop_bijzonderheden import (
    VerkoopBijzonderheden as VerkoopBijzonderheden,
)
from calcasa.api.models.version_names import VersionNames as VersionNames
from calcasa.api.models.vorige_verkoop import VorigeVerkoop as VorigeVerkoop
from calcasa.api.models.waardering import Waardering as Waardering
from calcasa.api.models.waardering_input_parameters import (
    WaarderingInputParameters as WaarderingInputParameters,
)
from calcasa.api.models.waardering_ontwikkeling import (
    WaarderingOntwikkeling as WaarderingOntwikkeling,
)
from calcasa.api.models.waardering_ontwikkeling_kwartaal import (
    WaarderingOntwikkelingKwartaal as WaarderingOntwikkelingKwartaal,
)
from calcasa.api.models.waardering_status import WaarderingStatus as WaarderingStatus
from calcasa.api.models.waardering_webhook_payload import (
    WaarderingWebhookPayload as WaarderingWebhookPayload,
)
from calcasa.api.models.waardering_zoek_parameters import (
    WaarderingZoekParameters as WaarderingZoekParameters,
)
from calcasa.api.models.webhook_payload import WebhookPayload as WebhookPayload
from calcasa.api.models.woning_type import WoningType as WoningType
