# coding: utf-8

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class BusinessRulesCode(str, Enum):
    """
    Reden voor het niet voldoen aan de business rules. | Waarde | Omschrijving | | --- | --- | | `geenWaardebepalingMogelijk` | De ingevoerde woning kan modelmatig niet goed genoeg worden vastgesteld. | | `geenBestaandeWoning` | Geen bestaande koopwoning. | | `fouteOfOntbrekendeInvoer` | Noodzakelijke invoer ontbreekt of is foutief ingevoerd. | | `calcasaWaardeTeHoog` | Calcasa-waarde is te hoog volgens de business rules. | | `ltvTeHoog` | Loan-to-value is te hoog volgens de business rules. | | `hypotheekTeHoog` | Hypotheekbedrag is te hoog volgens de business rules. | | `woningtypeIncorrect` | Woningtype is incorrect volgens de business rules. | | `calcasaWaardeTeLaag` | Calcasa-waarde is te laag volgens de business rules. | | `calcasaWaardeTeHoogVoorNhg` | Calcasa-waarde is te hoog voor een NHG-waardering volgens de business rules. | | `calcasaWaardeEnKoopsomTeHoogVoorNhg` | Calcasa-waarde en ingevoerde koopsom zijn te hoog voor een NHG-waardering volgens de business rules. | | `ltvTeHoogOverbrugging` | Loan-to-value is te hoog voor deze overbrugging volgens de business rules. | | `geenEigenBewoning` | Woning is niet bestemd voor eigen bewoning. | | `incorrecteErfpacht` | Erfpachtsituatie is niet toegestaan volgens de business rules. |
    """

    """
    allowed enum values
    """
    GEENWAARDEBEPALINGMOGELIJK = "geenWaardebepalingMogelijk"
    GEENBESTAANDEWONING = "geenBestaandeWoning"
    FOUTEOFONTBREKENDEINVOER = "fouteOfOntbrekendeInvoer"
    CALCASAWAARDETEHOOG = "calcasaWaardeTeHoog"
    LTVTEHOOG = "ltvTeHoog"
    HYPOTHEEKTEHOOG = "hypotheekTeHoog"
    WONINGTYPEINCORRECT = "woningtypeIncorrect"
    CALCASAWAARDETELAAG = "calcasaWaardeTeLaag"
    CALCASAWAARDETEHOOGVOORNHG = "calcasaWaardeTeHoogVoorNhg"
    CALCASAWAARDEENKOOPSOMTEHOOGVOORNHG = "calcasaWaardeEnKoopsomTeHoogVoorNhg"
    LTVTEHOOGOVERBRUGGING = "ltvTeHoogOverbrugging"
    GEENEIGENBEWONING = "geenEigenBewoning"
    INCORRECTEERFPACHT = "incorrecteErfpacht"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of BusinessRulesCode from a JSON string"""
        return cls(json.loads(json_str))
