# coding: utf-8

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class FunderingHerstelType(str, Enum):
    """
    Herstel-types voor funderingen. | Waarde | Omschrijving | | --- | --- | | `onbekendHerstelType` | Hersteltype is onbekend. | | `vergunning` | O.b.v. vergunning. | | `funderingRapport` | O.b.v. fundering-rapport. | | `archiefRapport` | O.b.v. archief-rapport. | | `eigenaarBewijs` | O.b.v. bewijs van eigenaar. |
    """

    """
    allowed enum values
    """
    ONBEKENDHERSTELTYPE = "onbekendHerstelType"
    VERGUNNING = "vergunning"
    FUNDERINGRAPPORT = "funderingRapport"
    ARCHIEFRAPPORT = "archiefRapport"
    EIGENAARBEWIJS = "eigenaarBewijs"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of FunderingHerstelType from a JSON string"""
        return cls(json.loads(json_str))
