# coding: utf-8

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class FunderingType(str, Enum):
    """
    Funderingstypes. | Waarde | Omschrijving | | --- | --- | | `onbekendFunderingType` | Onbekend fundering-type. | | `hout` | Hout. | | `houtAmsterdam` | Hout, Amsterdamse variant. | | `houtRotterdam` | Hout, Rotterdamse variant. | | `beton` | Beton. | | `nietOnderheid` | Niet onderheid. | | `nietOnderheidGemetseld` | Niet onderheid, gemetseld. | | `nietOnderheidStroken` | Niet onderheid, stroken. | | `nietOnderheidPlaat` | Niet onderheid, plaat. | | `nietOnderheidBetonplaat` | Niet onderheid, betonplaat. | | `nietOnderheidSlieten` | Niet onderheid, slieten. | | `houtOplanger` | Hout met oplanger. | | `betonVerzwaard` | Beton verzwaard. | | `gecombineerd` | Gecombineerd. | | `staal` | Stalen buispaal. | | `houtAmsterdamRotterdam` | Houten paal, Rotterdam/Amsterdam methode. | | `houtRotterdamSpaarboog` | Houten paal, Rotterdam methode met spaarboog. | | `houtAmsterdamSpaarboog` | Houten paal, Amsterdam methode met spaarboog. |
    """

    """
    allowed enum values
    """
    ONBEKENDFUNDERINGTYPE = "onbekendFunderingType"
    HOUT = "hout"
    HOUTAMSTERDAM = "houtAmsterdam"
    HOUTROTTERDAM = "houtRotterdam"
    BETON = "beton"
    NIETONDERHEID = "nietOnderheid"
    NIETONDERHEIDGEMETSELD = "nietOnderheidGemetseld"
    NIETONDERHEIDSTROKEN = "nietOnderheidStroken"
    NIETONDERHEIDPLAAT = "nietOnderheidPlaat"
    NIETONDERHEIDBETONPLAAT = "nietOnderheidBetonplaat"
    NIETONDERHEIDSLIETEN = "nietOnderheidSlieten"
    HOUTOPLANGER = "houtOplanger"
    BETONVERZWAARD = "betonVerzwaard"
    GECOMBINEERD = "gecombineerd"
    STAAL = "staal"
    HOUTAMSTERDAMROTTERDAM = "houtAmsterdamRotterdam"
    HOUTROTTERDAMSPAARBOOG = "houtRotterdamSpaarboog"
    HOUTAMSTERDAMSPAARBOOG = "houtAmsterdamSpaarboog"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of FunderingType from a JSON string"""
        return cls(json.loads(json_str))
