# coding: utf-8

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from calcasa.api.models.fundering_data_bron import FunderingDataBron
from calcasa.api.models.fundering_herstel_type import FunderingHerstelType
from calcasa.api.models.fundering_risico import FunderingRisico
from calcasa.api.models.fundering_typering import FunderingTypering
from typing import Optional, Set
from typing_extensions import Self


class Funderingdata(BaseModel):
    """
    Uitvoer met funderingsinformatie.
    """  # noqa: E501

    typering: Optional[FunderingTypering] = None
    herstel_type: Optional[FunderingHerstelType] = Field(
        default=None, alias="herstelType"
    )
    droogstand_risico: Optional[FunderingRisico] = Field(
        default=None, alias="droogstandRisico"
    )
    optrekkend_vocht_risico: Optional[FunderingRisico] = Field(
        default=None, alias="optrekkendVochtRisico"
    )
    bio_infectie_risico: Optional[FunderingRisico] = Field(
        default=None, alias="bioInfectieRisico"
    )
    herstelkosten: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Indicatieve herstelkosten van de fundering."
    )
    bron: Optional[FunderingDataBron] = None
    __properties: ClassVar[List[str]] = [
        "typering",
        "herstelType",
        "droogstandRisico",
        "optrekkendVochtRisico",
        "bioInfectieRisico",
        "herstelkosten",
        "bron",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Funderingdata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of typering
        if self.typering:
            _dict["typering"] = self.typering.to_dict()
        # override the default output from pydantic by calling `to_dict()` of droogstand_risico
        if self.droogstand_risico:
            _dict["droogstandRisico"] = self.droogstand_risico.to_dict()
        # override the default output from pydantic by calling `to_dict()` of optrekkend_vocht_risico
        if self.optrekkend_vocht_risico:
            _dict["optrekkendVochtRisico"] = self.optrekkend_vocht_risico.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bio_infectie_risico
        if self.bio_infectie_risico:
            _dict["bioInfectieRisico"] = self.bio_infectie_risico.to_dict()
        # set to None if herstelkosten (nullable) is None
        # and model_fields_set contains the field
        if self.herstelkosten is None and "herstelkosten" in self.model_fields_set:
            _dict["herstelkosten"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Funderingdata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "typering": (
                    FunderingTypering.from_dict(obj["typering"])
                    if obj.get("typering") is not None
                    else None
                ),
                "herstelType": obj.get("herstelType"),
                "droogstandRisico": (
                    FunderingRisico.from_dict(obj["droogstandRisico"])
                    if obj.get("droogstandRisico") is not None
                    else None
                ),
                "optrekkendVochtRisico": (
                    FunderingRisico.from_dict(obj["optrekkendVochtRisico"])
                    if obj.get("optrekkendVochtRisico") is not None
                    else None
                ),
                "bioInfectieRisico": (
                    FunderingRisico.from_dict(obj["bioInfectieRisico"])
                    if obj.get("bioInfectieRisico") is not None
                    else None
                ),
                "herstelkosten": obj.get("herstelkosten"),
                "bron": obj.get("bron"),
            }
        )
        return _obj
