# coding: utf-8

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class Gebiedsdata(BaseModel):
    """
    Gebiedsdata
    """  # noqa: E501

    naam: Optional[StrictStr] = None
    gemiddelde_prijs_eengezinswoningen: Optional[
        Annotated[int, Field(strict=True, ge=0)]
    ] = Field(
        default=None,
        description="In hele euros.",
        alias="gemiddeldePrijsEengezinswoningen",
    )
    gemiddelde_prijs_meergezinswoningen: Optional[
        Annotated[int, Field(strict=True, ge=0)]
    ] = Field(
        default=None,
        description="In hele euros.",
        alias="gemiddeldePrijsMeergezinswoningen",
    )
    gemiddelde_vierkantemeter_prijs_eengezinswoningen: Optional[
        Annotated[int, Field(strict=True, ge=0)]
    ] = Field(
        default=None,
        description="In hele euros per vierkante meter.",
        alias="gemiddeldeVierkantemeterPrijsEengezinswoningen",
    )
    gemiddelde_vierkantemeter_prijs_meergezinswoningen: Optional[
        Annotated[int, Field(strict=True, ge=0)]
    ] = Field(
        default=None,
        description="In hele euros per vierkante meter.",
        alias="gemiddeldeVierkantemeterPrijsMeergezinswoningen",
    )
    prijsverandering_afgelopen_jaar: Optional[StrictInt] = Field(
        default=None,
        description="In hele procenten.",
        alias="prijsveranderingAfgelopenJaar",
    )
    prijsverandering_afgelopen3_jaar: Optional[StrictInt] = Field(
        default=None,
        description="In hele procenten.",
        alias="prijsveranderingAfgelopen3Jaar",
    )
    prijsverandering_afgelopen5_jaar: Optional[StrictInt] = Field(
        default=None,
        description="In hele procenten.",
        alias="prijsveranderingAfgelopen5Jaar",
    )
    prijsverandering_afgelopen10_jaar: Optional[StrictInt] = Field(
        default=None,
        description="In hele procenten.",
        alias="prijsveranderingAfgelopen10Jaar",
    )
    __properties: ClassVar[List[str]] = [
        "naam",
        "gemiddeldePrijsEengezinswoningen",
        "gemiddeldePrijsMeergezinswoningen",
        "gemiddeldeVierkantemeterPrijsEengezinswoningen",
        "gemiddeldeVierkantemeterPrijsMeergezinswoningen",
        "prijsveranderingAfgelopenJaar",
        "prijsveranderingAfgelopen3Jaar",
        "prijsveranderingAfgelopen5Jaar",
        "prijsveranderingAfgelopen10Jaar",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Gebiedsdata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if gemiddelde_prijs_eengezinswoningen (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gemiddelde_prijs_eengezinswoningen is None
            and "gemiddelde_prijs_eengezinswoningen" in self.model_fields_set
        ):
            _dict["gemiddeldePrijsEengezinswoningen"] = None

        # set to None if gemiddelde_prijs_meergezinswoningen (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gemiddelde_prijs_meergezinswoningen is None
            and "gemiddelde_prijs_meergezinswoningen" in self.model_fields_set
        ):
            _dict["gemiddeldePrijsMeergezinswoningen"] = None

        # set to None if gemiddelde_vierkantemeter_prijs_eengezinswoningen (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gemiddelde_vierkantemeter_prijs_eengezinswoningen is None
            and "gemiddelde_vierkantemeter_prijs_eengezinswoningen"
            in self.model_fields_set
        ):
            _dict["gemiddeldeVierkantemeterPrijsEengezinswoningen"] = None

        # set to None if gemiddelde_vierkantemeter_prijs_meergezinswoningen (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gemiddelde_vierkantemeter_prijs_meergezinswoningen is None
            and "gemiddelde_vierkantemeter_prijs_meergezinswoningen"
            in self.model_fields_set
        ):
            _dict["gemiddeldeVierkantemeterPrijsMeergezinswoningen"] = None

        # set to None if prijsverandering_afgelopen_jaar (nullable) is None
        # and model_fields_set contains the field
        if (
            self.prijsverandering_afgelopen_jaar is None
            and "prijsverandering_afgelopen_jaar" in self.model_fields_set
        ):
            _dict["prijsveranderingAfgelopenJaar"] = None

        # set to None if prijsverandering_afgelopen3_jaar (nullable) is None
        # and model_fields_set contains the field
        if (
            self.prijsverandering_afgelopen3_jaar is None
            and "prijsverandering_afgelopen3_jaar" in self.model_fields_set
        ):
            _dict["prijsveranderingAfgelopen3Jaar"] = None

        # set to None if prijsverandering_afgelopen5_jaar (nullable) is None
        # and model_fields_set contains the field
        if (
            self.prijsverandering_afgelopen5_jaar is None
            and "prijsverandering_afgelopen5_jaar" in self.model_fields_set
        ):
            _dict["prijsveranderingAfgelopen5Jaar"] = None

        # set to None if prijsverandering_afgelopen10_jaar (nullable) is None
        # and model_fields_set contains the field
        if (
            self.prijsverandering_afgelopen10_jaar is None
            and "prijsverandering_afgelopen10_jaar" in self.model_fields_set
        ):
            _dict["prijsveranderingAfgelopen10Jaar"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Gebiedsdata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "naam": obj.get("naam"),
                "gemiddeldePrijsEengezinswoningen": obj.get(
                    "gemiddeldePrijsEengezinswoningen"
                ),
                "gemiddeldePrijsMeergezinswoningen": obj.get(
                    "gemiddeldePrijsMeergezinswoningen"
                ),
                "gemiddeldeVierkantemeterPrijsEengezinswoningen": obj.get(
                    "gemiddeldeVierkantemeterPrijsEengezinswoningen"
                ),
                "gemiddeldeVierkantemeterPrijsMeergezinswoningen": obj.get(
                    "gemiddeldeVierkantemeterPrijsMeergezinswoningen"
                ),
                "prijsveranderingAfgelopenJaar": obj.get(
                    "prijsveranderingAfgelopenJaar"
                ),
                "prijsveranderingAfgelopen3Jaar": obj.get(
                    "prijsveranderingAfgelopen3Jaar"
                ),
                "prijsveranderingAfgelopen5Jaar": obj.get(
                    "prijsveranderingAfgelopen5Jaar"
                ),
                "prijsveranderingAfgelopen10Jaar": obj.get(
                    "prijsveranderingAfgelopen10Jaar"
                ),
            }
        )
        return _obj
