# coding: utf-8

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from calcasa.api.models.adres import Adres
from calcasa.api.models.cbs_indeling import CbsIndeling
from calcasa.api.models.foto import Foto
from calcasa.api.models.objectdata import Objectdata
from calcasa.api.models.verkoop_bijzonderheden import VerkoopBijzonderheden
from typing import Optional, Set
from typing_extensions import Self


class Referentieobject(BaseModel):
    """
    Referentieobject
    """  # noqa: E501

    afstand: Optional[StrictInt] = Field(
        default=None, description="Afstand tot het waarderingsobject in meters."
    )
    verkoopprijs: Optional[StrictInt] = Field(
        default=None, description="In hele euros."
    )
    gecorrigeerde_verkoopprijs: Optional[StrictInt] = Field(
        default=None, description="In hele euros.", alias="gecorrigeerdeVerkoopprijs"
    )
    geindexeerde_verkoopprijs: Optional[StrictInt] = Field(
        default=None, description="In hele euros.", alias="geindexeerdeVerkoopprijs"
    )
    vierkantemeterprijs: Optional[StrictInt] = Field(
        default=None, description="In hele euros per vierkante meters."
    )
    gecorrigeerde_vierkantemeterprijs: Optional[StrictInt] = Field(
        default=None,
        description="In hele euros per vierkante meters.",
        alias="gecorrigeerdeVierkantemeterprijs",
    )
    geindexeerde_vierkantemeterprijs: Optional[StrictInt] = Field(
        default=None,
        description="In hele euros per vierkante meters.",
        alias="geindexeerdeVierkantemeterprijs",
    )
    verkoopdatum: Optional[date] = Field(default=None, description="In UTC.")
    adres: Optional[Adres] = None
    object: Optional[Objectdata] = None
    cbs_indeling: Optional[CbsIndeling] = Field(default=None, alias="cbsIndeling")
    fotos: Optional[List[Foto]] = Field(
        default=None, description="Fotos van het referentieobject."
    )
    bijzonderheden: Optional[List[VerkoopBijzonderheden]] = Field(
        default=None, description="Eventuele bijzonderheden van de transactie."
    )
    __properties: ClassVar[List[str]] = [
        "afstand",
        "verkoopprijs",
        "gecorrigeerdeVerkoopprijs",
        "geindexeerdeVerkoopprijs",
        "vierkantemeterprijs",
        "gecorrigeerdeVierkantemeterprijs",
        "geindexeerdeVierkantemeterprijs",
        "verkoopdatum",
        "adres",
        "object",
        "cbsIndeling",
        "fotos",
        "bijzonderheden",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Referentieobject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of adres
        if self.adres:
            _dict["adres"] = self.adres.to_dict()
        # override the default output from pydantic by calling `to_dict()` of object
        if self.object:
            _dict["object"] = self.object.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cbs_indeling
        if self.cbs_indeling:
            _dict["cbsIndeling"] = self.cbs_indeling.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in fotos (list)
        _items = []
        if self.fotos:
            for _item_fotos in self.fotos:
                if _item_fotos:
                    _items.append(_item_fotos.to_dict())
            _dict["fotos"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Referentieobject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "afstand": obj.get("afstand"),
                "verkoopprijs": obj.get("verkoopprijs"),
                "gecorrigeerdeVerkoopprijs": obj.get("gecorrigeerdeVerkoopprijs"),
                "geindexeerdeVerkoopprijs": obj.get("geindexeerdeVerkoopprijs"),
                "vierkantemeterprijs": obj.get("vierkantemeterprijs"),
                "gecorrigeerdeVierkantemeterprijs": obj.get(
                    "gecorrigeerdeVierkantemeterprijs"
                ),
                "geindexeerdeVierkantemeterprijs": obj.get(
                    "geindexeerdeVierkantemeterprijs"
                ),
                "verkoopdatum": obj.get("verkoopdatum"),
                "adres": (
                    Adres.from_dict(obj["adres"])
                    if obj.get("adres") is not None
                    else None
                ),
                "object": (
                    Objectdata.from_dict(obj["object"])
                    if obj.get("object") is not None
                    else None
                ),
                "cbsIndeling": (
                    CbsIndeling.from_dict(obj["cbsIndeling"])
                    if obj.get("cbsIndeling") is not None
                    else None
                ),
                "fotos": (
                    [Foto.from_dict(_item) for _item in obj["fotos"]]
                    if obj.get("fotos") is not None
                    else None
                ),
                "bijzonderheden": obj.get("bijzonderheden"),
            }
        )
        return _obj
