# coding: utf-8

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from calcasa.api.models.adres import Adres
from calcasa.api.models.cbs_indeling import CbsIndeling
from calcasa.api.models.factuur import Factuur
from calcasa.api.models.foto import Foto
from calcasa.api.models.modeldata import Modeldata
from calcasa.api.models.objectdata import Objectdata
from calcasa.api.models.rapport import Rapport
from calcasa.api.models.referentieobject import Referentieobject
from calcasa.api.models.taxatiedata import Taxatiedata
from calcasa.api.models.vorige_verkoop import VorigeVerkoop
from calcasa.api.models.waardering_input_parameters import WaarderingInputParameters
from calcasa.api.models.waardering_status import WaarderingStatus
from typing import Optional, Set
from typing_extensions import Self


class Waardering(BaseModel):
    """
    Waardering
    """  # noqa: E501

    id: UUID
    aangemaakt: datetime = Field(
        description="Het tijdsstempel van wanneer de waardering aangemaakt is."
    )
    status: WaarderingStatus
    originele_input: WaarderingInputParameters = Field(alias="origineleInput")
    adres: Adres
    model: Optional[Modeldata] = None
    taxatie: Optional[Taxatiedata] = None
    object: Optional[Objectdata] = None
    cbs_indeling: Optional[CbsIndeling] = Field(default=None, alias="cbsIndeling")
    fotos: Optional[List[Foto]] = None
    referenties: Optional[List[Referentieobject]] = None
    vorige_verkopen: Optional[List[VorigeVerkoop]] = Field(
        default=None, alias="vorigeVerkopen"
    )
    rapport: Optional[Rapport] = None
    factuur: Optional[Factuur] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "aangemaakt",
        "status",
        "origineleInput",
        "adres",
        "model",
        "taxatie",
        "object",
        "cbsIndeling",
        "fotos",
        "referenties",
        "vorigeVerkopen",
        "rapport",
        "factuur",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Waardering from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of originele_input
        if self.originele_input:
            _dict["origineleInput"] = self.originele_input.to_dict()
        # override the default output from pydantic by calling `to_dict()` of adres
        if self.adres:
            _dict["adres"] = self.adres.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model
        if self.model:
            _dict["model"] = self.model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of taxatie
        if self.taxatie:
            _dict["taxatie"] = self.taxatie.to_dict()
        # override the default output from pydantic by calling `to_dict()` of object
        if self.object:
            _dict["object"] = self.object.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cbs_indeling
        if self.cbs_indeling:
            _dict["cbsIndeling"] = self.cbs_indeling.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in fotos (list)
        _items = []
        if self.fotos:
            for _item_fotos in self.fotos:
                if _item_fotos:
                    _items.append(_item_fotos.to_dict())
            _dict["fotos"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in referenties (list)
        _items = []
        if self.referenties:
            for _item_referenties in self.referenties:
                if _item_referenties:
                    _items.append(_item_referenties.to_dict())
            _dict["referenties"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vorige_verkopen (list)
        _items = []
        if self.vorige_verkopen:
            for _item_vorige_verkopen in self.vorige_verkopen:
                if _item_vorige_verkopen:
                    _items.append(_item_vorige_verkopen.to_dict())
            _dict["vorigeVerkopen"] = _items
        # override the default output from pydantic by calling `to_dict()` of rapport
        if self.rapport:
            _dict["rapport"] = self.rapport.to_dict()
        # override the default output from pydantic by calling `to_dict()` of factuur
        if self.factuur:
            _dict["factuur"] = self.factuur.to_dict()
        # set to None if fotos (nullable) is None
        # and model_fields_set contains the field
        if self.fotos is None and "fotos" in self.model_fields_set:
            _dict["fotos"] = None

        # set to None if referenties (nullable) is None
        # and model_fields_set contains the field
        if self.referenties is None and "referenties" in self.model_fields_set:
            _dict["referenties"] = None

        # set to None if vorige_verkopen (nullable) is None
        # and model_fields_set contains the field
        if self.vorige_verkopen is None and "vorige_verkopen" in self.model_fields_set:
            _dict["vorigeVerkopen"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Waardering from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "aangemaakt": obj.get("aangemaakt"),
                "status": obj.get("status"),
                "origineleInput": (
                    WaarderingInputParameters.from_dict(obj["origineleInput"])
                    if obj.get("origineleInput") is not None
                    else None
                ),
                "adres": (
                    Adres.from_dict(obj["adres"])
                    if obj.get("adres") is not None
                    else None
                ),
                "model": (
                    Modeldata.from_dict(obj["model"])
                    if obj.get("model") is not None
                    else None
                ),
                "taxatie": (
                    Taxatiedata.from_dict(obj["taxatie"])
                    if obj.get("taxatie") is not None
                    else None
                ),
                "object": (
                    Objectdata.from_dict(obj["object"])
                    if obj.get("object") is not None
                    else None
                ),
                "cbsIndeling": (
                    CbsIndeling.from_dict(obj["cbsIndeling"])
                    if obj.get("cbsIndeling") is not None
                    else None
                ),
                "fotos": (
                    [Foto.from_dict(_item) for _item in obj["fotos"]]
                    if obj.get("fotos") is not None
                    else None
                ),
                "referenties": (
                    [Referentieobject.from_dict(_item) for _item in obj["referenties"]]
                    if obj.get("referenties") is not None
                    else None
                ),
                "vorigeVerkopen": (
                    [VorigeVerkoop.from_dict(_item) for _item in obj["vorigeVerkopen"]]
                    if obj.get("vorigeVerkopen") is not None
                    else None
                ),
                "rapport": (
                    Rapport.from_dict(obj["rapport"])
                    if obj.get("rapport") is not None
                    else None
                ),
                "factuur": (
                    Factuur.from_dict(obj["factuur"])
                    if obj.get("factuur") is not None
                    else None
                ),
            }
        )
        return _obj
