# coding: utf-8

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from calcasa.api.models.aanvraagdoel import Aanvraagdoel
from calcasa.api.models.klantwaarde_type import KlantwaardeType
from calcasa.api.models.product_type import ProductType
from typing import Optional, Set
from typing_extensions import Self


class WaarderingInputParameters(BaseModel):
    """
    WaarderingInputParameters
    """  # noqa: E501

    geldverstrekker: Optional[StrictStr] = Field(
        default=None,
        description="Ongebruikt voor alle producttypen op dit moment. Deze informatie komt uit de credentials.",
    )
    product_type: ProductType = Field(alias="productType")
    hypotheekwaarde: Optional[StrictInt] = Field(
        default=None,
        description="Verplicht voor de producttypen `modelwaardeDesktopTaxatie` en `desktopTaxatie`. Voor het aanvraagdoel `hypotheekOphogen` is dit de som van de huidige hypotheeksom en de ophoging. In hele euros.",
    )
    aanvraagdoel: Optional[Aanvraagdoel] = None
    klantwaarde: Optional[StrictInt] = Field(
        default=None,
        description="Verplicht voor de producttypen `modelwaardeDesktopTaxatie` en `desktopTaxatie`. In hele euros. De waarde zoals bekend bij de klant met bijbehorende KlantwaardeType.",
    )
    klantwaarde_type: Optional[KlantwaardeType] = Field(
        default=None, alias="klantwaardeType"
    )
    is_bestaande_woning: Optional[StrictBool] = Field(
        default=None,
        description="Verplicht voor de producttypen `modelwaardeDesktopTaxatie` en `desktopTaxatie`. Geeft aan of het te waarderen object een bestaande koopwoning is.",
        alias="isBestaandeWoning",
    )
    bag_nummeraanduiding_id: StrictInt = Field(
        description="Verplicht voor alle producttypen. Het BAG (Basisregistratie Adressen en Gebouwen) nummeraanduiding id.",
        alias="bagNummeraanduidingId",
    )
    is_nhg: Optional[StrictBool] = Field(
        default=None,
        description="Verplicht voor de producttypen `modelwaardeDesktopTaxatie` en `desktopTaxatie`. Geeft aan of er gebruikt gemaakt wordt van de Nationale Hypotheekgarantie.",
        alias="isNhg",
    )
    is_bestaande_nhg_hypotheek: Optional[StrictBool] = Field(
        default=None,
        description="Verplicht te gebruiken voor de combinatie van de producttypen `modelwaardeDesktopTaxatie` en `desktopTaxatie`, als er gebruikt gemaakt wordt van de Nationale Hypotheekgarantie (`isNhg`) en het aanvraagdoel niet `aankoopNieuweWoning` is. Geeft aan of er bij de eventuele bestaande hypotheek gebruik is gemaakt van de Nationale Hypotheekgarantie.",
        alias="isBestaandeNhgHypotheek",
    )
    benodigde_overbrugging: Optional[StrictInt] = Field(
        default=None,
        description="Verplicht voor de combinatie van de producttypen `modelwaardeDesktopTaxatie` en `desktopTaxatie` en het aanvraagdoel `overbruggingsfinanciering`. In hele euros.",
        alias="benodigdeOverbrugging",
    )
    peildatum: Optional[date] = Field(
        default=None,
        description="Optioneel te gebruiken voor de producttypen `modelwaardeRisico`. Peildatum voor de aanvraag. Standaard de datum van vandaag. Supports yyyy-MM-dd or optionally yyyy-MM-ddTHH:mm:ssZ (ISO) with the time stamp assumed to be in UTC and the time is dropped before using the value.",
    )
    is_erfpacht: Optional[StrictBool] = Field(
        default=None,
        description="Potentieel verplicht voor de product typen `modelwaardeDesktopTaxatie` en `desktopTaxatie` afhankelijk van de geldverstrekker- en accountconfiguratie.",
        alias="isErfpacht",
    )
    klantkenmerk: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=100)]
    ] = Field(
        default=None,
        description="Vrij veld voor het opslaan van een klantkenmerk, zoals bijvoorbeeld een dossiernummer of andere interne referentie. Dit veld komt later weer terug in het `origineleInput` veld in het `waardering` object.",
    )
    __properties: ClassVar[List[str]] = [
        "geldverstrekker",
        "productType",
        "hypotheekwaarde",
        "aanvraagdoel",
        "klantwaarde",
        "klantwaardeType",
        "isBestaandeWoning",
        "bagNummeraanduidingId",
        "isNhg",
        "isBestaandeNhgHypotheek",
        "benodigdeOverbrugging",
        "peildatum",
        "isErfpacht",
        "klantkenmerk",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WaarderingInputParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if peildatum (nullable) is None
        # and model_fields_set contains the field
        if self.peildatum is None and "peildatum" in self.model_fields_set:
            _dict["peildatum"] = None

        # set to None if is_erfpacht (nullable) is None
        # and model_fields_set contains the field
        if self.is_erfpacht is None and "is_erfpacht" in self.model_fields_set:
            _dict["isErfpacht"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WaarderingInputParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "geldverstrekker": obj.get("geldverstrekker"),
                "productType": obj.get("productType"),
                "hypotheekwaarde": obj.get("hypotheekwaarde"),
                "aanvraagdoel": obj.get("aanvraagdoel"),
                "klantwaarde": obj.get("klantwaarde"),
                "klantwaardeType": obj.get("klantwaardeType"),
                "isBestaandeWoning": obj.get("isBestaandeWoning"),
                "bagNummeraanduidingId": obj.get("bagNummeraanduidingId"),
                "isNhg": obj.get("isNhg"),
                "isBestaandeNhgHypotheek": obj.get("isBestaandeNhgHypotheek"),
                "benodigdeOverbrugging": obj.get("benodigdeOverbrugging"),
                "peildatum": obj.get("peildatum"),
                "isErfpacht": obj.get("isErfpacht"),
                "klantkenmerk": obj.get("klantkenmerk"),
            }
        )
        return _obj
