# coding: utf-8

"""
Copyright 2025 Calcasa B.V.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Calcasa Public API
The Calcasa API is used to connect to Calcasa provided services. For more information, please visit [Documentation](https://docs.calcasa.nl) or [GitHub](https://github.com/calcasa/api).

Contact: info@calcasa.nl
Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from calcasa.api.models.waardering_ontwikkeling_kwartaal import (
    WaarderingOntwikkelingKwartaal,
)
from typing import Optional, Set
from typing_extensions import Self


class WaarderingOntwikkeling(BaseModel):
    """
    WaarderingOntwikkeling
    """  # noqa: E501

    id: Optional[UUID] = Field(
        default=None, description="Id van de waardering of tracking Id."
    )
    object_prijs_ontwikkeling: Optional[List[WaarderingOntwikkelingKwartaal]] = Field(
        default=None,
        description="De prijsontwikkeling van het gewaardeerde object.",
        alias="objectPrijsOntwikkeling",
    )
    object_prijs_ontwikkeling_per_vierkantemeter: Optional[
        List[WaarderingOntwikkelingKwartaal]
    ] = Field(
        default=None,
        description="De prijsontwikkeling van het gewaardeerde object per vierkantemeter.",
        alias="objectPrijsOntwikkelingPerVierkantemeter",
    )
    buurt_prijs_ontwikkeling: Optional[List[WaarderingOntwikkelingKwartaal]] = Field(
        default=None,
        description="De prijsontwikkeling van de buurt van het gewaardeerde object.",
        alias="buurtPrijsOntwikkeling",
    )
    buurt_prijs_ontwikkeling_per_vierkantemeter: Optional[
        List[WaarderingOntwikkelingKwartaal]
    ] = Field(
        default=None,
        description="De prijsontwikkeling van de buurt van het gewaardeerde object per vierkantemeter.",
        alias="buurtPrijsOntwikkelingPerVierkantemeter",
    )
    wijk_prijs_ontwikkeling: Optional[List[WaarderingOntwikkelingKwartaal]] = Field(
        default=None,
        description="De prijsontwikkeling van de wijk van het gewaardeerde object.",
        alias="wijkPrijsOntwikkeling",
    )
    wijk_prijs_ontwikkeling_per_vierkantemeter: Optional[
        List[WaarderingOntwikkelingKwartaal]
    ] = Field(
        default=None,
        description="De prijsontwikkeling van de wijk van het gewaardeerde object per vierkantemeter.",
        alias="wijkPrijsOntwikkelingPerVierkantemeter",
    )
    gemeente_prijs_ontwikkeling: Optional[List[WaarderingOntwikkelingKwartaal]] = Field(
        default=None,
        description="De prijsontwikkeling van de gemeente van het gewaardeerde object.",
        alias="gemeentePrijsOntwikkeling",
    )
    gemeente_prijs_ontwikkeling_per_vierkantemeter: Optional[
        List[WaarderingOntwikkelingKwartaal]
    ] = Field(
        default=None,
        description="De prijsontwikkeling van de gemeente van het gewaardeerde object per vierkantemeter.",
        alias="gemeentePrijsOntwikkelingPerVierkantemeter",
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "objectPrijsOntwikkeling",
        "objectPrijsOntwikkelingPerVierkantemeter",
        "buurtPrijsOntwikkeling",
        "buurtPrijsOntwikkelingPerVierkantemeter",
        "wijkPrijsOntwikkeling",
        "wijkPrijsOntwikkelingPerVierkantemeter",
        "gemeentePrijsOntwikkeling",
        "gemeentePrijsOntwikkelingPerVierkantemeter",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WaarderingOntwikkeling from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in object_prijs_ontwikkeling (list)
        _items = []
        if self.object_prijs_ontwikkeling:
            for _item_object_prijs_ontwikkeling in self.object_prijs_ontwikkeling:
                if _item_object_prijs_ontwikkeling:
                    _items.append(_item_object_prijs_ontwikkeling.to_dict())
            _dict["objectPrijsOntwikkeling"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in object_prijs_ontwikkeling_per_vierkantemeter (list)
        _items = []
        if self.object_prijs_ontwikkeling_per_vierkantemeter:
            for (
                _item_object_prijs_ontwikkeling_per_vierkantemeter
            ) in self.object_prijs_ontwikkeling_per_vierkantemeter:
                if _item_object_prijs_ontwikkeling_per_vierkantemeter:
                    _items.append(
                        _item_object_prijs_ontwikkeling_per_vierkantemeter.to_dict()
                    )
            _dict["objectPrijsOntwikkelingPerVierkantemeter"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in buurt_prijs_ontwikkeling (list)
        _items = []
        if self.buurt_prijs_ontwikkeling:
            for _item_buurt_prijs_ontwikkeling in self.buurt_prijs_ontwikkeling:
                if _item_buurt_prijs_ontwikkeling:
                    _items.append(_item_buurt_prijs_ontwikkeling.to_dict())
            _dict["buurtPrijsOntwikkeling"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in buurt_prijs_ontwikkeling_per_vierkantemeter (list)
        _items = []
        if self.buurt_prijs_ontwikkeling_per_vierkantemeter:
            for (
                _item_buurt_prijs_ontwikkeling_per_vierkantemeter
            ) in self.buurt_prijs_ontwikkeling_per_vierkantemeter:
                if _item_buurt_prijs_ontwikkeling_per_vierkantemeter:
                    _items.append(
                        _item_buurt_prijs_ontwikkeling_per_vierkantemeter.to_dict()
                    )
            _dict["buurtPrijsOntwikkelingPerVierkantemeter"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in wijk_prijs_ontwikkeling (list)
        _items = []
        if self.wijk_prijs_ontwikkeling:
            for _item_wijk_prijs_ontwikkeling in self.wijk_prijs_ontwikkeling:
                if _item_wijk_prijs_ontwikkeling:
                    _items.append(_item_wijk_prijs_ontwikkeling.to_dict())
            _dict["wijkPrijsOntwikkeling"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in wijk_prijs_ontwikkeling_per_vierkantemeter (list)
        _items = []
        if self.wijk_prijs_ontwikkeling_per_vierkantemeter:
            for (
                _item_wijk_prijs_ontwikkeling_per_vierkantemeter
            ) in self.wijk_prijs_ontwikkeling_per_vierkantemeter:
                if _item_wijk_prijs_ontwikkeling_per_vierkantemeter:
                    _items.append(
                        _item_wijk_prijs_ontwikkeling_per_vierkantemeter.to_dict()
                    )
            _dict["wijkPrijsOntwikkelingPerVierkantemeter"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in gemeente_prijs_ontwikkeling (list)
        _items = []
        if self.gemeente_prijs_ontwikkeling:
            for _item_gemeente_prijs_ontwikkeling in self.gemeente_prijs_ontwikkeling:
                if _item_gemeente_prijs_ontwikkeling:
                    _items.append(_item_gemeente_prijs_ontwikkeling.to_dict())
            _dict["gemeentePrijsOntwikkeling"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in gemeente_prijs_ontwikkeling_per_vierkantemeter (list)
        _items = []
        if self.gemeente_prijs_ontwikkeling_per_vierkantemeter:
            for (
                _item_gemeente_prijs_ontwikkeling_per_vierkantemeter
            ) in self.gemeente_prijs_ontwikkeling_per_vierkantemeter:
                if _item_gemeente_prijs_ontwikkeling_per_vierkantemeter:
                    _items.append(
                        _item_gemeente_prijs_ontwikkeling_per_vierkantemeter.to_dict()
                    )
            _dict["gemeentePrijsOntwikkelingPerVierkantemeter"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WaarderingOntwikkeling from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "objectPrijsOntwikkeling": (
                    [
                        WaarderingOntwikkelingKwartaal.from_dict(_item)
                        for _item in obj["objectPrijsOntwikkeling"]
                    ]
                    if obj.get("objectPrijsOntwikkeling") is not None
                    else None
                ),
                "objectPrijsOntwikkelingPerVierkantemeter": (
                    [
                        WaarderingOntwikkelingKwartaal.from_dict(_item)
                        for _item in obj["objectPrijsOntwikkelingPerVierkantemeter"]
                    ]
                    if obj.get("objectPrijsOntwikkelingPerVierkantemeter") is not None
                    else None
                ),
                "buurtPrijsOntwikkeling": (
                    [
                        WaarderingOntwikkelingKwartaal.from_dict(_item)
                        for _item in obj["buurtPrijsOntwikkeling"]
                    ]
                    if obj.get("buurtPrijsOntwikkeling") is not None
                    else None
                ),
                "buurtPrijsOntwikkelingPerVierkantemeter": (
                    [
                        WaarderingOntwikkelingKwartaal.from_dict(_item)
                        for _item in obj["buurtPrijsOntwikkelingPerVierkantemeter"]
                    ]
                    if obj.get("buurtPrijsOntwikkelingPerVierkantemeter") is not None
                    else None
                ),
                "wijkPrijsOntwikkeling": (
                    [
                        WaarderingOntwikkelingKwartaal.from_dict(_item)
                        for _item in obj["wijkPrijsOntwikkeling"]
                    ]
                    if obj.get("wijkPrijsOntwikkeling") is not None
                    else None
                ),
                "wijkPrijsOntwikkelingPerVierkantemeter": (
                    [
                        WaarderingOntwikkelingKwartaal.from_dict(_item)
                        for _item in obj["wijkPrijsOntwikkelingPerVierkantemeter"]
                    ]
                    if obj.get("wijkPrijsOntwikkelingPerVierkantemeter") is not None
                    else None
                ),
                "gemeentePrijsOntwikkeling": (
                    [
                        WaarderingOntwikkelingKwartaal.from_dict(_item)
                        for _item in obj["gemeentePrijsOntwikkeling"]
                    ]
                    if obj.get("gemeentePrijsOntwikkeling") is not None
                    else None
                ),
                "gemeentePrijsOntwikkelingPerVierkantemeter": (
                    [
                        WaarderingOntwikkelingKwartaal.from_dict(_item)
                        for _item in obj["gemeentePrijsOntwikkelingPerVierkantemeter"]
                    ]
                    if obj.get("gemeentePrijsOntwikkelingPerVierkantemeter") is not None
                    else None
                ),
            }
        )
        return _obj
