# Open Food Facts Python SDK

<div align="center">
  <img width="400" src="https://blog.openfoodfacts.org/wp-content/uploads/2022/05/EXE_LOGO_OFF_RVB_Plan-de-travail-1-copie-0-1-768x256.jpg" alt="Open Food Facts"/>
</div>

## Status

[![Project Status](https://opensource.box.com/badges/active.svg)](https://opensource.box.com/badges)
[![Build Status](https://travis-ci.org/openfoodfacts/openfoodfacts-python.svg?branch=master)](https://travis-ci.org/openfoodfacts/openfoodfacts-python)
[![codecov](https://codecov.io/gh/openfoodfacts/openfoodfacts-python/branch/master/graph/badge.svg)](https://codecov.io/gh/openfoodfacts/openfoodfacts-python)
[![Latest Version](https://img.shields.io/pypi/v/openfoodfacts.svg)](https://pypi.org/project/openfoodfacts)
[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://github.com/openfoodfacts/openfoodfacts-python/blob/master/LICENSE)

## Description

This is the official Python SDK for the [Open Food Facts](https://world.openfoodfacts.org/) project.
It provides a simple interface to the [Open Food Facts API](https://openfoodfacts.github.io/openfoodfacts-server/api/) and allows you to:

- Get information about a product
- Perform text search
- Create a new product or update an existing one

It also provides some helper functions to make it easier to work with Open Food Facts data and APIs, such as:

- getting translation of a taxonomized field in a given language
- downloading and iterating over the Open Food Facts data dump
- handling OCRs of Open Food Facts images generated by Google Cloud Vision

Please note that this SDK is still in beta and the API is subject to change. Make sure to pin the version in your requirements file.

## Installation

The easiest way to install the SDK is through pip:

    pip install openfoodfacts

or manually from source:

    git clone https://github.com/openfoodfacts/openfoodfacts-python
    cd openfoodfacts-python
    python setup.py install

## Examples

All the examples below assume that you have imported the SDK and instanciated the API object:

```python
import openfoodfacts

# User-Agent is mandatory
api = openfoodfacts.API(user_agent="MyAwesomeApp/1.0")
```

*Get information about a product*

```python
code = "3017620422003"
api.product.get(code, fields=["code", "product_name"])
# {'code': '3017620422003', 'product_name': 'Nutella'}
```

*Perform text search*

```python
api.product.text_search("mineral water")
# {"count": 3006628, "page": 1, "page_count": 20, "page_size": 20, "products": [{...}], "skip": 0}
```

*Create a new product or update an existing one*

```python
results = api.product.update({
    "code": CODE,
    "product_name_en": "blueberry jam",
    "ingredients_text_en": "blueberries, sugar, pectin, citric acid"
})
```

with `CODE` the product barcode. The rest of the body should be a dictionary of fields to create/update.

To see all possible capabilities, check out the [usage guide](https://openfoodfacts.github.io/openfoodfacts-python/usage/).

## Third party applications
If you use this SDK, feel free to open a PR to add your application in this list.

## Contributing

Any help is welcome, as long as you don't break the continuous integration.
Fork the repository and open a Pull Request directly on the "develop" branch.
A maintainer will review and integrate your changes.

Maintainers:

- [Anubhav Bhargava](https://github.com/Anubhav-Bhargava)
- [Frank Rousseau](https://github.com/frankrousseau)
- [Pierre Slamich](https://github.com/teolemon)
- [Raphaël](https://github.com/raphael0202)

Contributors:

- Agamit Sudo
- [Daniel Stolpe](https://github.com/numberpi)
- [Enioluwa Segun](https://github.com/enioluwas)
- [Nicolas Leger](https://github.com/nicolasleger)
- [Pablo Hinojosa](https://github.com/Pablohn26)
- [Andrea Stagi](https://github.com/astagi)
- [Benoît Prieur](https://github.com/benprieur)
- [Aadarsh A](https://github.com/aadarsh-ram)

## Copyright and License

    Copyright 2016-2022 Open Food Facts

The Open Food Facts Python SDK is licensed under the [MIT License](https://github.com/openfoodfacts/openfoodfacts-python/blob/develop/LICENSE).
