from typing import Any, Dict, Iterable, Optional

import dlt
import pendulum
from dlt.sources import DltResource

from .helpers import create_dynamic_resource, get_access_token

# Define available resources with their endpoints and field mappings
FLUXX_RESOURCES = {
    "claim": {
        "endpoint": "claim",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Amount fields (double for monetary values)
            "amount_recommended": {"data_type": "double", "field_type": "column"},
            "amount_requested": {"data_type": "double", "field_type": "column"},
            # Boolean fields
            "approved": {"data_type": "bool", "field_type": "column"},
            "is_temp_precreate": {"data_type": "bool", "field_type": "column"},
            "submitted": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "approved_at": {"data_type": "timestamp", "field_type": "column"},
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "due_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "submitted_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "timestamp"},
            # Date fields
            "timestamp_entered_state": {"data_type": "date", "field_type": "column"},
            # Integer/ID fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "state": {"data_type": "text", "field_type": "column"},
            # String/Text fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "previous_state": {"data_type": "text", "field_type": "string"},
            "request_grant_id": {"data_type": "text", "field_type": "string"},
            "request_grantee_user_name": {"data_type": "text", "field_type": "string"},
            "request_org_acronym": {"data_type": "text", "field_type": "string"},
            "request_org_name": {"data_type": "text", "field_type": "string"},
            "state_description": {"data_type": "text", "field_type": "string"},
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields (stored as bigint for IDs or json for arrays)
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "claim_expenses": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "etl_claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant": {"data_type": "bigint", "field_type": "relation"},
            "grant_request": {"data_type": "bigint", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "bigint", "field_type": "relation"},
            "model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request_or_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "relationships": {"data_type": "json", "field_type": "relation"},
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "organization": {
        "endpoint": "organization",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Core text fields
            "name": {"data_type": "text", "field_type": "column"},
            "acronym": {"data_type": "text", "field_type": "column"},
            "legal_name": {"data_type": "text", "field_type": "column"},
            "name_foreign_language": {"data_type": "text", "field_type": "column"},
            # Boolean fields
            "active": {"data_type": "bool", "field_type": "column"},
            "avoid_list": {"data_type": "bool", "field_type": "column"},
            "c3_status_approved": {"data_type": "bool", "field_type": "column"},
            "c3_status_checked": {"data_type": "bool", "field_type": "column"},
            "can_receive_international_funding": {
                "data_type": "bool",
                "field_type": "column",
            },
            "chapter_sig_eligible_for_funding": {
                "data_type": "text",
                "field_type": "column",
            },
            "deny_list_overridden": {"data_type": "bool", "field_type": "column"},
            "ed_needed": {"data_type": "text", "field_type": "column"},
            "equivalency_determination_on_file": {
                "data_type": "bool",
                "field_type": "column",
            },
            "is_grantee": {"data_type": "bool", "field_type": "boolean"},
            "is_grantor": {"data_type": "bool", "field_type": "boolean"},
            "is_fs_or_so": {"data_type": "text", "field_type": "column"},
            "is_org_501c3": {"data_type": "bool", "field_type": "column"},
            "is_org_chapter": {"data_type": "bool", "field_type": "column"},
            "is_org_chapter_non_profit": {"data_type": "bool", "field_type": "column"},
            "is_sponsored_org": {"data_type": "bool", "field_type": "column"},
            "is_temp_precreate": {"data_type": "bool", "field_type": "column"},
            "cc_pub78_verified": {"data_type": "bool", "field_type": "column"},
            "system_generated_denylist": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "c3_checked_at": {"data_type": "timestamp", "field_type": "column"},
            "cc_checked_at": {"data_type": "timestamp", "field_type": "column"},
            "demographic_data_last_modified_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "ext_sync_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "ofac_run_at": {"data_type": "timestamp", "field_type": "column"},
            # Date fields
            "chapter_election_date": {"data_type": "date", "field_type": "column"},
            "ed_expiration_date": {"data_type": "date", "field_type": "column"},
            "ed_submission_date": {"data_type": "date", "field_type": "column"},
            "fx_date_1": {"data_type": "date", "field_type": "column"},
            "fx_date_2": {"data_type": "date", "field_type": "column"},
            "fx_applied_date_1": {"data_type": "date", "field_type": "column"},
            "fx_applied_date_2": {"data_type": "date", "field_type": "column"},
            "cc_reinstatement_date": {"data_type": "date", "field_type": "column"},
            "cc_revocation_date": {"data_type": "date", "field_type": "column"},
            "tax_period": {"data_type": "date", "field_type": "column"},
            "tax_registration_date": {"data_type": "date", "field_type": "column"},
            "timestamp_entered_state": {"data_type": "date", "field_type": "date"},
            # Address fields
            "street_address": {"data_type": "text", "field_type": "column"},
            "street_address2": {"data_type": "text", "field_type": "column"},
            "city": {"data_type": "text", "field_type": "column"},
            "state": {"data_type": "text", "field_type": "column"},
            "postal_code": {"data_type": "text", "field_type": "column"},
            # Contact fields
            "email": {"data_type": "text", "field_type": "column"},
            "phone": {"data_type": "text", "field_type": "column"},
            "phone_extension": {"data_type": "text", "field_type": "column"},
            "other_contact": {"data_type": "text", "field_type": "column"},
            "fax": {"data_type": "text", "field_type": "column"},
            # URL fields
            "url": {"data_type": "text", "field_type": "column"},
            "blog_url": {"data_type": "text", "field_type": "column"},
            "twitter_url": {"data_type": "text", "field_type": "column"},
            # Geographic coordinates
            "latitude": {"data_type": "double", "field_type": "column"},
            "longitude": {"data_type": "double", "field_type": "column"},
            # Numeric fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "fx_spotrate_1": {"data_type": "double", "field_type": "column"},
            "fx_spotrate_2": {"data_type": "double", "field_type": "column"},
            "fx_type_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "ofac_result_id": {"data_type": "bigint", "field_type": "column"},
            "ofac_run_id": {"data_type": "bigint", "field_type": "column"},
            "ofac_score": {"data_type": "double", "field_type": "column"},
            "primary_user_organization_id": {
                "data_type": "bigint",
                "field_type": "column",
            },
            "program_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            "translation_priority": {"data_type": "bigint", "field_type": "long"},
            "year_founded": {"data_type": "bigint", "field_type": "column"},
            # Tax and compliance fields
            "tax_id": {"data_type": "text", "field_type": "column"},
            "tax_class": {"data_type": "text", "field_type": "column"},
            "tax_notes": {"data_type": "text", "field_type": "column"},
            "duns_number": {"data_type": "text", "field_type": "column"},
            "vendor_number": {"data_type": "text", "field_type": "column"},
            "deductibility": {"data_type": "text", "field_type": "column"},
            "foundation": {"data_type": "text", "field_type": "column"},
            "subsection": {"data_type": "text", "field_type": "column"},
            # Charity Check fields
            "cc_affiliation_code": {"data_type": "text", "field_type": "column"},
            "cc_affiliation_code_description": {
                "data_type": "text",
                "field_type": "column",
            },
            "cc_bmf_status": {"data_type": "text", "field_type": "column"},
            "cc_bmf_subsection": {"data_type": "text", "field_type": "column"},
            "cc_charity_check_last_modified": {
                "data_type": "text",
                "field_type": "column",
            },
            "cc_checked_by": {"data_type": "text", "field_type": "column"},
            "cc_deductibility_code": {"data_type": "text", "field_type": "column"},
            "cc_deductibility_code_description": {
                "data_type": "text",
                "field_type": "column",
            },
            "cc_foundation_509a_status": {"data_type": "text", "field_type": "column"},
            "cc_foundation_code": {"data_type": "text", "field_type": "column"},
            "cc_foundation_code_description": {
                "data_type": "text",
                "field_type": "column",
            },
            "cc_foundation_type_code": {"data_type": "text", "field_type": "column"},
            "cc_legal_name": {"data_type": "text", "field_type": "column"},
            "cc_organization_name": {"data_type": "text", "field_type": "column"},
            "cc_organization_ntee_codes": {"data_type": "text", "field_type": "column"},
            "cc_revocation_code": {"data_type": "text", "field_type": "column"},
            "cc_ruling_year": {"data_type": "text", "field_type": "column"},
            "cc_subsection_description": {"data_type": "text", "field_type": "column"},
            # OFAC fields
            "ofac_state": {"data_type": "text", "field_type": "column"},
            "org_ofac_result": {"data_type": "text", "field_type": "column"},
            "org_ofac_run_date": {"data_type": "text", "field_type": "column"},
            # Organization type fields
            "organization_type": {"data_type": "text", "field_type": "column"},
            "organization_mission": {"data_type": "text", "field_type": "column"},
            "chaptersig_standing_status": {"data_type": "text", "field_type": "column"},
            "chaptersig_status": {"data_type": "text", "field_type": "column"},
            "chaptersig_type": {"data_type": "text", "field_type": "column"},
            "chaptersigbadge": {"data_type": "text", "field_type": "column"},
            # Additional text fields
            "additional_internal_comments": {
                "data_type": "text",
                "field_type": "column",
            },
            "banking_beneficiary_name": {"data_type": "text", "field_type": "column"},
            "comments_to_applicant": {"data_type": "text", "field_type": "column"},
            "educational_roles": {"data_type": "text", "field_type": "column"},
            "educational_roles_1": {"data_type": "text", "field_type": "column"},
            "fdtn_country": {"data_type": "text", "field_type": "column"},
            "grantee_publish_contact_warning": {
                "data_type": "text",
                "field_type": "column",
            },
            "iso_country": {"data_type": "text", "field_type": "column"},
            "member_nova_id": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "org_bank_details": {"data_type": "text", "field_type": "column"},
            "org_bureau_region": {"data_type": "text", "field_type": "column"},
            "regional_bureau": {"data_type": "text", "field_type": "column"},
            "salesforce_oid": {"data_type": "text", "field_type": "column"},
            "state_1": {"data_type": "text", "field_type": "column"},
            "ext_sync_id": {"data_type": "text", "field_type": "column"},
            "grant_summary_table": {"data_type": "text", "field_type": "column"},
            "sort_as_name": {"data_type": "text", "field_type": "column"},
            # String computed fields
            "__advanced_filter": {"data_type": "text", "field_type": "string"},
            "__full_text": {"data_type": "text", "field_type": "string"},
            "__index_plan": {"data_type": "text", "field_type": "string"},
            "__managed_in_elastic_search": {
                "data_type": "text",
                "field_type": "string",
            },
            "__recent_records_tracking": {"data_type": "text", "field_type": "string"},
            "address_str": {"data_type": "text", "field_type": "string"},
            "all_notes": {"data_type": "text", "field_type": "string"},
            "c3_serialized_response": {"data_type": "text", "field_type": "string"},
            "city_str": {"data_type": "text", "field_type": "string"},
            "country_code": {"data_type": "text", "field_type": "string"},
            "country_name": {"data_type": "text", "field_type": "string"},
            "country_str": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "geocode_response_full_address": {
                "data_type": "text",
                "field_type": "string",
            },
            "organization_id": {"data_type": "text", "field_type": "string"},
            "postal_code_str": {"data_type": "text", "field_type": "string"},
            "previous_state": {"data_type": "text", "field_type": "string"},
            "state_code": {"data_type": "text", "field_type": "string"},
            "state_description": {"data_type": "text", "field_type": "string"},
            "state_name": {"data_type": "text", "field_type": "string"},
            "state_str": {"data_type": "text", "field_type": "string"},
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "sum_ofac_state": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - IDs
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "data_language_id": {"data_type": "bigint", "field_type": "relation"},
            "fx_type": {"data_type": "bigint", "field_type": "relation"},
            "geo_country_id": {"data_type": "bigint", "field_type": "relation"},
            "geo_county_id": {"data_type": "bigint", "field_type": "relation"},
            "geo_place_id": {"data_type": "bigint", "field_type": "relation"},
            "geo_state_id": {"data_type": "bigint", "field_type": "relation"},
            "model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "parent_org_id": {"data_type": "bigint", "field_type": "relation"},
            "primary_user_id": {"data_type": "bigint", "field_type": "relation"},
            "program": {"data_type": "bigint", "field_type": "relation"},
            "segment": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "translation_assignee": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "zoom_concept_initiative": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            # Relation fields - Arrays/JSON (keeping only _ids versions where available)
            "affiliate_type_list": {"data_type": "json", "field_type": "relation"},
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "all_request_ids": {"data_type": "json", "field_type": "relation"},
            "any_etl_relationship_ids": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "bank_accounts": {"data_type": "json", "field_type": "relation"},
            "census_code_results": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "coi_ids": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "etl_request_budget_ids": {"data_type": "json", "field_type": "relation"},
            "etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fiscal_requests": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_ids": {"data_type": "json", "field_type": "relation"},
            "grant_initiative_ids": {"data_type": "json", "field_type": "relation"},
            "grant_outcome_ids": {"data_type": "json", "field_type": "relation"},
            "grant_program_ids": {"data_type": "json", "field_type": "relation"},
            "grant_requests": {"data_type": "json", "field_type": "relation"},
            "grant_sub_initiative_ids": {"data_type": "json", "field_type": "relation"},
            "grant_sub_program_ids": {"data_type": "json", "field_type": "relation"},
            "group_ids": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_document_ids": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "ofac_people": {"data_type": "json", "field_type": "relation"},
            "organization_connection_requests": {
                "data_type": "json",
                "field_type": "relation",
            },
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "posts": {"data_type": "json", "field_type": "relation"},
            "primary_user_organization": {
                "data_type": "json",
                "field_type": "relation",
            },
            "project_ids_sql": {"data_type": "json", "field_type": "relation"},
            "project_organizations": {"data_type": "json", "field_type": "relation"},
            "projects": {"data_type": "json", "field_type": "relation"},
            "rd_tab_bank_accounts": {"data_type": "json", "field_type": "relation"},
            "rd_tab_cois": {"data_type": "json", "field_type": "relation"},
            "rd_tab_dyn_model_2": {"data_type": "json", "field_type": "relation"},
            "rd_tab_dyn_model_4": {"data_type": "json", "field_type": "relation"},
            "rd_tab_etl_relationships": {"data_type": "json", "field_type": "relation"},
            "rd_tab_grant_requests_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request_or_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_gs_streams": {"data_type": "json", "field_type": "relation"},
            "rd_tab_lois": {"data_type": "json", "field_type": "relation"},
            "rd_tab_model_documents": {"data_type": "json", "field_type": "relation"},
            "rd_tab_projects": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_regrants": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reports": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reviews": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_transactions": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_users": {"data_type": "json", "field_type": "relation"},
            "rd_tab_work_tasks": {"data_type": "json", "field_type": "relation"},
            "regrant_ids": {"data_type": "json", "field_type": "relation"},
            "related_bank_account_ids": {"data_type": "json", "field_type": "relation"},
            "related_coi_ids": {"data_type": "json", "field_type": "relation"},
            "related_granted_request_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_gs_stream_ids": {"data_type": "json", "field_type": "relation"},
            "related_loi_ids": {"data_type": "json", "field_type": "relation"},
            "related_org_ids": {"data_type": "json", "field_type": "relation"},
            "related_request_ids": {"data_type": "json", "field_type": "relation"},
            "related_request_review_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_user_ids": {"data_type": "json", "field_type": "relation"},
            "request_ids": {"data_type": "json", "field_type": "relation"},
            "request_organizations": {"data_type": "json", "field_type": "relation"},
            "request_regrants": {"data_type": "json", "field_type": "relation"},
            "request_report_ids": {"data_type": "json", "field_type": "relation"},
            "request_transaction_ids": {"data_type": "json", "field_type": "relation"},
            "reverse_parent_financial_audit_organization_MacModelTypeDynFinancialAudit": {
                "data_type": "json",
                "field_type": "relation",
            },
            "reverse_project_sponsor_GrantRequest": {
                "data_type": "json",
                "field_type": "relation",
            },
            "reverse_undelete_org_MacModelTypeDynTool": {
                "data_type": "json",
                "field_type": "relation",
            },
            "satellite_org_ids": {"data_type": "json", "field_type": "relation"},
            "tag_ids": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "user_ids": {"data_type": "json", "field_type": "relation"},
            "user_organizations": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "grant_request": {
        "endpoint": "grant_request",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "acting_as_a_fiscal_sponsor": {"data_type": "bool", "field_type": "column"},
            "amount_requested_equals_amount_recommended": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "amount_requested_less_than_amount_recommended": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "amount_requested_local_equals_amount_recommended_local": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "amount_requested_local_less_than_amount_recommended_local": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "board_authorization_required": {
                "data_type": "bool",
                "field_type": "column",
            },
            "coi_resolved": {"data_type": "bool", "field_type": "boolean"},
            "created_at_equals_updated_at": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "display_warnings": {"data_type": "bool", "field_type": "column"},
            "extension_flag": {"data_type": "bool", "field_type": "column"},
            "granted": {"data_type": "bool", "field_type": "column"},
            "grant_begins_at_less_than_grant_closed_at": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "has_been_rejected": {"data_type": "bool", "field_type": "boolean"},
            "has_zero_balance": {"data_type": "bool", "field_type": "boolean"},
            "is_grantee_a_person": {"data_type": "bool", "field_type": "column"},
            "is_temp_precreate": {"data_type": "bool", "field_type": "column"},
            "missing_request_id": {"data_type": "bool", "field_type": "boolean"},
            "multi_year": {"data_type": "bool", "field_type": "column"},
            "renewal_grant": {"data_type": "bool", "field_type": "column"},
            "skip_hgrant_flag": {"data_type": "bool", "field_type": "column"},
            "use_custom_fx_rate": {"data_type": "bool", "field_type": "column"},
            # double/Money fields
            "amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "amount_recommended_cpi_adjusted": {
                "data_type": "double",
                "field_type": "column",
            },
            "amount_recommended_fx_2": {"data_type": "double", "field_type": "column"},
            "amount_recommended_local": {
                "data_type": "double",
                "field_type": "column",
            },
            "amount_requested": {"data_type": "double", "field_type": "column"},
            "amount_requested_fx_2": {"data_type": "double", "field_type": "column"},
            "amount_requested_local": {"data_type": "double", "field_type": "column"},
            "donated_amount": {"data_type": "double", "field_type": "column"},
            "donated_amount_fx_2": {"data_type": "double", "field_type": "column"},
            "donated_amount_local": {"data_type": "double", "field_type": "column"},
            "fx_rate1": {"data_type": "double", "field_type": "column"},
            "fx_rate2": {"data_type": "double", "field_type": "column"},
            "fx_spotrate_1": {"data_type": "double", "field_type": "column"},
            "fx_spotrate_2": {"data_type": "double", "field_type": "column"},
            "funds_expended_amount": {"data_type": "double", "field_type": "column"},
            # double fields
            "amount_dues": {"data_type": "double", "field_type": "double"},
            "amount_paids": {"data_type": "double", "field_type": "double"},
            "amount_recommended_or_requested": {
                "data_type": "double",
                "field_type": "double",
            },
            "grant_amount_funded": {"data_type": "double", "field_type": "double"},
            "total_amount_paid": {"data_type": "double", "field_type": "double"},
            # Date fields
            "fips_grant_ends_at_complex": {"data_type": "date", "field_type": "date"},
            "fips_grant_ends_at_simple": {"data_type": "date", "field_type": "date"},
            "grant_ends_at": {"data_type": "date", "field_type": "date"},
            "request_grant_ends_at_complex": {
                "data_type": "date",
                "field_type": "date",
            },
            "request_grant_ends_at_simple": {"data_type": "date", "field_type": "date"},
            "timestamp_entered_state": {"data_type": "date", "field_type": "date"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "donated_at": {"data_type": "timestamp", "field_type": "column"},
            "fip_projected_end_at": {"data_type": "timestamp", "field_type": "column"},
            "funds_expended_at": {"data_type": "timestamp", "field_type": "column"},
            "fx_applied_date_1": {"data_type": "timestamp", "field_type": "column"},
            "fx_applied_date_2": {"data_type": "timestamp", "field_type": "column"},
            "fx_date_1": {"data_type": "timestamp", "field_type": "column"},
            "fx_date_2": {"data_type": "timestamp", "field_type": "column"},
            "grant_agreement_at": {"data_type": "timestamp", "field_type": "column"},
            "grant_approved_at": {"data_type": "timestamp", "field_type": "column"},
            "grant_begins_at": {"data_type": "timestamp", "field_type": "column"},
            "grant_closed_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "request_received_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Bigint/Long fields
            "calculated_duration_in_months": {
                "data_type": "bigint",
                "field_type": "long",
            },
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "donated_hours": {"data_type": "bigint", "field_type": "column"},
            "duration_in_months": {"data_type": "bigint", "field_type": "column"},
            "fund_docket_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "po_number": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            "simple_duration_in_months": {"data_type": "bigint", "field_type": "long"},
            "spending_year": {"data_type": "bigint", "field_type": "column"},
            "translation_priority": {"data_type": "bigint", "field_type": "long"},
            # Regular text fields
            "base_request_id": {"data_type": "text", "field_type": "column"},
            "delta": {"data_type": "text", "field_type": "column"},
            "fip_consultant_name": {"data_type": "text", "field_type": "column"},
            "fip_title": {"data_type": "text", "field_type": "column"},
            "fip_title_native": {"data_type": "text", "field_type": "column"},
            "fip_title_native_updated": {"data_type": "text", "field_type": "column"},
            "funding_general_operating_support": {
                "data_type": "text",
                "field_type": "column",
            },
            "grantee_budget_config": {"data_type": "text", "field_type": "column"},
            "gs_grant_ends_at": {"data_type": "text", "field_type": "column"},
            "gs_project_name": {"data_type": "text", "field_type": "column"},
            "ierf_budget_end_at": {"data_type": "text", "field_type": "column"},
            "ierf_due_diligence_board_review": {
                "data_type": "text",
                "field_type": "column",
            },
            "ierf_due_diligence_noc4_work": {
                "data_type": "text",
                "field_type": "column",
            },
            "ierf_due_diligence_overlap": {"data_type": "text", "field_type": "column"},
            "ierf_due_diligence_risks": {"data_type": "text", "field_type": "column"},
            "ierf_goals": {"data_type": "text", "field_type": "column"},
            "ierf_probability": {"data_type": "text", "field_type": "column"},
            "ierf_proposed_end_at": {"data_type": "text", "field_type": "column"},
            "ierf_tactics": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "ofac_state": {"data_type": "text", "field_type": "column"},
            "project_summary": {"data_type": "text", "field_type": "column"},
            "project_summary_native": {"data_type": "text", "field_type": "column"},
            "project_summary_native_updated": {
                "data_type": "text",
                "field_type": "column",
            },
            "request_type_identifier": {"data_type": "text", "field_type": "column"},
            "state": {"data_type": "text", "field_type": "column"},
            "type": {"data_type": "text", "field_type": "column"},
            # String computed fields
            "__advanced_filter": {"data_type": "text", "field_type": "string"},
            "__full_text": {"data_type": "text", "field_type": "string"},
            "__index_plan": {"data_type": "text", "field_type": "string"},
            "__managed_in_elastic_search": {
                "data_type": "text",
                "field_type": "string",
            },
            "__recent_records_tracking": {"data_type": "text", "field_type": "string"},
            "all_notes": {"data_type": "text", "field_type": "string"},
            "allocation_hierarchy": {"data_type": "text", "field_type": "string"},
            "coi_identified": {"data_type": "text", "field_type": "string"},
            "donated_by_name": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "fiscal_org_acronym": {"data_type": "text", "field_type": "string"},
            "fiscal_org_name": {"data_type": "text", "field_type": "string"},
            "fiscal_org_sort_as_name": {"data_type": "text", "field_type": "string"},
            "grantee_city": {"data_type": "text", "field_type": "string"},
            "grantee_email": {"data_type": "text", "field_type": "string"},
            "grantee_fax": {"data_type": "text", "field_type": "string"},
            "grantee_name_first_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_name_last_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_owner_name": {"data_type": "text", "field_type": "string"},
            "grantee_phone": {"data_type": "text", "field_type": "string"},
            "grantee_street_address": {"data_type": "text", "field_type": "string"},
            "grantee_street_address_2": {"data_type": "text", "field_type": "string"},
            "grantee_user_name": {"data_type": "text", "field_type": "string"},
            "grant_id": {"data_type": "text", "field_type": "string"},
            "grant_or_request_id": {"data_type": "text", "field_type": "string"},
            "parent_fiscal_acronym": {"data_type": "text", "field_type": "string"},
            "parent_program_acronym": {"data_type": "text", "field_type": "string"},
            "previous_state": {"data_type": "text", "field_type": "string"},
            "program_name": {"data_type": "text", "field_type": "string"},
            "program_org_acronym": {"data_type": "text", "field_type": "string"},
            "program_org_name": {"data_type": "text", "field_type": "string"},
            "program_org_sort_as_name": {"data_type": "text", "field_type": "string"},
            "request_hierarchy": {"data_type": "text", "field_type": "string"},
            "request_id": {"data_type": "text", "field_type": "string"},
            "state_description": {"data_type": "text", "field_type": "string"},
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "sum_ofac_state": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - single IDs (bigint)
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "data_language_id": {"data_type": "bigint", "field_type": "relation"},
            "donated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "first_fund": {"data_type": "bigint", "field_type": "relation"},
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_organization_id": {"data_type": "bigint", "field_type": "relation"},
            "fiscal_org_owner_id": {"data_type": "bigint", "field_type": "relation"},
            "fiscal_signatory_id": {"data_type": "bigint", "field_type": "relation"},
            "fund_docket": {"data_type": "bigint", "field_type": "relation"},
            "funding_source_allocation_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "funding_source_allocation_initiative_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "funding_source_allocation_program_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "funding_source_allocation_sub_initiative_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "funding_source_allocation_sub_program_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fx_type_id": {"data_type": "bigint", "field_type": "relation"},
            "grantee": {"data_type": "bigint", "field_type": "relation"},
            "grantee_org_owner_id": {"data_type": "bigint", "field_type": "relation"},
            "grantee_signatory_id": {"data_type": "bigint", "field_type": "relation"},
            "grantee_user_id": {"data_type": "bigint", "field_type": "relation"},
            "initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "outcome_id": {"data_type": "bigint", "field_type": "relation"},
            "program_id": {"data_type": "bigint", "field_type": "relation"},
            "program_lead_id": {"data_type": "bigint", "field_type": "relation"},
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_organization_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "project_sponsor": {"data_type": "bigint", "field_type": "relation"},
            "regional_reviewer": {"data_type": "bigint", "field_type": "relation"},
            "related_mel_program_summary": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "related_user1_id": {"data_type": "bigint", "field_type": "relation"},
            "related_user2_id": {"data_type": "bigint", "field_type": "relation"},
            "related_user3_id": {"data_type": "bigint", "field_type": "relation"},
            "renewal_application": {"data_type": "bigint", "field_type": "relation"},
            "secondary_program_lead_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "segment": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "sub_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "sub_program_id": {"data_type": "bigint", "field_type": "relation"},
            "translation_assignee": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "zoom_concept_initiative": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            # Relation fields - Arrays/JSON
            "affiliate_type_list": {"data_type": "json", "field_type": "relation"},
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "all_request_program_ids": {"data_type": "json", "field_type": "relation"},
            "any_etl_relationship_ids": {"data_type": "json", "field_type": "relation"},
            "any_request_user_ids": {"data_type": "json", "field_type": "relation"},
            "any_request_user_ids_for_permission_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "any_userorg_ids": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "budget_requests": {"data_type": "json", "field_type": "relation"},
            "claims": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "coi_ids": {"data_type": "json", "field_type": "relation"},
            "concept_initiative_relationships": {
                "data_type": "json",
                "field_type": "relation",
            },
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "current_reviewer_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "etl_grantee_budget_tracker_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_grantee_budget_tracker_period_data": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "etl_request_budget_ids": {"data_type": "json", "field_type": "relation"},
            "etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fund_ids": {"data_type": "json", "field_type": "relation"},
            "funding_source_ids": {"data_type": "json", "field_type": "relation"},
            "geo_place_ids": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_org_ids": {"data_type": "json", "field_type": "relation"},
            "grantee_budgets": {"data_type": "json", "field_type": "relation"},
            "grantee_user_ids": {"data_type": "json", "field_type": "relation"},
            "group_ids": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "gs_stream_requests": {"data_type": "json", "field_type": "relation"},
            "gs_streams": {"data_type": "json", "field_type": "relation"},
            "lead_user_ids": {"data_type": "json", "field_type": "relation"},
            "letter_request_reports": {"data_type": "json", "field_type": "relation"},
            "loi_ids": {"data_type": "json", "field_type": "relation"},
            "mel": {"data_type": "json", "field_type": "relation"},
            "model_document_ids": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "bigint", "field_type": "relation"},
            "moderator_userorg_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "nonmoderator_user_ids": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "org_owner_user_ids": {"data_type": "json", "field_type": "relation"},
            "permission_donor_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "permission_user_ids": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "program_or_fiscal_org_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "program_organization_coi_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "project_requests": {"data_type": "json", "field_type": "relation"},
            "projects": {"data_type": "json", "field_type": "relation"},
            "raw_request_org_ids": {"data_type": "json", "field_type": "relation"},
            "rd_tab_claims": {"data_type": "json", "field_type": "relation"},
            "rd_tab_cois": {"data_type": "json", "field_type": "relation"},
            "rd_tab_dyn_model_1": {"data_type": "json", "field_type": "relation"},
            "rd_tab_dyn_model_2": {"data_type": "json", "field_type": "relation"},
            "rd_tab_dyn_model_4": {"data_type": "json", "field_type": "relation"},
            "rd_tab_etl_relationships": {"data_type": "json", "field_type": "relation"},
            "rd_tab_fund_dockets": {"data_type": "json", "field_type": "relation"},
            "rd_tab_funding_sources": {"data_type": "json", "field_type": "relation"},
            "rd_tab_funds": {"data_type": "json", "field_type": "relation"},
            "rd_tab_grantee_budgets": {"data_type": "json", "field_type": "relation"},
            "rd_tab_gs_streams": {"data_type": "json", "field_type": "relation"},
            "rd_tab_lois": {"data_type": "json", "field_type": "relation"},
            "rd_tab_model_documents": {"data_type": "json", "field_type": "relation"},
            "rd_tab_organizations": {"data_type": "json", "field_type": "relation"},
            "rd_tab_projects": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_amendments": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_request_regrants": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reports": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reviews": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_transactions": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_requests_grant": {"data_type": "json", "field_type": "relation"},
            "rd_tab_requests_request": {"data_type": "json", "field_type": "relation"},
            "rd_tab_requests_request_or_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_users": {"data_type": "json", "field_type": "relation"},
            "rd_tab_work_tasks": {"data_type": "json", "field_type": "relation"},
            "related_amendments": {"data_type": "json", "field_type": "relation"},
            "related_coi_ids": {"data_type": "json", "field_type": "relation"},
            "related_fund_docket_ids": {"data_type": "json", "field_type": "relation"},
            "related_grant_organization_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_grantee_budget": {"data_type": "json", "field_type": "relation"},
            "related_gs_stream_ids": {"data_type": "json", "field_type": "relation"},
            "related_loi_ids": {"data_type": "json", "field_type": "relation"},
            "related_organization_ids": {"data_type": "json", "field_type": "relation"},
            "related_project_ids": {"data_type": "json", "field_type": "relation"},
            "related_regrant_ids": {"data_type": "json", "field_type": "relation"},
            "related_request_organization_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_request_report_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_request_review_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_request_transaction_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_user1_ids": {"data_type": "json", "field_type": "relation"},
            "related_user2_ids": {"data_type": "json", "field_type": "relation"},
            "related_user3_ids": {"data_type": "json", "field_type": "relation"},
            "related_user_ids": {"data_type": "json", "field_type": "relation"},
            "request_amendment_ids": {"data_type": "json", "field_type": "relation"},
            "request_amendments": {"data_type": "json", "field_type": "relation"},
            "request_evaluation_metrics": {
                "data_type": "json",
                "field_type": "relation",
            },
            "request_funding_sources": {"data_type": "json", "field_type": "relation"},
            "request_org_ids": {"data_type": "json", "field_type": "relation"},
            "request_organizations": {"data_type": "json", "field_type": "relation"},
            "request_outcomes": {"data_type": "json", "field_type": "relation"},
            "request_program_ids": {"data_type": "json", "field_type": "relation"},
            "request_recommendations": {"data_type": "json", "field_type": "relation"},
            "request_recommenders": {"data_type": "json", "field_type": "relation"},
            "request_regrants": {"data_type": "json", "field_type": "relation"},
            "request_report_ids": {"data_type": "json", "field_type": "relation"},
            "request_review_ids": {"data_type": "json", "field_type": "relation"},
            "request_review_sets": {"data_type": "json", "field_type": "relation"},
            "request_transaction_ids": {"data_type": "json", "field_type": "relation"},
            "request_user_ids": {"data_type": "json", "field_type": "relation"},
            "reverse_parent_financial_audit_grant_request_MacModelTypeDynFinancialAudit": {
                "data_type": "json",
                "field_type": "relation",
            },
            "reverse_parent_request_MacModelTypeDynMeetingsAndSiteVisits3": {
                "data_type": "json",
                "field_type": "relation",
            },
            "reverse_renewal_application_GrantRequest": {
                "data_type": "json",
                "field_type": "relation",
            },
            "reviewer_group_ids": {"data_type": "json", "field_type": "relation"},
            "reviewer_user_ids": {"data_type": "json", "field_type": "relation"},
            "secondary_lead_user_ids": {"data_type": "json", "field_type": "relation"},
            "secondary_programs": {"data_type": "json", "field_type": "relation"},
            "simple_reviewer_user_ids": {"data_type": "json", "field_type": "relation"},
            "tag_ids": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "un_approved_request_programs": {
                "data_type": "json",
                "field_type": "relation",
            },
            "updated_by": {"data_type": "bigint", "field_type": "relation"},
            "user_dynamic_relationships": {
                "data_type": "json",
                "field_type": "relation",
            },
            "user_ids": {"data_type": "json", "field_type": "relation"},
            "users_with_conflicts": {"data_type": "json", "field_type": "relation"},
            "wiki_documents": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "user": {
        "endpoint": "user",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "active": {"data_type": "bool", "field_type": "column"},
            "approved": {"data_type": "bool", "field_type": "column"},
            "confirmed": {"data_type": "bool", "field_type": "column"},
            "connected_to_gs": {"data_type": "bool", "field_type": "column"},
            "cookie_consent": {"data_type": "bool", "field_type": "column"},
            "display_debug_errors": {"data_type": "bool", "field_type": "boolean"},
            "do_not_email": {"data_type": "bool", "field_type": "column"},
            "email_exists": {"data_type": "bool", "field_type": "boolean"},
            "inactive_flag": {"data_type": "bool", "field_type": "column"},
            "lock_dashboard_manager": {"data_type": "bool", "field_type": "column"},
            "loi_user_reset_password": {"data_type": "bool", "field_type": "column"},
            "skip_mfa": {"data_type": "bool", "field_type": "column"},
            "test_user_flag": {"data_type": "bool", "field_type": "boolean"},
            # Date fields
            "birth_at": {"data_type": "date", "field_type": "column"},
            "confirmation_sent_at": {"data_type": "date", "field_type": "date"},
            "current_login_at": {"data_type": "date", "field_type": "date"},
            "last_logged_in_at": {"data_type": "date", "field_type": "date"},
            "timestamp_entered_state": {"data_type": "date", "field_type": "date"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "employee_hired_at": {"data_type": "timestamp", "field_type": "column"},
            "employee_retired_at": {"data_type": "timestamp", "field_type": "column"},
            "employee_terminated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "ext_sync_at": {"data_type": "timestamp", "field_type": "column"},
            "last_failed_password_update_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "last_login_at": {"data_type": "timestamp", "field_type": "column"},
            "last_request_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "mfa_configuration_confirmed_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "ofac_run_at": {"data_type": "timestamp", "field_type": "column"},
            "password_reset_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Bigint/Long fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "failed_login_count": {"data_type": "bigint", "field_type": "long"},
            "failed_password_update_count": {
                "data_type": "bigint",
                "field_type": "column",
            },
            "initiative_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "login_count": {"data_type": "bigint", "field_type": "long"},
            "matching_gift_profile_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "ofac_result_id": {"data_type": "bigint", "field_type": "column"},
            "ofac_run_id": {"data_type": "bigint", "field_type": "column"},
            "ofac_score": {"data_type": "bigint", "field_type": "long"},
            "program_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            "sub_initiative_id": {"data_type": "bigint", "field_type": "column"},
            "sub_program_id": {"data_type": "bigint", "field_type": "column"},
            "user_profile_id": {"data_type": "bigint", "field_type": "column"},
            # Regular text fields
            "assistant_email": {"data_type": "text", "field_type": "column"},
            "assistant_name": {"data_type": "text", "field_type": "column"},
            "assistant_phone": {"data_type": "text", "field_type": "column"},
            "blog_url": {"data_type": "text", "field_type": "column"},
            "country_str": {"data_type": "text", "field_type": "column"},
            "dashboard_settings": {"data_type": "text", "field_type": "column"},
            "dashboard_template_ids": {"data_type": "text", "field_type": "column"},
            "dashboard_type": {"data_type": "text", "field_type": "column"},
            "delta": {"data_type": "text", "field_type": "column"},
            "email": {"data_type": "text", "field_type": "column"},
            "ext_sync_id": {"data_type": "text", "field_type": "column"},
            "facebook_url": {"data_type": "text", "field_type": "column"},
            "first_name": {"data_type": "text", "field_type": "column"},
            "grant_summary_table": {"data_type": "text", "field_type": "column"},
            "last_name": {"data_type": "text", "field_type": "column"},
            "linkedin_url": {"data_type": "text", "field_type": "column"},
            "login": {"data_type": "text", "field_type": "column"},
            "mailchimp_leid": {"data_type": "text", "field_type": "column"},
            "mfa_country_code": {"data_type": "text", "field_type": "column"},
            "mfa_otp_key": {"data_type": "text", "field_type": "column"},
            "mfa_phone": {"data_type": "text", "field_type": "column"},
            "mfa_sms_token": {"data_type": "text", "field_type": "column"},
            "mfa_strategy": {"data_type": "text", "field_type": "column"},
            "middle_initial": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "ofac_state": {"data_type": "text", "field_type": "column"},
            "other_contact": {"data_type": "text", "field_type": "column"},
            "personal_city": {"data_type": "text", "field_type": "column"},
            "personal_email": {"data_type": "text", "field_type": "column"},
            "personal_fax": {"data_type": "text", "field_type": "column"},
            "personal_mobile": {"data_type": "text", "field_type": "column"},
            "personal_phone": {"data_type": "text", "field_type": "column"},
            "personal_postal_code": {"data_type": "text", "field_type": "column"},
            "personal_street_address": {"data_type": "text", "field_type": "column"},
            "personal_street_address2": {"data_type": "text", "field_type": "column"},
            "prefix": {"data_type": "text", "field_type": "column"},
            "salutation": {"data_type": "text", "field_type": "column"},
            "signal_following_email_alert": {
                "data_type": "text",
                "field_type": "column",
            },
            "signal_mention_email_alert": {"data_type": "text", "field_type": "column"},
            "sso_uid": {"data_type": "text", "field_type": "column"},
            "state": {"data_type": "text", "field_type": "column"},
            "state_str": {"data_type": "text", "field_type": "column"},
            "twitter_url": {"data_type": "text", "field_type": "column"},
            "user_salutation": {"data_type": "text", "field_type": "column"},
            "work_extension": {"data_type": "text", "field_type": "column"},
            "work_fax": {"data_type": "text", "field_type": "column"},
            "work_phone": {"data_type": "text", "field_type": "column"},
            # String computed fields
            "__advanced_filter": {"data_type": "text", "field_type": "string"},
            "__full_text": {"data_type": "text", "field_type": "string"},
            "__index_plan": {"data_type": "text", "field_type": "string"},
            "__managed_in_elastic_search": {
                "data_type": "text",
                "field_type": "string",
            },
            "all_notes": {"data_type": "text", "field_type": "string"},
            "city": {"data_type": "text", "field_type": "string"},
            "current_login_ip": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "first_name_foreign_language": {
                "data_type": "text",
                "field_type": "string",
            },
            "full_name": {"data_type": "text", "field_type": "string"},
            "last_full_name": {"data_type": "text", "field_type": "string"},
            "last_login_ip": {"data_type": "text", "field_type": "string"},
            "last_name_foreign_language": {"data_type": "text", "field_type": "string"},
            "main_phone": {"data_type": "text", "field_type": "string"},
            "middle_name_foreign_language": {
                "data_type": "text",
                "field_type": "string",
            },
            "previous_state": {"data_type": "text", "field_type": "string"},
            "primary_org_phone": {"data_type": "text", "field_type": "string"},
            "primary_org_sort_name": {"data_type": "text", "field_type": "string"},
            "state_description": {"data_type": "text", "field_type": "string"},
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "sum_ofac_state": {"data_type": "text", "field_type": "string"},
            "time_zone": {"data_type": "text", "field_type": "string"},
            "title": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            "user_id": {"data_type": "text", "field_type": "string"},
            # Relation fields - single IDs (bigint)
            "client": {"data_type": "bigint", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "geo_country_id": {"data_type": "bigint", "field_type": "relation"},
            "geo_state_id": {"data_type": "bigint", "field_type": "relation"},
            "initiative": {"data_type": "bigint", "field_type": "relation"},
            "language_id": {"data_type": "bigint", "field_type": "relation"},
            "matching_gift_profile": {"data_type": "bigint", "field_type": "relation"},
            "organization_id": {"data_type": "bigint", "field_type": "relation"},
            "personal_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "personal_geo_county_id": {"data_type": "bigint", "field_type": "relation"},
            "personal_geo_state_id": {"data_type": "bigint", "field_type": "relation"},
            "primary_organization_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "primary_user_organization_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program": {"data_type": "bigint", "field_type": "relation"},
            "segment": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "sub_initiative": {"data_type": "bigint", "field_type": "relation"},
            "sub_program": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "zoom_concept_initiative": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            # Relation fields - Arrays/JSON
            "affiliate_type_for_any_list": {
                "data_type": "json",
                "field_type": "relation",
            },
            "affiliate_type_for_request_user_list": {
                "data_type": "json",
                "field_type": "relation",
            },
            "affiliate_type_for_user_organization_list": {
                "data_type": "json",
                "field_type": "relation",
            },
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "any_etl_relationship_ids": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "bank_accounts": {"data_type": "json", "field_type": "relation"},
            "census_code_results": {"data_type": "json", "field_type": "relation"},
            "chatbot_chats": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "coi_ids": {"data_type": "json", "field_type": "relation"},
            "conflict_coi_ids": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "etl_request_budget_ids": {"data_type": "json", "field_type": "relation"},
            "etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "expirable_tokens": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fiscal_org_owner_grants": {"data_type": "json", "field_type": "relation"},
            "fiscal_signatory_grants": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_program_ids": {"data_type": "json", "field_type": "relation"},
            "grantee_org_owner_grants": {"data_type": "json", "field_type": "relation"},
            "grantee_org_owner_outcome_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "grantee_program_ids": {"data_type": "json", "field_type": "relation"},
            "grantee_signatory_grants": {"data_type": "json", "field_type": "relation"},
            "group_ids": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_document_ids": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "organization_connection_requests": {
                "data_type": "json",
                "field_type": "relation",
            },
            "perishable_tokens": {"data_type": "json", "field_type": "relation"},
            "personas": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "posts": {"data_type": "json", "field_type": "relation"},
            "program_lead_requests": {"data_type": "json", "field_type": "relation"},
            "rd_tab_bank_accounts": {"data_type": "json", "field_type": "relation"},
            "rd_tab_cois": {"data_type": "json", "field_type": "relation"},
            "rd_tab_dyn_model_2": {"data_type": "json", "field_type": "relation"},
            "rd_tab_etl_relationships": {"data_type": "json", "field_type": "relation"},
            "rd_tab_funds": {"data_type": "json", "field_type": "relation"},
            "rd_tab_grant_requests_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request_or_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_lois": {"data_type": "json", "field_type": "relation"},
            "rd_tab_model_documents": {"data_type": "json", "field_type": "relation"},
            "rd_tab_organizations": {"data_type": "json", "field_type": "relation"},
            "rd_tab_projects": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_regrants": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reports": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reviews": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_transactions": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_users": {"data_type": "json", "field_type": "relation"},
            "rd_tab_work_tasks": {"data_type": "json", "field_type": "relation"},
            "real_me_invitations": {"data_type": "json", "field_type": "relation"},
            "related_bank_account_ids": {"data_type": "json", "field_type": "relation"},
            "related_coi_ids": {"data_type": "json", "field_type": "relation"},
            "related_fund_ids": {"data_type": "json", "field_type": "relation"},
            "related_granted_request_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_loi_ids": {"data_type": "json", "field_type": "relation"},
            "related_model_document_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_organization_ids": {"data_type": "json", "field_type": "relation"},
            "related_project_ids": {"data_type": "json", "field_type": "relation"},
            "related_regrant_ids": {"data_type": "json", "field_type": "relation"},
            "related_request_ids": {"data_type": "json", "field_type": "relation"},
            "related_request_regrant_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_request_review_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_ungranted_request_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_user1_grants": {"data_type": "json", "field_type": "relation"},
            "related_user2_grants": {"data_type": "json", "field_type": "relation"},
            "related_user3_grants": {"data_type": "json", "field_type": "relation"},
            "related_user_ids": {"data_type": "json", "field_type": "relation"},
            "relationships": {"data_type": "json", "field_type": "relation"},
            "request_regrants": {"data_type": "json", "field_type": "relation"},
            "request_report_ids": {"data_type": "json", "field_type": "relation"},
            "request_review_ids": {"data_type": "json", "field_type": "relation"},
            "request_transaction_ids": {"data_type": "json", "field_type": "relation"},
            "request_users": {"data_type": "json", "field_type": "relation"},
            "reverse_regional_reviewer_GrantRequest": {
                "data_type": "json",
                "field_type": "relation",
            },
            "reverse_staff_owner_MacModelTypeDynMeetingsAndSiteVisits3": {
                "data_type": "json",
                "field_type": "relation",
            },
            "role_ids": {"data_type": "json", "field_type": "relation"},
            "role_programs": {"data_type": "json", "field_type": "relation"},
            "role_users": {"data_type": "json", "field_type": "relation"},
            "role_users_programs": {"data_type": "json", "field_type": "relation"},
            "segment_tags": {"data_type": "json", "field_type": "relation"},
            "segments": {"data_type": "json", "field_type": "relation"},
            "signatory_grant_initiative_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "signatory_grant_outcome_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "signatory_grant_program_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "signatory_grant_sub_initiative_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "signatory_grant_sub_program_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translatable_languages": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "translator_language_ids": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "bigint", "field_type": "relation"},
            "user_organization_ids": {"data_type": "json", "field_type": "relation"},
            "user_permissions": {"data_type": "json", "field_type": "relation"},
            "user_profile_ids": {"data_type": "json", "field_type": "relation"},
            "user_request_ids": {"data_type": "json", "field_type": "relation"},
            "user_segment_tags": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "work_tasks_related_to_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "program": {
        "endpoint": "program",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "not_retired": {"data_type": "bool", "field_type": "boolean"},
            "retired": {"data_type": "bool", "field_type": "column"},
            "rollup": {"data_type": "bool", "field_type": "boolean"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Bigint/ID fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "config": {"data_type": "text", "field_type": "column"},
            "description": {"data_type": "text", "field_type": "column"},
            "exclude_from_mel": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "request_round": {"data_type": "text", "field_type": "column"},
            "sap_cost_centre": {"data_type": "text", "field_type": "column"},
            # String computed fields
            "__advanced_filter": {"data_type": "text", "field_type": "string"},
            "__full_text": {"data_type": "text", "field_type": "string"},
            "__index_plan": {"data_type": "text", "field_type": "string"},
            "__managed_in_elastic_search": {
                "data_type": "text",
                "field_type": "string",
            },
            "all_notes": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - single IDs (bigint)
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "parent_id": {"data_type": "bigint", "field_type": "relation"},
            "parent_program": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "children_programs": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "concept_initiative_ids": {"data_type": "json", "field_type": "relation"},
            "concept_program_ids": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fsa_etl_request_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "fsa_etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "posts": {"data_type": "json", "field_type": "relation"},
            "rd_tab_concept_initiatives": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_sub_programs": {"data_type": "json", "field_type": "relation"},
            "request_etl_request_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "request_etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rfs_etl_request_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rfs_etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "segments": {"data_type": "json", "field_type": "relation"},
            "sub_program_ids": {"data_type": "json", "field_type": "relation"},
            "sub_programs": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "bigint", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "request_report": {
        "endpoint": "request_report",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "amount_requested_equals_amount_recommended": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "amount_requested_less_than_amount_recommended": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "amount_requested_local_equals_amount_recommended_local": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "amount_requested_local_less_than_amount_recommended_local": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "created_at_equals_updated_at": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "grant_begins_at_less_than_grant_closed_at": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "has_been_approved": {"data_type": "bool", "field_type": "boolean"},
            "is_temp_precreate": {"data_type": "bool", "field_type": "column"},
            "request_is_granted": {"data_type": "bool", "field_type": "boolean"},
            "request_is_not_granted": {"data_type": "bool", "field_type": "boolean"},
            "system_generated_denylist": {"data_type": "bool", "field_type": "column"},
            # Date fields
            "timestamp_entered_state": {"data_type": "date", "field_type": "date"},
            # Timestamp fields
            "approved_at": {"data_type": "timestamp", "field_type": "column"},
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "due_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Bigint/Long fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "evaluation_rating": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            "translation_priority": {"data_type": "bigint", "field_type": "long"},
            # Regular text fields
            "delta": {"data_type": "text", "field_type": "column"},
            "grantee_progress_report_period": {
                "data_type": "text",
                "field_type": "column",
            },
            "grantee_progress_report_sub_period": {
                "data_type": "text",
                "field_type": "column",
            },
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "report": {"data_type": "text", "field_type": "column"},
            "report_type": {"data_type": "text", "field_type": "column"},
            "state": {"data_type": "text", "field_type": "column"},
            # String computed fields
            "__advanced_filter": {"data_type": "text", "field_type": "string"},
            "__full_text": {"data_type": "text", "field_type": "string"},
            "__index_plan": {"data_type": "text", "field_type": "string"},
            "__managed_in_elastic_search": {
                "data_type": "text",
                "field_type": "string",
            },
            "__recent_records_tracking": {"data_type": "text", "field_type": "string"},
            "all_notes": {"data_type": "text", "field_type": "string"},
            "allocation_hierarchy": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "grantee_city": {"data_type": "text", "field_type": "string"},
            "grantee_email": {"data_type": "text", "field_type": "string"},
            "grantee_fax": {"data_type": "text", "field_type": "string"},
            "grantee_name_first_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_name_last_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_org_owner_first_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_org_owner_last_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_phone": {"data_type": "text", "field_type": "string"},
            "grantee_street_address": {"data_type": "text", "field_type": "string"},
            "grantee_street_address_2": {"data_type": "text", "field_type": "string"},
            "grantee_user_first_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_user_last_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "grant_state": {"data_type": "text", "field_type": "string"},
            "previous_state": {"data_type": "text", "field_type": "string"},
            "program_org_name": {"data_type": "text", "field_type": "string"},
            "request_grant_id": {"data_type": "text", "field_type": "string"},
            "request_grantee_user_name": {"data_type": "text", "field_type": "string"},
            "request_hierarchy": {"data_type": "text", "field_type": "string"},
            "request_id_sort": {"data_type": "text", "field_type": "string"},
            "request_org_acronym": {"data_type": "text", "field_type": "string"},
            "request_org_name": {"data_type": "text", "field_type": "string"},
            "request_org_sort_name": {"data_type": "text", "field_type": "string"},
            "request_report_id": {"data_type": "text", "field_type": "string"},
            "report_type_theme_name": {"data_type": "text", "field_type": "string"},
            "state_description": {"data_type": "text", "field_type": "string"},
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - single IDs (bigint)
            "approved_by_user_id": {"data_type": "bigint", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "data_language_id": {"data_type": "bigint", "field_type": "relation"},
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grant": {"data_type": "bigint", "field_type": "relation"},
            "grant_request": {"data_type": "bigint", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "related_grantee_user_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "related_request_fiscal_organization_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "related_request_program_organization_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "segment": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "sub_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "sub_program_id": {"data_type": "bigint", "field_type": "relation"},
            "translation_assignee": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "zoom_concept_initiative": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "any_etl_relationship_ids": {"data_type": "json", "field_type": "relation"},
            "any_request_user_ids": {"data_type": "json", "field_type": "relation"},
            "any_request_user_ids_for_permission_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "any_userorg_ids": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "etl_grantee_budget_tracker_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fund_ids": {"data_type": "json", "field_type": "relation"},
            "funding_source_ids": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_ids": {"data_type": "json", "field_type": "relation"},
            "grant_program_ids": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker_period_datum_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "grantee_user_ids": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "groups": {"data_type": "json", "field_type": "relation"},
            "lead_user_ids": {"data_type": "json", "field_type": "relation"},
            "model_document_ids": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "bigint", "field_type": "relation"},
            "moderator_userorg_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "nonmoderator_user_ids": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "permission_donor_related_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "permission_donor_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "permission_related_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "posts": {"data_type": "json", "field_type": "relation"},
            "rd_tab_etl_relationships": {"data_type": "json", "field_type": "relation"},
            "rd_tab_grant_requests_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request_or_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_model_documents": {"data_type": "json", "field_type": "relation"},
            "rd_tab_organizations": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reports": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_transactions": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_users": {"data_type": "json", "field_type": "relation"},
            "rd_tab_work_tasks": {"data_type": "json", "field_type": "relation"},
            "related_any_request_ids": {"data_type": "json", "field_type": "relation"},
            "related_contingent_transaction_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "related_organization_ids": {"data_type": "json", "field_type": "relation"},
            "related_report_ids": {"data_type": "json", "field_type": "relation"},
            "related_request_ids": {"data_type": "json", "field_type": "relation"},
            "related_transaction_ids": {"data_type": "json", "field_type": "relation"},
            "related_user_ids": {"data_type": "json", "field_type": "relation"},
            "relationships": {"data_type": "json", "field_type": "relation"},
            "request_or_grant_ids": {"data_type": "json", "field_type": "relation"},
            "request_transactions": {"data_type": "json", "field_type": "relation"},
            "reviewer_user_ids": {"data_type": "json", "field_type": "relation"},
            "secondary_lead_user_ids": {"data_type": "json", "field_type": "relation"},
            "simple_reviewer_user_ids": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "transaction_report_dependencies": {
                "data_type": "json",
                "field_type": "relation",
            },
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "bigint", "field_type": "relation"},
            "user_ids": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "request_transaction": {
        "endpoint": "request_transaction",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "amount_requested_equals_amount_recommended": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "amount_requested_less_than_amount_recommended": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "amount_requested_local_equals_amount_recommended_local": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "amount_requested_local_less_than_amount_recommended_local": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "created_at_equals_updated_at": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "grant_begins_at_less_than_grant_closed_at": {
                "data_type": "bool",
                "field_type": "boolean",
            },
            "has_been_canceled": {"data_type": "bool", "field_type": "boolean"},
            "has_been_paid": {"data_type": "bool", "field_type": "boolean"},
            "use_custom_fx_rate": {"data_type": "bool", "field_type": "column"},
            # Date fields
            "timestamp_entered_state": {"data_type": "date", "field_type": "date"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "due_at": {"data_type": "timestamp", "field_type": "column"},
            "ext_sync_at": {"data_type": "timestamp", "field_type": "column"},
            "fx_applied_date_1": {"data_type": "timestamp", "field_type": "column"},
            "fx_applied_date_2": {"data_type": "timestamp", "field_type": "column"},
            "fx_date_1": {"data_type": "timestamp", "field_type": "column"},
            "fx_date_2": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "paid_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # double/Money fields
            "amount_due": {"data_type": "double", "field_type": "column"},
            "amount_due_fx_2": {"data_type": "double", "field_type": "column"},
            "amount_due_local": {"data_type": "double", "field_type": "column"},
            "amount_paid": {"data_type": "double", "field_type": "column"},
            "amount_paid_fx_2": {"data_type": "double", "field_type": "column"},
            "amount_paid_local": {"data_type": "double", "field_type": "column"},
            "fx_rate1": {"data_type": "double", "field_type": "column"},
            "fx_rate2": {"data_type": "double", "field_type": "column"},
            "fx_spotrate_1": {"data_type": "double", "field_type": "column"},
            "fx_spotrate_2": {"data_type": "double", "field_type": "column"},
            # Bigint/Long fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "fx_type_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            "spending_year": {"data_type": "bigint", "field_type": "column"},
            "translation_priority": {"data_type": "bigint", "field_type": "long"},
            # Regular text fields
            "comment": {"data_type": "text", "field_type": "column"},
            "condition": {"data_type": "text", "field_type": "column"},
            "delta": {"data_type": "text", "field_type": "column"},
            "ext_sync_id": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "payment_confirmation_number": {
                "data_type": "text",
                "field_type": "column",
            },
            "payment_type": {"data_type": "text", "field_type": "column"},
            "request_document_linked_to": {"data_type": "text", "field_type": "column"},
            "state": {"data_type": "text", "field_type": "column"},
            # String computed fields
            "__advanced_filter": {"data_type": "text", "field_type": "string"},
            "__full_text": {"data_type": "text", "field_type": "string"},
            "__index_plan": {"data_type": "text", "field_type": "string"},
            "__managed_in_elastic_search": {
                "data_type": "text",
                "field_type": "string",
            },
            "all_notes": {"data_type": "text", "field_type": "string"},
            "allocation_hierarchy": {"data_type": "text", "field_type": "string"},
            "amount_recommended_or_requested": {
                "data_type": "text",
                "field_type": "string",
            },
            "filter_state": {"data_type": "text", "field_type": "string"},
            "grantee_city": {"data_type": "text", "field_type": "string"},
            "grantee_email": {"data_type": "text", "field_type": "string"},
            "grantee_fax": {"data_type": "text", "field_type": "string"},
            "grantee_name_first_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_name_last_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_org_owner_first_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_org_owner_last_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_phone": {"data_type": "text", "field_type": "string"},
            "grantee_street_address": {"data_type": "text", "field_type": "string"},
            "grantee_street_address_2": {"data_type": "text", "field_type": "string"},
            "grantee_user_first_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grantee_user_last_name_first": {
                "data_type": "text",
                "field_type": "string",
            },
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "grant_state": {"data_type": "text", "field_type": "string"},
            "organization_payee_name": {"data_type": "text", "field_type": "string"},
            "previous_state": {"data_type": "text", "field_type": "string"},
            "program_org_name": {"data_type": "text", "field_type": "string"},
            "request_grant_id": {"data_type": "text", "field_type": "string"},
            "request_grantee_user_name": {"data_type": "text", "field_type": "string"},
            "request_hierarchy": {"data_type": "text", "field_type": "string"},
            "request_id_sort": {"data_type": "text", "field_type": "string"},
            "request_org_acronym": {"data_type": "text", "field_type": "string"},
            "request_org_name": {"data_type": "text", "field_type": "string"},
            "request_org_sort_name": {"data_type": "text", "field_type": "string"},
            "request_transaction_id": {"data_type": "text", "field_type": "string"},
            "state_description": {"data_type": "text", "field_type": "string"},
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            "user_payee_name": {"data_type": "text", "field_type": "string"},
            # Relation fields - single IDs (bigint)
            "bank_account_id": {"data_type": "bigint", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "data_language_id": {"data_type": "bigint", "field_type": "relation"},
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "from_bank_account_id": {"data_type": "bigint", "field_type": "relation"},
            "funding_source_allocation_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "funding_source_allocation_initiative_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "funding_source_allocation_program_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "funding_source_allocation_sub_initiative_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "funding_source_allocation_sub_program_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "funding_source_id": {"data_type": "bigint", "field_type": "relation"},
            "fx_type": {"data_type": "bigint", "field_type": "relation"},
            "grant": {"data_type": "bigint", "field_type": "relation"},
            "grant_model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "organization_payee_id": {"data_type": "bigint", "field_type": "relation"},
            "payment_recorded_by_id": {"data_type": "bigint", "field_type": "relation"},
            "post": {"data_type": "bigint", "field_type": "relation"},
            "program_lead_id": {"data_type": "bigint", "field_type": "relation"},
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "related_grantee_user_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "related_request_fiscal_organization_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "related_request_program_organization_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "segment": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "transaction_report_dependency": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "translation_assignee": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "user_payee_id": {"data_type": "bigint", "field_type": "relation"},
            "zoom_concept_initiative": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "any_etl_relationship_ids": {"data_type": "json", "field_type": "relation"},
            "any_request_user_ids": {"data_type": "json", "field_type": "relation"},
            "any_request_user_ids_for_permission_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "any_userorg_ids": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "etl_request_budget_ids": {"data_type": "json", "field_type": "relation"},
            "etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fund_ids": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_ids": {"data_type": "json", "field_type": "relation"},
            "grant_initiative_ids": {"data_type": "json", "field_type": "relation"},
            "grant_program_ids": {"data_type": "json", "field_type": "relation"},
            "grant_sub_initiative_ids": {"data_type": "json", "field_type": "relation"},
            "grant_sub_program_ids": {"data_type": "json", "field_type": "relation"},
            "grantee_user_ids": {"data_type": "json", "field_type": "relation"},
            "group_ids": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "lead_user_ids": {"data_type": "json", "field_type": "relation"},
            "model_document_ids": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "bigint", "field_type": "relation"},
            "moderator_userorg_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "nonmoderator_user_ids": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "permission_donor_related_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "permission_related_user_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "rd_tab_bank_accounts": {"data_type": "json", "field_type": "relation"},
            "rd_tab_etl_relationships": {"data_type": "json", "field_type": "relation"},
            "rd_tab_funding_sources": {"data_type": "json", "field_type": "relation"},
            "rd_tab_grant_requests_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_pri_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request_or_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_initiatives": {"data_type": "json", "field_type": "relation"},
            "rd_tab_organizations": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reports": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_transactions": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_users": {"data_type": "json", "field_type": "relation"},
            "related_any_request_ids": {"data_type": "json", "field_type": "relation"},
            "related_bank_account_ids": {"data_type": "json", "field_type": "relation"},
            "related_organization_ids": {"data_type": "json", "field_type": "relation"},
            "related_report_ids": {"data_type": "json", "field_type": "relation"},
            "related_request_ids": {"data_type": "json", "field_type": "relation"},
            "related_transaction_ids": {"data_type": "json", "field_type": "relation"},
            "related_user_ids": {"data_type": "json", "field_type": "relation"},
            "request_or_grant_ids": {"data_type": "json", "field_type": "relation"},
            "request_reports": {"data_type": "json", "field_type": "relation"},
            "request_transaction_funding_source_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "reviewer_user_ids": {"data_type": "json", "field_type": "relation"},
            "secondary_lead_user_ids": {"data_type": "json", "field_type": "relation"},
            "simple_reviewer_user_ids": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "bigint", "field_type": "relation"},
            "user_ids": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "sub_program": {
        "endpoint": "sub_program",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "not_retired": {"data_type": "bool", "field_type": "boolean"},
            "retired": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Bigint/ID fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "program_id": {"data_type": "bigint", "field_type": "relation"},
            # Text fields
            "description": {"data_type": "text", "field_type": "column"},
            "exclude_from_mel": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "request_round": {"data_type": "text", "field_type": "column"},
            "sap_cost_centre": {"data_type": "text", "field_type": "column"},
            # String computed fields
            "__advanced_filter": {"data_type": "text", "field_type": "string"},
            "__full_text": {"data_type": "text", "field_type": "string"},
            "__index_plan": {"data_type": "text", "field_type": "string"},
            "__managed_in_elastic_search": {
                "data_type": "text",
                "field_type": "string",
            },
            "all_notes": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - single IDs (bigint)
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "hierarchy_parent": {"data_type": "bigint", "field_type": "relation"},
            "related_initiative": {"data_type": "bigint", "field_type": "relation"},
            "related_program": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "concept_initiative_ids": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fsa_etl_request_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "fsa_etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "initiatives": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "posts": {"data_type": "json", "field_type": "relation"},
            "rd_tab_concept_initiatives": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_initiatives": {"data_type": "json", "field_type": "relation"},
            "rd_tab_programs": {"data_type": "json", "field_type": "relation"},
            "request_etl_request_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "request_etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rfs_etl_request_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rfs_etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "bigint", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "sub_initiative": {
        "endpoint": "sub_initiative",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "not_retired": {"data_type": "bool", "field_type": "boolean"},
            "retired": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Bigint/ID fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "program_id": {"data_type": "bigint", "field_type": "relation"},
            "sub_program_id": {"data_type": "bigint", "field_type": "relation"},
            # Text fields
            "description": {"data_type": "text", "field_type": "column"},
            "exclude_from_mel": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            # String computed fields
            "__advanced_filter": {"data_type": "text", "field_type": "string"},
            "__full_text": {"data_type": "text", "field_type": "string"},
            "__index_plan": {"data_type": "text", "field_type": "string"},
            "__managed_in_elastic_search": {
                "data_type": "text",
                "field_type": "string",
            },
            "all_notes": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - single IDs (bigint)
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "hierarchy_parent": {"data_type": "bigint", "field_type": "relation"},
            "related_initiative": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "concept_initiative_ids": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fsa_etl_request_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "fsa_etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "posts": {"data_type": "json", "field_type": "relation"},
            "rd_tab_concept_initiatives": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_initiatives": {"data_type": "json", "field_type": "relation"},
            "request_etl_request_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "request_etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rfs_etl_request_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rfs_etl_request_transaction_budget_ids": {
                "data_type": "json",
                "field_type": "relation",
            },
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "bigint", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "geo_city": {
        "endpoint": "geo_city",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Text/String fields
            "area_code": {"data_type": "text", "field_type": "column"},
            "es_name": {"data_type": "text", "field_type": "column"},
            "ht_name": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "postalcode": {"data_type": "text", "field_type": "column"},
            "postalCode": {"data_type": "text", "field_type": "string"},
            "relationship_models": {"data_type": "text", "field_type": "text"},
            # Numeric fields
            "latitude": {"data_type": "double", "field_type": "column"},
            "longitude": {"data_type": "double", "field_type": "column"},
            "metro_code": {"data_type": "text", "field_type": "column"},
            "original_id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Foreign key fields
            "geo_country_id": {"data_type": "bigint", "field_type": "column"},
            "geo_state_id": {"data_type": "bigint", "field_type": "column"},
            # Relation fields - single IDs
            "alert_ids_sent": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "geo_country": {"data_type": "json", "field_type": "relation"},
            "geo_state": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
        },
    },
    "geo_county": {
        "endpoint": "geo_county",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Text/String fields
            "es_name": {"data_type": "text", "field_type": "column"},
            "fips_class_code": {"data_type": "text", "field_type": "column"},
            "fips_code": {"data_type": "text", "field_type": "column"},
            "ht_name": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "relationship_models": {"data_type": "text", "field_type": "text"},
            # Boolean fields
            "retired": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Foreign key fields
            "geo_names_id": {"data_type": "bigint", "field_type": "column"},
            "geo_state_id": {"data_type": "bigint", "field_type": "column"},
            # Relation fields - single IDs
            "alert_ids_sent": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "geo_state": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
        },
    },
    "geo_place": {
        "endpoint": "geo_place",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Text/String fields
            "aka_string": {"data_type": "text", "field_type": "column"},
            "ancestry": {"data_type": "text", "field_type": "column"},
            "country_code": {"data_type": "text", "field_type": "column"},
            "description": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "relationship_models": {"data_type": "text", "field_type": "text"},
            "state_code": {"data_type": "text", "field_type": "column"},
            # Boolean fields
            "pref_flag": {"data_type": "bool", "field_type": "column"},
            "retired": {"data_type": "bool", "field_type": "column"},
            # Numeric fields
            "latitude": {"data_type": "double", "field_type": "column"},
            "longitude": {"data_type": "double", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Foreign key fields
            "parent_id": {"data_type": "bigint", "field_type": "column"},
            # Relation fields - single IDs
            "alert_ids_sent": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "organizations": {"data_type": "json", "field_type": "relation"},
        },
    },
    "geo_region": {
        "endpoint": "geo_region",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Text/String fields
            "name": {"data_type": "text", "field_type": "column"},
            "relationship_models": {"data_type": "text", "field_type": "text"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Relation fields - single IDs
            "alert_ids_sent": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "geo_country": {"data_type": "json", "field_type": "relation"},
            "geo_states": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
        },
    },
    "geo_state": {
        "endpoint": "geo_state",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Text/String fields
            "abbreviation": {"data_type": "text", "field_type": "column"},
            "es_name": {"data_type": "text", "field_type": "column"},
            "fips_10_4": {"data_type": "text", "field_type": "column"},
            "ht_name": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "relationship_models": {"data_type": "text", "field_type": "text"},
            # Boolean fields
            "retired": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Foreign key fields
            "geo_country_id": {"data_type": "bigint", "field_type": "column"},
            "geo_names_id": {"data_type": "bigint", "field_type": "column"},
            "geo_region_id": {"data_type": "bigint", "field_type": "column"},
            # Relation fields - single IDs
            "alert_ids_sent": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "geo_cities": {"data_type": "json", "field_type": "relation"},
            "geo_counties": {"data_type": "json", "field_type": "relation"},
            "geo_country": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
        },
    },
    "claim_expense": {
        "endpoint": "claim_expense",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "additional_grantee_instructions": {
                "data_type": "text",
                "field_type": "column",
            },
            "all_notes": {"data_type": "text", "field_type": "string"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Integer fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            # Relation fields - Single IDs
            "claim_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "claim": {"data_type": "json", "field_type": "relation"},
            "claim_expense_rows": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "claim_expense_datum": {
        "endpoint": "claim_expense_datum",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # double fields (monetary amounts)
            "amount_recommended": {"data_type": "double", "field_type": "column"},
            "amount_requested": {"data_type": "double", "field_type": "column"},
            "claim_amount_recommended": {
                "data_type": "double",
                "field_type": "double",
            },
            "claim_amount_requested": {"data_type": "double", "field_type": "double"},
            # Date fields
            "claim_approved_at": {"data_type": "date", "field_type": "date"},
            "claim_due_at": {"data_type": "date", "field_type": "date"},
            "claim_submitted_at": {"data_type": "date", "field_type": "date"},
            "gbt_period_end_at": {"data_type": "date", "field_type": "date"},
            "gbt_period_start_at": {"data_type": "date", "field_type": "date"},
            # Boolean fields
            "gbc_archived": {"data_type": "bool", "field_type": "boolean"},
            "gbt_period_locked": {"data_type": "bool", "field_type": "boolean"},
            # Text fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "claim_expense_additional_grantee_instructions": {
                "data_type": "text",
                "field_type": "string",
            },
            "claim_expense_row_grantee_comments": {
                "data_type": "text",
                "field_type": "string",
            },
            "claim_expense_row_staff_feedback": {
                "data_type": "text",
                "field_type": "string",
            },
            "claim_expense_row_staff_feedback_internal": {
                "data_type": "text",
                "field_type": "string",
            },
            "claim_state": {"data_type": "text", "field_type": "string"},
            "gbc_code": {"data_type": "text", "field_type": "string"},
            "gbc_description": {"data_type": "text", "field_type": "string"},
            "gbc_name": {"data_type": "text", "field_type": "string"},
            "gbc_parent_name": {"data_type": "text", "field_type": "string"},
            "gbt_row_name": {"data_type": "text", "field_type": "string"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Integer/Long fields
            "gbc_position": {"data_type": "bigint", "field_type": "long"},
            "gbt_period_order": {"data_type": "bigint", "field_type": "long"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            # Relation fields - Single IDs
            "claim_expense_id": {"data_type": "bigint", "field_type": "relation"},
            "claim_expense_row_id": {"data_type": "bigint", "field_type": "relation"},
            "claim_id": {"data_type": "bigint", "field_type": "relation"},
            "gbc_id": {"data_type": "bigint", "field_type": "relation"},
            "gbc_parent_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_period_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_row_id": {"data_type": "bigint", "field_type": "relation"},
            "grantee_budget_tracker_period_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "claim_expense_row": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker_period": {
                "data_type": "json",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "claim_expense_row": {
        "endpoint": "claim_expense_row",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "grantee_comments": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "staff_feedback": {"data_type": "text", "field_type": "column"},
            "staff_feedback_internal": {"data_type": "text", "field_type": "column"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Integer fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            # Relation fields - Single IDs
            "claim_expense_id": {"data_type": "bigint", "field_type": "relation"},
            "grantee_budget_tracker_row_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "claim_expense": {"data_type": "json", "field_type": "relation"},
            "claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "claim_expense_row_documents": {
                "data_type": "json",
                "field_type": "relation",
            },
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker_row": {
                "data_type": "json",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "grantee_budget_category": {
        "endpoint": "grantee_budget_category",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "archived": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Text fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "code": {"data_type": "text", "field_type": "column"},
            "description": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Integer fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "parent_position": {"data_type": "bigint", "field_type": "column"},
            "position": {"data_type": "bigint", "field_type": "column"},
            # Relation fields - Single IDs
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "parent_id": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "children": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "etl_claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "etl_grantee_budget_tracker_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_grantee_budget_tracker_period_data": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_category_group_relationships": {
                "data_type": "json",
                "field_type": "relation",
            },
            "grantee_budget_category_groups": {
                "data_type": "json",
                "field_type": "relation",
            },
            "grantee_budget_tracker_rows": {
                "data_type": "json",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "parent": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "grantee_budget_tracker": {
        "endpoint": "grantee_budget_tracker",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "additional_grantee_instructions": {
                "data_type": "text",
                "field_type": "column",
            },
            "all_notes": {"data_type": "text", "field_type": "string"},
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Integer fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            # Relation fields - Single IDs
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "etl_grantee_budget_tracker_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_grantee_budget_tracker_period_data": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_request": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker_periods": {
                "data_type": "json",
                "field_type": "relation",
            },
            "grantee_budget_tracker_rows": {
                "data_type": "json",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "request": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "request_transaction_funding_source": {
        "endpoint": "request_transaction_funding_source",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # double fields (monetary amounts)
            "amount": {"data_type": "double", "field_type": "column"},
            "amount_fx_2": {"data_type": "double", "field_type": "column"},
            "amount_local": {"data_type": "double", "field_type": "column"},
            "fx_rate1": {"data_type": "double", "field_type": "column"},
            "fx_rate2": {"data_type": "double", "field_type": "column"},
            "fx_spotrate_1": {"data_type": "double", "field_type": "column"},
            "fx_spotrate_2": {"data_type": "double", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Date fields
            "fx_applied_date_1": {"data_type": "date", "field_type": "column"},
            "fx_applied_date_2": {"data_type": "date", "field_type": "column"},
            "fx_date_1": {"data_type": "date", "field_type": "column"},
            "fx_date_2": {"data_type": "date", "field_type": "column"},
            # Integer fields
            "alert_ids_sent": {"data_type": "bigint", "field_type": "integer"},
            "created_by_id": {"data_type": "bigint", "field_type": "column"},
            "fx_type_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "request_funding_source_id": {
                "data_type": "bigint",
                "field_type": "column",
            },
            "request_transaction_id": {"data_type": "bigint", "field_type": "column"},
            "updated_by_id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "relationship_models": {"data_type": "text", "field_type": "text"},
            # Relation fields - Arrays/JSON
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "etl_request_transaction_budgets": {
                "data_type": "json",
                "field_type": "relation",
            },
            "modifications": {"data_type": "json", "field_type": "relation"},
            "request_funding_source": {"data_type": "json", "field_type": "relation"},
            "request_transaction": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
        },
    },
    "grantee_budget_tracker_period": {
        "endpoint": "grantee_budget_tracker_period",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Date/Time fields
            "end_at": {"data_type": "timestamp", "field_type": "column"},
            "start_at": {"data_type": "timestamp", "field_type": "column"},
            # Boolean fields
            "locked": {"data_type": "bool", "field_type": "column"},
            # Integer fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "order": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - IDs
            "grantee_budget_tracker_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "etl_grantee_budget_tracker_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_grantee_budget_tracker_period_data": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker_period_data": {
                "data_type": "json",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "grantee_budget_tracker_period_datum": {
        "endpoint": "grantee_budget_tracker_period_datum",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Amount/double fields
            "amended_amount": {"data_type": "double", "field_type": "column"},
            "amount_recommended": {"data_type": "double", "field_type": "column"},
            "amount_requested": {"data_type": "double", "field_type": "column"},
            "rate": {"data_type": "double", "field_type": "column"},
            "requested_amended_amount": {
                "data_type": "double",
                "field_type": "column",
            },
            "unit": {"data_type": "double", "field_type": "column"},
            # double fields
            "gbt_row_cash": {"data_type": "double", "field_type": "column"},
            "gbt_row_in_kind": {"data_type": "double", "field_type": "column"},
            "gbt_row_project_total_budget": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            # Long/Integer fields
            "gbc_position": {"data_type": "bigint", "field_type": "column"},
            "gbt_period_order": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "gbc_archived": {"data_type": "bool", "field_type": "column"},
            "gbt_period_locked": {"data_type": "bool", "field_type": "column"},
            # Date fields
            "gbt_period_end_at": {"data_type": "date", "field_type": "column"},
            "gbt_period_start_at": {"data_type": "date", "field_type": "column"},
            "request_grant_agreement_at": {"data_type": "date", "field_type": "column"},
            "request_grant_begins_at": {"data_type": "date", "field_type": "column"},
            "request_grant_ends_at": {"data_type": "date", "field_type": "column"},
            # Text fields
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "gbc_code": {"data_type": "text", "field_type": "string"},
            "gbc_description": {"data_type": "text", "field_type": "string"},
            "gbc_name": {"data_type": "text", "field_type": "string"},
            "gbc_parent_name": {"data_type": "text", "field_type": "string"},
            "gbt_row_grantee_comments": {"data_type": "text", "field_type": "string"},
            "gbt_row_name": {"data_type": "text", "field_type": "string"},
            "gbt_row_staff_feedback": {"data_type": "text", "field_type": "string"},
            "gbt_row_staff_feedback_internal": {
                "data_type": "text",
                "field_type": "string",
            },
            "initiative_name": {"data_type": "text", "field_type": "string"},
            "organization_city": {"data_type": "text", "field_type": "string"},
            "organization_geo_country_name": {
                "data_type": "text",
                "field_type": "string",
            },
            "organization_geo_state_name": {
                "data_type": "text",
                "field_type": "string",
            },
            "organization_name": {"data_type": "text", "field_type": "string"},
            "organization_postal_code": {"data_type": "text", "field_type": "string"},
            "organization_street_address": {
                "data_type": "text",
                "field_type": "string",
            },
            "organization_street_address2": {
                "data_type": "text",
                "field_type": "string",
            },
            "program_name": {"data_type": "text", "field_type": "string"},
            "request_name": {"data_type": "text", "field_type": "string"},
            "request_spending_year": {"data_type": "text", "field_type": "string"},
            "request_state": {"data_type": "text", "field_type": "string"},
            "sub_initiative_name": {"data_type": "text", "field_type": "string"},
            "sub_program_name": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - IDs
            "gbc_id": {"data_type": "bigint", "field_type": "relation"},
            "gbc_parent_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_id": {"data_type": "bigint", "field_type": "relation"},
            "grantee_budget_tracker_period_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker_row_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_grantee_budget_tracker_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_grantee_budget_tracker_period_data": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker_period": {
                "data_type": "json",
                "field_type": "relation",
            },
            "grantee_budget_tracker_period_datum_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "grantee_budget_tracker_row": {
                "data_type": "json",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "grantee_budget_tracker_period_datum_actual": {
        "endpoint": "grantee_budget_tracker_period_datum_actual",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Amount/double fields
            "actual_amount": {"data_type": "double", "field_type": "column"},
            # double fields
            "gbt_period_datum_amended_amount": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_rate": {"data_type": "double", "field_type": "column"},
            "gbt_period_datum_unit": {"data_type": "double", "field_type": "column"},
            "gbt_row_cash": {"data_type": "double", "field_type": "column"},
            "gbt_row_in_kind": {"data_type": "double", "field_type": "column"},
            "gbt_row_project_total_budget": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            # Long/Integer fields
            "gbc_position": {"data_type": "bigint", "field_type": "column"},
            "gbt_period_order": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "gbc_archived": {"data_type": "bool", "field_type": "column"},
            "gbt_period_locked": {"data_type": "bool", "field_type": "column"},
            # Date fields
            "gbt_period_end_at": {"data_type": "date", "field_type": "column"},
            "gbt_period_start_at": {"data_type": "date", "field_type": "column"},
            "request_grant_agreement_at": {"data_type": "date", "field_type": "column"},
            "request_grant_begins_at": {"data_type": "date", "field_type": "column"},
            "request_grant_ends_at": {"data_type": "date", "field_type": "column"},
            "request_report_due_at": {"data_type": "date", "field_type": "column"},
            # Text fields
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "gbc_code": {"data_type": "text", "field_type": "string"},
            "gbc_description": {"data_type": "text", "field_type": "string"},
            "gbc_name": {"data_type": "text", "field_type": "string"},
            "gbc_parent_name": {"data_type": "text", "field_type": "string"},
            "gbt_row_grantee_comments": {"data_type": "text", "field_type": "string"},
            "gbt_row_name": {"data_type": "text", "field_type": "string"},
            "gbt_row_staff_feedback": {"data_type": "text", "field_type": "string"},
            "gbt_row_staff_feedback_internal": {
                "data_type": "text",
                "field_type": "string",
            },
            "initiative_name": {"data_type": "text", "field_type": "string"},
            "organization_city": {"data_type": "text", "field_type": "string"},
            "organization_geo_country_name": {
                "data_type": "text",
                "field_type": "string",
            },
            "organization_geo_state_name": {
                "data_type": "text",
                "field_type": "string",
            },
            "organization_name": {"data_type": "text", "field_type": "string"},
            "organization_postal_code": {"data_type": "text", "field_type": "string"},
            "organization_street_address": {
                "data_type": "text",
                "field_type": "string",
            },
            "organization_street_address2": {
                "data_type": "text",
                "field_type": "string",
            },
            "program_name": {"data_type": "text", "field_type": "string"},
            "request_name": {"data_type": "text", "field_type": "string"},
            "request_report_state": {"data_type": "text", "field_type": "string"},
            "request_report_type": {"data_type": "text", "field_type": "string"},
            "request_spending_year": {"data_type": "text", "field_type": "string"},
            "request_state": {"data_type": "text", "field_type": "string"},
            "sub_initiative_name": {"data_type": "text", "field_type": "string"},
            "sub_program_name": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - IDs
            "gbc_id": {"data_type": "bigint", "field_type": "relation"},
            "gbc_parent_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_period_datum_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_period_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_row_id": {"data_type": "bigint", "field_type": "relation"},
            "grantee_budget_tracker_period_datum_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "request_report_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_grantee_budget_tracker_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker_period_datum": {
                "data_type": "json",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "request_report": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "grantee_budget_tracker_row": {
        "endpoint": "grantee_budget_tracker_row",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Amount/double fields
            "cash": {"data_type": "double", "field_type": "column"},
            "in_kind": {"data_type": "double", "field_type": "column"},
            "project_total_budget": {"data_type": "double", "field_type": "column"},
            # Integer fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "order": {"data_type": "bigint", "field_type": "column"},
            "parent_grantee_budget_tracker_row_id": {
                "data_type": "bigint",
                "field_type": "column",
            },
            # Text fields
            "grantee_comments": {"data_type": "text", "field_type": "column"},
            "group_type": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "staff_feedback": {"data_type": "text", "field_type": "column"},
            "staff_feedback_internal": {"data_type": "text", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - IDs
            "grantee_budget_category_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "claim_expense_rows": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_claim_expense_data": {"data_type": "json", "field_type": "relation"},
            "etl_grantee_budget_tracker_actuals": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_grantee_budget_tracker_period_data": {
                "data_type": "json",
                "field_type": "relation",
            },
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_category": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker": {"data_type": "json", "field_type": "relation"},
            "grantee_budget_tracker_period_data": {
                "data_type": "json",
                "field_type": "relation",
            },
            "grantee_budget_tracker_row": {
                "data_type": "json",
                "field_type": "relation",
            },
            "grantee_budget_tracker_rows": {
                "data_type": "json",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "etl_request_budget": {
        "endpoint": "etl_request_budget",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "dirty_flag": {"data_type": "bool", "field_type": "column"},
            "new_flag": {"data_type": "bool", "field_type": "column"},
            "request_granted": {"data_type": "bool", "field_type": "column"},
            "fsa_retired": {"data_type": "bool", "field_type": "column"},
            "funding_source_retired": {"data_type": "bool", "field_type": "column"},
            # double/Amount fields
            "fsa_actual_budget_amount": {
                "data_type": "double",
                "field_type": "column",
            },
            "fsa_amount": {"data_type": "double", "field_type": "column"},
            "fsa_amount_granted": {"data_type": "double", "field_type": "column"},
            "fsa_amount_paid": {"data_type": "double", "field_type": "column"},
            "fsa_amount_pipeline": {"data_type": "double", "field_type": "column"},
            "fsa_amount_unpaid": {"data_type": "double", "field_type": "column"},
            "fsa_budget_amount": {"data_type": "double", "field_type": "column"},
            "funding_source_amount": {"data_type": "double", "field_type": "column"},
            "request_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_recommended_fx_2": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_recommended_local": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested_fx_2": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested_local": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_fx_rate1": {"data_type": "double", "field_type": "column"},
            "request_fx_rate2": {"data_type": "double", "field_type": "column"},
            "request_fx_spotrate_1": {"data_type": "double", "field_type": "column"},
            "request_fx_spotrate_2": {"data_type": "double", "field_type": "column"},
            "rfs_funding_amount": {"data_type": "double", "field_type": "column"},
            # Integer fields
            "fsa_num_granted": {"data_type": "bigint", "field_type": "column"},
            "fsa_num_pipeline": {"data_type": "bigint", "field_type": "column"},
            "request_base_request_id": {"data_type": "bigint", "field_type": "column"},
            "request_contig_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "fsa_created_at": {"data_type": "timestamp", "field_type": "column"},
            "fsa_deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "fsa_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "fsa_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "fsa_sub_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "fsa_sub_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "fsa_updated_at": {"data_type": "timestamp", "field_type": "column"},
            "funding_source_created_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "funding_source_end_at": {"data_type": "timestamp", "field_type": "column"},
            "funding_source_start_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "funding_source_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "locked_at": {"data_type": "timestamp", "field_type": "column"},
            "request_deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "request_fx_date_1": {"data_type": "timestamp", "field_type": "column"},
            "request_fx_date_2": {"data_type": "timestamp", "field_type": "column"},
            "request_grant_agreement_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_grantee_user_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_program_organization_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_sub_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_sub_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_updated_at": {"data_type": "timestamp", "field_type": "column"},
            "rfs_created_at": {"data_type": "timestamp", "field_type": "column"},
            "rfs_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "rfs_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "rfs_sub_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "rfs_sub_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "rfs_updated_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Text fields
            "fsa_initiative_name": {"data_type": "text", "field_type": "column"},
            "fsa_program_name": {"data_type": "text", "field_type": "column"},
            "fsa_spending_year": {"data_type": "text", "field_type": "column"},
            "fsa_sub_initiative_name": {"data_type": "text", "field_type": "column"},
            "fsa_sub_program_name": {"data_type": "text", "field_type": "column"},
            "funding_source_name": {"data_type": "text", "field_type": "column"},
            "locked_by": {"data_type": "text", "field_type": "column"},
            "request_grantee_user_first_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "request_grantee_user_last_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "request_initiative_name": {"data_type": "text", "field_type": "column"},
            "request_program_name": {"data_type": "text", "field_type": "column"},
            "request_program_organization_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "request_spending_year": {"data_type": "text", "field_type": "column"},
            "request_state": {"data_type": "text", "field_type": "column"},
            "request_sub_initiative_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "request_sub_program_name": {"data_type": "text", "field_type": "column"},
            "rfs_initiative_name": {"data_type": "text", "field_type": "column"},
            "rfs_program_name": {"data_type": "text", "field_type": "column"},
            "rfs_sub_initiative_name": {"data_type": "text", "field_type": "column"},
            "rfs_sub_program_name": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - IDs
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fsa_id": {"data_type": "bigint", "field_type": "relation"},
            "fsa_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "fsa_program_id": {"data_type": "bigint", "field_type": "relation"},
            "fsa_sub_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "fsa_sub_program_id": {"data_type": "bigint", "field_type": "relation"},
            "funding_source_id": {"data_type": "bigint", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_fx_type_id": {"data_type": "bigint", "field_type": "relation"},
            "request_grantee_user_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "request_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "request_model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "request_program_id": {"data_type": "bigint", "field_type": "relation"},
            "request_program_organization_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_sub_initiative_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_sub_program_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_program_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_request_regrant_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_sub_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_sub_program_id": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "funding_source_allocation": {
                "data_type": "json",
                "field_type": "relation",
            },
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "request_funding_source": {"data_type": "json", "field_type": "relation"},
            "segment": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "etl_request_transaction_budget": {
        "endpoint": "etl_request_transaction_budget",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "dirty_flag": {"data_type": "bool", "field_type": "column"},
            "new_flag": {"data_type": "bool", "field_type": "column"},
            "request_granted": {"data_type": "bool", "field_type": "column"},
            "fsa_retired": {"data_type": "bool", "field_type": "column"},
            "funding_source_retired": {"data_type": "bool", "field_type": "column"},
            # double/Amount fields
            "fsa_actual_budget_amount": {
                "data_type": "double",
                "field_type": "column",
            },
            "fsa_amount": {"data_type": "double", "field_type": "column"},
            "fsa_amount_granted": {"data_type": "double", "field_type": "column"},
            "fsa_amount_paid": {"data_type": "double", "field_type": "column"},
            "fsa_amount_pipeline": {"data_type": "double", "field_type": "column"},
            "fsa_amount_unpaid": {"data_type": "double", "field_type": "column"},
            "fsa_budget_amount": {"data_type": "double", "field_type": "column"},
            "funding_source_amount": {"data_type": "double", "field_type": "column"},
            "request_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_recommended_fx_2": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_recommended_local": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested_fx_2": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested_local": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_fx_rate1": {"data_type": "double", "field_type": "column"},
            "request_fx_rate2": {"data_type": "double", "field_type": "column"},
            "request_fx_spotrate_1": {"data_type": "double", "field_type": "column"},
            "request_fx_spotrate_2": {"data_type": "double", "field_type": "column"},
            "rfs_funding_amount": {"data_type": "double", "field_type": "column"},
            "rt_amount_due": {"data_type": "double", "field_type": "column"},
            "rt_amount_due_fx_2": {"data_type": "double", "field_type": "column"},
            "rt_amount_due_local": {"data_type": "double", "field_type": "column"},
            "rt_amount_paid": {"data_type": "double", "field_type": "column"},
            "rt_amount_paid_fx_2": {"data_type": "double", "field_type": "column"},
            "rt_amount_paid_local": {"data_type": "double", "field_type": "column"},
            "rt_fx_rate1": {"data_type": "double", "field_type": "column"},
            "rt_fx_rate2": {"data_type": "double", "field_type": "column"},
            "rt_fx_spotrate_1": {"data_type": "double", "field_type": "column"},
            "rt_fx_spotrate_2": {"data_type": "double", "field_type": "column"},
            "rtfs_amount": {"data_type": "double", "field_type": "column"},
            "rtfs_amount_fx_2": {"data_type": "double", "field_type": "column"},
            "rtfs_amount_local": {"data_type": "double", "field_type": "column"},
            "rtfs_fx_rate1": {"data_type": "double", "field_type": "column"},
            "rtfs_fx_rate2": {"data_type": "double", "field_type": "column"},
            "rtfs_fx_spotrate_1": {"data_type": "double", "field_type": "column"},
            "rtfs_fx_spotrate_2": {"data_type": "double", "field_type": "column"},
            # Integer fields
            "fsa_num_granted": {"data_type": "bigint", "field_type": "column"},
            "fsa_num_pipeline": {"data_type": "bigint", "field_type": "column"},
            "request_base_request_id": {"data_type": "bigint", "field_type": "column"},
            "request_contig_id": {"data_type": "bigint", "field_type": "column"},
            "rt_contig_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "fsa_created_at": {"data_type": "timestamp", "field_type": "column"},
            "fsa_deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "fsa_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "fsa_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "fsa_sub_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "fsa_sub_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "fsa_updated_at": {"data_type": "timestamp", "field_type": "column"},
            "funding_source_created_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "funding_source_end_at": {"data_type": "timestamp", "field_type": "column"},
            "funding_source_start_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "funding_source_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "locked_at": {"data_type": "timestamp", "field_type": "column"},
            "request_deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "request_fx_date_1": {"data_type": "timestamp", "field_type": "column"},
            "request_fx_date_2": {"data_type": "timestamp", "field_type": "column"},
            "request_grant_agreement_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_grantee_user_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_program_organization_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_sub_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_sub_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_updated_at": {"data_type": "timestamp", "field_type": "column"},
            "rfs_created_at": {"data_type": "timestamp", "field_type": "column"},
            "rfs_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "rfs_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "rfs_sub_initiative_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "rfs_sub_program_updated_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "rfs_updated_at": {"data_type": "timestamp", "field_type": "column"},
            "rt_created_at": {"data_type": "timestamp", "field_type": "column"},
            "rt_deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "rt_due_at": {"data_type": "timestamp", "field_type": "column"},
            "rt_fx_date_1": {"data_type": "timestamp", "field_type": "column"},
            "rt_fx_date_2": {"data_type": "timestamp", "field_type": "column"},
            "rt_paid_at": {"data_type": "timestamp", "field_type": "column"},
            "rt_updated_at": {"data_type": "timestamp", "field_type": "column"},
            "rtfs_created_at": {"data_type": "timestamp", "field_type": "column"},
            "rtfs_fx_date_1": {"data_type": "timestamp", "field_type": "column"},
            "rtfs_fx_date_2": {"data_type": "timestamp", "field_type": "column"},
            "rtfs_updated_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Text fields
            "fsa_initiative_name": {"data_type": "text", "field_type": "column"},
            "fsa_program_name": {"data_type": "text", "field_type": "column"},
            "fsa_spending_year": {"data_type": "text", "field_type": "column"},
            "fsa_sub_initiative_name": {"data_type": "text", "field_type": "column"},
            "fsa_sub_program_name": {"data_type": "text", "field_type": "column"},
            "funding_source_name": {"data_type": "text", "field_type": "column"},
            "locked_by": {"data_type": "text", "field_type": "column"},
            "request_grantee_user_first_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "request_grantee_user_last_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "request_initiative_name": {"data_type": "text", "field_type": "column"},
            "request_program_name": {"data_type": "text", "field_type": "column"},
            "request_program_organization_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "request_spending_year": {"data_type": "text", "field_type": "column"},
            "request_state": {"data_type": "text", "field_type": "column"},
            "request_sub_initiative_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "request_sub_program_name": {"data_type": "text", "field_type": "column"},
            "rfs_initiative_name": {"data_type": "text", "field_type": "column"},
            "rfs_program_name": {"data_type": "text", "field_type": "column"},
            "rfs_sub_initiative_name": {"data_type": "text", "field_type": "column"},
            "rfs_sub_program_name": {"data_type": "text", "field_type": "column"},
            "rt_payment_confirmation_number": {
                "data_type": "text",
                "field_type": "column",
            },
            "rt_payment_type": {"data_type": "text", "field_type": "column"},
            "rt_spending_year": {"data_type": "text", "field_type": "column"},
            "rt_state": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields - IDs
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fsa_id": {"data_type": "bigint", "field_type": "relation"},
            "fsa_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "fsa_program_id": {"data_type": "bigint", "field_type": "relation"},
            "fsa_sub_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "fsa_sub_program_id": {"data_type": "bigint", "field_type": "relation"},
            "funding_source_id": {"data_type": "bigint", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_fx_type_id": {"data_type": "bigint", "field_type": "relation"},
            "request_grantee_user_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "request_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "request_model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "request_program_id": {"data_type": "bigint", "field_type": "relation"},
            "request_program_organization_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_sub_initiative_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_sub_program_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_program_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_request_regrant_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_sub_initiative_id": {"data_type": "bigint", "field_type": "relation"},
            "rfs_sub_program_id": {"data_type": "bigint", "field_type": "relation"},
            "rt_bank_account_id": {"data_type": "bigint", "field_type": "relation"},
            "rt_from_bank_account_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "rt_fx_type_id": {"data_type": "bigint", "field_type": "relation"},
            "rt_id": {"data_type": "bigint", "field_type": "relation"},
            "rt_model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "rt_payment_recorded_by_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "rt_user_payee_id": {"data_type": "bigint", "field_type": "relation"},
            "rtfs_fx_type_id": {"data_type": "bigint", "field_type": "relation"},
            "rtfs_id": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            # Relation fields - Arrays/JSON
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "funding_source_allocation": {
                "data_type": "json",
                "field_type": "relation",
            },
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "request_funding_source": {"data_type": "json", "field_type": "relation"},
            "request_transaction": {"data_type": "json", "field_type": "relation"},
            "rtfs": {"data_type": "json", "field_type": "relation"},
            "segment": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "etl_claim_expense_datum": {
        "endpoint": "etl_claim_expense_datum",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Amount fields (double for monetary values)
            "claim_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "claim_amount_requested": {"data_type": "double", "field_type": "column"},
            "claim_expense_datum_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "claim_expense_datum_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            # Timestamp fields
            "claim_approved_at": {"data_type": "timestamp", "field_type": "column"},
            "claim_due_at": {"data_type": "timestamp", "field_type": "column"},
            "claim_submitted_at": {"data_type": "timestamp", "field_type": "column"},
            "gbt_period_end_at": {"data_type": "timestamp", "field_type": "column"},
            "gbt_period_start_at": {"data_type": "timestamp", "field_type": "column"},
            # Boolean fields
            "gbc_archived": {"data_type": "bool", "field_type": "column"},
            "gbt_period_locked": {"data_type": "bool", "field_type": "column"},
            # Integer/ID fields
            "gbc_parent_id": {"data_type": "bigint", "field_type": "column"},
            "gbc_position": {"data_type": "bigint", "field_type": "column"},
            "gbt_period_order": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "claim_state": {"data_type": "text", "field_type": "column"},
            "gbc_code": {"data_type": "text", "field_type": "column"},
            "gbc_description": {"data_type": "text", "field_type": "column"},
            "gbc_name": {"data_type": "text", "field_type": "column"},
            "gbc_parent_name": {"data_type": "text", "field_type": "column"},
            "gbt_row_name": {"data_type": "text", "field_type": "column"},
            "claim_expense_additional_grantee_instructions": {
                "data_type": "text",
                "field_type": "column",
            },
            "claim_expense_row_grantee_comments": {
                "data_type": "text",
                "field_type": "column",
            },
            "claim_expense_row_staff_feedback": {
                "data_type": "text",
                "field_type": "column",
            },
            "claim_expense_row_staff_feedback_internal": {
                "data_type": "text",
                "field_type": "column",
            },
            "string": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields (stored as bigint for IDs or json for arrays)
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "claim": {"data_type": "bigint", "field_type": "relation"},
            "claim_expense": {"data_type": "bigint", "field_type": "relation"},
            "claim_expense_datum": {"data_type": "bigint", "field_type": "relation"},
            "claim_expense_datum_id": {"data_type": "bigint", "field_type": "relation"},
            "claim_expense_id": {"data_type": "bigint", "field_type": "relation"},
            "claim_expense_row": {"data_type": "bigint", "field_type": "relation"},
            "claim_expense_row_id": {"data_type": "bigint", "field_type": "relation"},
            "claim_id": {"data_type": "bigint", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "gbc_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_period_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_row_id": {"data_type": "bigint", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_category": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker": {"data_type": "bigint", "field_type": "relation"},
            "grantee_budget_tracker_period": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker_row": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "segment": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "etl_grantee_budget_tracker_actual": {
        "endpoint": "etl_grantee_budget_tracker_actual",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Amount fields (double for monetary values)
            "gbt_period_datum_actual_amount": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_amended_amount": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_rate": {"data_type": "double", "field_type": "column"},
            "gbt_row_cash": {"data_type": "double", "field_type": "column"},
            "gbt_row_in_kind": {"data_type": "double", "field_type": "column"},
            "gbt_row_project_total_budget": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_fx_rate1": {"data_type": "double", "field_type": "column"},
            "request_fx_rate2": {"data_type": "double", "field_type": "column"},
            "request_fx_spotrate_1": {"data_type": "double", "field_type": "column"},
            "request_fx_spotrate_2": {"data_type": "double", "field_type": "column"},
            # Timestamp fields
            "gbt_period_end_at": {"data_type": "timestamp", "field_type": "column"},
            "gbt_period_start_at": {"data_type": "timestamp", "field_type": "column"},
            "request_grant_agreement_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_grant_begins_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_grant_ends_at": {"data_type": "timestamp", "field_type": "column"},
            "request_report_due_at": {"data_type": "timestamp", "field_type": "column"},
            # Boolean fields
            "gbc_archived": {"data_type": "bool", "field_type": "column"},
            "gbt_period_locked": {"data_type": "bool", "field_type": "column"},
            # Integer/ID fields
            "gbc_parent_id": {"data_type": "bigint", "field_type": "column"},
            "gbc_position": {"data_type": "bigint", "field_type": "column"},
            "gbt_period_order": {"data_type": "bigint", "field_type": "column"},
            "request_spending_year": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "gbc_code": {"data_type": "text", "field_type": "column"},
            "gbc_description": {"data_type": "text", "field_type": "column"},
            "gbc_name": {"data_type": "text", "field_type": "column"},
            "gbc_parent_name": {"data_type": "text", "field_type": "column"},
            "gbt_period_datum_unit": {"data_type": "text", "field_type": "column"},
            "gbt_row_grantee_comments": {"data_type": "text", "field_type": "column"},
            "gbt_row_name": {"data_type": "text", "field_type": "column"},
            "gbt_row_staff_feedback": {"data_type": "text", "field_type": "column"},
            "gbt_row_staff_feedback_internal": {
                "data_type": "text",
                "field_type": "column",
            },
            "initiative_name": {"data_type": "text", "field_type": "column"},
            "organization_city": {"data_type": "text", "field_type": "column"},
            "organization_geo_country_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "organization_geo_state_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "organization_name": {"data_type": "text", "field_type": "column"},
            "organization_postal_code": {"data_type": "text", "field_type": "column"},
            "organization_street_address": {
                "data_type": "text",
                "field_type": "column",
            },
            "organization_street_address2": {
                "data_type": "text",
                "field_type": "column",
            },
            "program_name": {"data_type": "text", "field_type": "column"},
            "request_name": {"data_type": "text", "field_type": "column"},
            "request_report_state": {"data_type": "text", "field_type": "column"},
            "request_report_type": {"data_type": "text", "field_type": "column"},
            "request_state": {"data_type": "text", "field_type": "column"},
            "sub_initiative_name": {"data_type": "text", "field_type": "column"},
            "sub_program_name": {"data_type": "text", "field_type": "column"},
            "string": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields (stored as bigint for IDs or json for arrays)
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "gbc_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_period_datum_actual_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "gbt_period_datum_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_period_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_row_id": {"data_type": "bigint", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_category": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker": {"data_type": "bigint", "field_type": "relation"},
            "grantee_budget_tracker_period": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker_period_datum": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker_period_datum_actual": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker_row": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "request_report_id": {"data_type": "bigint", "field_type": "relation"},
            "segment": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "etl_grantee_budget_tracker_period_datum": {
        "endpoint": "etl_grantee_budget_tracker_period_datum",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Amount fields (double for monetary values)
            "gbt_period_datum_amended_amount": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            "gbt_period_datum_rate": {"data_type": "double", "field_type": "column"},
            "gbt_row_cash": {"data_type": "double", "field_type": "column"},
            "gbt_row_in_kind": {"data_type": "double", "field_type": "column"},
            "gbt_row_project_total_budget": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_recommended": {
                "data_type": "double",
                "field_type": "column",
            },
            "request_amount_requested": {
                "data_type": "double",
                "field_type": "column",
            },
            # Timestamp fields
            "gbt_period_end_at": {"data_type": "timestamp", "field_type": "column"},
            "gbt_period_start_at": {"data_type": "timestamp", "field_type": "column"},
            "request_grant_agreement_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_grant_begins_at": {
                "data_type": "timestamp",
                "field_type": "column",
            },
            "request_grant_ends_at": {"data_type": "timestamp", "field_type": "column"},
            # Boolean fields
            "gbc_archived": {"data_type": "bool", "field_type": "column"},
            "gbt_period_locked": {"data_type": "bool", "field_type": "column"},
            # Integer/ID fields
            "gbc_parent_id": {"data_type": "bigint", "field_type": "column"},
            "gbc_position": {"data_type": "bigint", "field_type": "column"},
            "gbt_period_order": {"data_type": "bigint", "field_type": "column"},
            "request_spending_year": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "gbc_code": {"data_type": "text", "field_type": "column"},
            "gbc_description": {"data_type": "text", "field_type": "column"},
            "gbc_name": {"data_type": "text", "field_type": "column"},
            "gbc_parent_name": {"data_type": "text", "field_type": "column"},
            "gbt_period_datum_unit": {"data_type": "text", "field_type": "column"},
            "gbt_row_grantee_comments": {"data_type": "text", "field_type": "column"},
            "gbt_row_name": {"data_type": "text", "field_type": "column"},
            "gbt_row_staff_feedback": {"data_type": "text", "field_type": "column"},
            "gbt_row_staff_feedback_internal": {
                "data_type": "text",
                "field_type": "column",
            },
            "initiative_name": {"data_type": "text", "field_type": "column"},
            "organization_city": {"data_type": "text", "field_type": "column"},
            "organization_geo_country_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "organization_geo_state_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "organization_name": {"data_type": "text", "field_type": "column"},
            "organization_postal_code": {"data_type": "text", "field_type": "column"},
            "organization_street_address": {
                "data_type": "text",
                "field_type": "column",
            },
            "organization_street_address2": {
                "data_type": "text",
                "field_type": "column",
            },
            "program_name": {"data_type": "text", "field_type": "column"},
            "request_name": {"data_type": "text", "field_type": "column"},
            "request_state": {"data_type": "text", "field_type": "column"},
            "sub_initiative_name": {"data_type": "text", "field_type": "column"},
            "sub_program_name": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields (stored as bigint for IDs or json for arrays)
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "gbc_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_period_datum_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_period_id": {"data_type": "bigint", "field_type": "relation"},
            "gbt_row_id": {"data_type": "bigint", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_category": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker": {"data_type": "bigint", "field_type": "relation"},
            "grantee_budget_tracker_period": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker_period_datum": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "grantee_budget_tracker_row": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "segment": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "etl_relationship": {
        "endpoint": "etl_relationship",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "archived": {"data_type": "bool", "field_type": "column"},
            "can_edit": {"data_type": "bool", "field_type": "column"},
            "hide_from_portal_user": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "archived_at": {"data_type": "timestamp", "field_type": "column"},
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "end_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "start_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Integer/ID fields
            "affiliate_type_id": {"data_type": "bigint", "field_type": "column"},
            "left_relation_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "principal_entity_id": {"data_type": "bigint", "field_type": "column"},
            "relationship_id": {"data_type": "bigint", "field_type": "column"},
            "right_relation_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "department": {"data_type": "text", "field_type": "column"},
            "description": {"data_type": "text", "field_type": "column"},
            "email": {"data_type": "text", "field_type": "column"},
            "left_relation_type": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "phone": {"data_type": "text", "field_type": "column"},
            "principal_entity_type": {"data_type": "text", "field_type": "column"},
            "relationship_migrate_source_name": {
                "data_type": "text",
                "field_type": "column",
            },
            "right_relation_type": {"data_type": "text", "field_type": "column"},
            "title": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "full_text_org": {"data_type": "text", "field_type": "string"},
            "full_text_request": {"data_type": "text", "field_type": "string"},
            "full_text_user": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields (stored as bigint for IDs or json for arrays)
            "affiliate_type": {"data_type": "bigint", "field_type": "relation"},
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "any_concept_initiative": {"data_type": "bigint", "field_type": "relation"},
            "any_granted_request": {"data_type": "bigint", "field_type": "relation"},
            "any_organization": {"data_type": "bigint", "field_type": "relation"},
            "any_project": {"data_type": "bigint", "field_type": "relation"},
            "any_request": {"data_type": "bigint", "field_type": "relation"},
            "any_request_granted": {"data_type": "bigint", "field_type": "relation"},
            "any_request_not_granted": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "any_request_regrant": {"data_type": "bigint", "field_type": "relation"},
            "any_request_report": {"data_type": "bigint", "field_type": "relation"},
            "any_request_transaction": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "any_ungranted_request": {"data_type": "bigint", "field_type": "relation"},
            "any_user": {"data_type": "bigint", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "bigint", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "left_concept_initiative": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "left_organization": {"data_type": "bigint", "field_type": "relation"},
            "left_project": {"data_type": "bigint", "field_type": "relation"},
            "left_request": {"data_type": "bigint", "field_type": "relation"},
            "left_request_regrant": {"data_type": "bigint", "field_type": "relation"},
            "left_request_report": {"data_type": "bigint", "field_type": "relation"},
            "left_request_transaction": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "left_user": {"data_type": "bigint", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "rd_tab_concept_initiatives": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request_or_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_organizations": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_regrants": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reports": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_transactions": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_users": {"data_type": "json", "field_type": "relation"},
            "right_concept_initiative": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "right_organization": {"data_type": "bigint", "field_type": "relation"},
            "right_project": {"data_type": "bigint", "field_type": "relation"},
            "right_request": {"data_type": "bigint", "field_type": "relation"},
            "right_request_regrant": {"data_type": "bigint", "field_type": "relation"},
            "right_request_report": {"data_type": "bigint", "field_type": "relation"},
            "right_request_transaction": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "right_user": {"data_type": "bigint", "field_type": "relation"},
            "segment": {"data_type": "bigint", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "bigint", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "model_attribute_value": {
        "endpoint": "model_attribute_value",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Integer/ID fields
            "created_by_id": {"data_type": "bigint", "field_type": "column"},
            "dependent_model_attribute_value_id": {
                "data_type": "bigint",
                "field_type": "column",
            },
            "display_order": {"data_type": "bigint", "field_type": "column"},
            "lft": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "model_attribute_id": {"data_type": "bigint", "field_type": "column"},
            "related_model_id": {"data_type": "bigint", "field_type": "column"},
            "rgt": {"data_type": "bigint", "field_type": "column"},
            "updated_by_id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "description": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "related_model_type": {"data_type": "text", "field_type": "column"},
            "value": {"data_type": "text", "field_type": "column"},
            # Boolean fields
            "retired": {"data_type": "bool", "field_type": "column"},
            # String fields
            "relationship_models": {"data_type": "text", "field_type": "string"},
            # Integer fields for specific attributes
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            "favorite_user_ids": {"data_type": "bigint", "field_type": "column"},
            # Relation fields
            "attribute_choices": {"data_type": "json", "field_type": "relation"},
            "children": {"data_type": "json", "field_type": "relation"},
            "children_values": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "model_attribute": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "parent": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
        },
    },
    "model_document": {
        "endpoint": "model_document",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "document_updated_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Date fields
            "doc_type_date": {"data_type": "date", "field_type": "column"},
            # Integer/ID fields
            "doc_type_year": {"data_type": "bigint", "field_type": "column"},
            "document_file_size": {"data_type": "bigint", "field_type": "column"},
            "documentable_id": {"data_type": "bigint", "field_type": "column"},
            "external_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "model_document_master_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            "seq_number": {"data_type": "bigint", "field_type": "column"},
            "user_profile_ids": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "checked_out": {"data_type": "bool", "field_type": "column"},
            "combined": {"data_type": "bool", "field_type": "column"},
            "has_dynamic_recipients": {"data_type": "bool", "field_type": "column"},
            "is_current_version": {"data_type": "bool", "field_type": "column"},
            "locked_manually": {"data_type": "bool", "field_type": "column"},
            "system_locked": {"data_type": "bool", "field_type": "column"},
            # Text fields
            "allowed_filetypes": {"data_type": "text", "field_type": "column"},
            "api_url": {"data_type": "text", "field_type": "column"},
            "checkout_token": {"data_type": "text", "field_type": "column"},
            "doc_label": {"data_type": "text", "field_type": "column"},
            "doc_type_custom": {"data_type": "text", "field_type": "column"},
            "document_content_type": {"data_type": "text", "field_type": "column"},
            "document_description": {"data_type": "text", "field_type": "column"},
            "document_file_name": {"data_type": "text", "field_type": "column"},
            "document_type": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "original_file_name": {"data_type": "text", "field_type": "column"},
            "storage_type": {"data_type": "text", "field_type": "column"},
            "upload_state": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "document_text": {"data_type": "text", "field_type": "string"},
            "documentable_state": {"data_type": "text", "field_type": "string"},
            "documentable_type": {"data_type": "text", "field_type": "string"},
            "icon_url": {"data_type": "text", "field_type": "string"},
            "s3_permission": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            "url": {"data_type": "text", "field_type": "string"},
            # Filter fields (excluding ISOC-specific ones starting with __)
            # Relation fields
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "all_dynamic_recipients": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "cc_dynamic_recipients": {"data_type": "json", "field_type": "relation"},
            "cc_dynamic_users": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "dynamic_recipients": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_id": {"data_type": "bigint", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "locked_by_id": {"data_type": "bigint", "field_type": "relation"},
            "model_document_master": {"data_type": "json", "field_type": "relation"},
            "model_document_sign_envelopes": {
                "data_type": "json",
                "field_type": "relation",
            },
            "model_document_sub_type_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "model_document_template_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "model_document_type_id": {"data_type": "bigint", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "organization_id": {"data_type": "bigint", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "project_id": {"data_type": "bigint", "field_type": "relation"},
            "rd_tab_grant_requests_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_grant_requests_request_or_grant": {
                "data_type": "json",
                "field_type": "relation",
            },
            "rd_tab_organizations": {"data_type": "json", "field_type": "relation"},
            "rd_tab_projects": {"data_type": "json", "field_type": "relation"},
            "rd_tab_request_reports": {"data_type": "json", "field_type": "relation"},
            "rd_tab_users": {"data_type": "json", "field_type": "relation"},
            "report_id": {"data_type": "bigint", "field_type": "relation"},
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "request_or_grant_id": {"data_type": "bigint", "field_type": "relation"},
            "request_report_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_report_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_transaction_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_transaction_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "segment": {"data_type": "json", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "to_dynamic_recipient": {"data_type": "json", "field_type": "relation"},
            "transaction_id": {"data_type": "bigint", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "user_id": {"data_type": "bigint", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
            "zoom_concept_initiative": {"data_type": "json", "field_type": "relation"},
        },
    },
    "model_document_sub_type": {
        "endpoint": "model_document_sub_type",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Integer/ID fields
            "value_order": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "value": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Filter fields (excluding ISOC-specific ones starting with __)
            # Relation fields
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_document_type_id": {"data_type": "bigint", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "model_document_type": {
        "endpoint": "model_document_type",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Integer/ID fields
            "docusign_signer_user_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "model_document_sub_type_id": {
                "data_type": "bigint",
                "field_type": "column",
            },
            # Boolean fields
            "display_custom_text": {"data_type": "bool", "field_type": "column"},
            "dropdown_sub_type": {"data_type": "bool", "field_type": "column"},
            "enable_document_locking": {"data_type": "bool", "field_type": "column"},
            "required": {"data_type": "bool", "field_type": "column"},
            "retired": {"data_type": "bool", "field_type": "column"},
            "upload_only_once": {"data_type": "bool", "field_type": "column"},
            # Text fields
            "abbreviation": {"data_type": "text", "field_type": "column"},
            "docusign_body": {"data_type": "text", "field_type": "column"},
            "docusign_cc_recipients": {"data_type": "text", "field_type": "column"},
            "docusign_signatures": {"data_type": "text", "field_type": "column"},
            "docusign_signer_email": {"data_type": "text", "field_type": "column"},
            "docusign_signer_model_relationship": {
                "data_type": "text",
                "field_type": "column",
            },
            "docusign_subject": {"data_type": "text", "field_type": "column"},
            "locked_states": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "model_type": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "permission_name": {"data_type": "text", "field_type": "column"},
            "required_state": {"data_type": "text", "field_type": "column"},
            "sub_type_config": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "doc_label": {"data_type": "text", "field_type": "string"},
            "required_proc": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Filter fields (excluding ISOC-specific ones starting with __)
            # Relation fields
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "docusign_signer_user": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_document_sub_types": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "json", "field_type": "relation"},
            "model_theme_id": {"data_type": "bigint", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "model_theme": {
        "endpoint": "model_theme",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Date fields
            "disable_date": {"data_type": "date", "field_type": "column"},
            "enable_date": {"data_type": "date", "field_type": "column"},
            "retired_at": {"data_type": "date", "field_type": "column"},
            # Integer/ID fields
            "created_by_id": {"data_type": "bigint", "field_type": "column"},
            "default_segment_tag_id": {"data_type": "bigint", "field_type": "column"},
            "initiative_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "parent_model_theme_id": {"data_type": "bigint", "field_type": "column"},
            "program_id": {"data_type": "bigint", "field_type": "column"},
            "related_model_theme_id": {"data_type": "bigint", "field_type": "column"},
            "sub_initiative_id": {"data_type": "bigint", "field_type": "column"},
            "sub_program_id": {"data_type": "bigint", "field_type": "column"},
            "updated_by_id": {"data_type": "bigint", "field_type": "column"},
            "user_profile_ids": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "external_access_enabled": {"data_type": "bool", "field_type": "column"},
            "has_custom_ruby_code": {"data_type": "bool", "field_type": "column"},
            "hide_from_theme_switching": {"data_type": "bool", "field_type": "column"},
            "include_default_program_in_loi_header": {
                "data_type": "bool",
                "field_type": "column",
            },
            "limit_by_user_profile_flag": {"data_type": "bool", "field_type": "column"},
            "request_may_be_grantee_user_only": {
                "data_type": "bool",
                "field_type": "column",
            },
            # Text fields
            "after_create_block": {"data_type": "text", "field_type": "column"},
            "after_create_block_migration_confirmed": {
                "data_type": "text",
                "field_type": "column",
            },
            "after_create_block_migration_status": {
                "data_type": "text",
                "field_type": "column",
            },
            "categories": {"data_type": "text", "field_type": "column"},
            "disabled_text": {"data_type": "text", "field_type": "column"},
            "draft_after_create_block": {"data_type": "text", "field_type": "column"},
            "draft_after_create_block_submit": {
                "data_type": "text",
                "field_type": "column",
            },
            "draft_before_new_block": {"data_type": "text", "field_type": "column"},
            "draft_before_new_block_submit": {
                "data_type": "text",
                "field_type": "column",
            },
            "external_uri": {"data_type": "text", "field_type": "column"},
            "label": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "model_type": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "unsafe_after_create_block": {"data_type": "text", "field_type": "column"},
            "unsafe_before_new_block": {"data_type": "text", "field_type": "column"},
            # String fields
            "before_new_block": {"data_type": "text", "field_type": "string"},
            "before_new_block_migration_confirmed": {
                "data_type": "text",
                "field_type": "column",
            },
            "before_new_block_migration_status": {
                "data_type": "text",
                "field_type": "column",
            },
            "relationship_models": {"data_type": "text", "field_type": "string"},
            # Integer fields for specific attributes
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            "favorite_user_ids": {"data_type": "bigint", "field_type": "column"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "forms": {"data_type": "json", "field_type": "relation"},
            "initiative": {"data_type": "json", "field_type": "relation"},
            "machine_workflows": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "parent_model_theme": {"data_type": "json", "field_type": "relation"},
            "program": {"data_type": "json", "field_type": "relation"},
            "stencils": {"data_type": "json", "field_type": "relation"},
            "sub_initiative": {"data_type": "json", "field_type": "relation"},
            "sub_program": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
        },
    },
    "dashboard_theme": {
        "endpoint": "dashboard_theme",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Boolean fields
            "require_template": {"data_type": "bool", "field_type": "column"},
            # Text fields
            "data": {"data_type": "text", "field_type": "column"},
            "label": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            # String fields
            "relationship_models": {"data_type": "text", "field_type": "string"},
            # Integer fields for specific attributes
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
        },
    },
    "user_organization": {
        "endpoint": "user_organization",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "archived": {"data_type": "bool", "field_type": "column"},
            "can_edit": {"data_type": "bool", "field_type": "column"},
            "hide_from_portal_user": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "start_at": {"data_type": "timestamp", "field_type": "column"},
            "end_at": {"data_type": "timestamp", "field_type": "column"},
            # Text fields
            "department": {"data_type": "text", "field_type": "column"},
            "email": {"data_type": "text", "field_type": "column"},
            "phone": {"data_type": "text", "field_type": "column"},
            "title": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            # Integer/ID fields
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "organization_id": {"data_type": "bigint", "field_type": "column"},
            "user_id": {"data_type": "bigint", "field_type": "column"},
            "principal_entity_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "principal_entity_type": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "affiliate_type_list": {"data_type": "json", "field_type": "relation"},
            "affiliate_types": {"data_type": "json", "field_type": "relation"},
            "affiliates": {"data_type": "json", "field_type": "relation"},
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "organization": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "primary_user_organizations_orgs": {
                "data_type": "json",
                "field_type": "relation",
            },
            "primary_user_organizations_users": {
                "data_type": "json",
                "field_type": "relation",
            },
            "segment": {"data_type": "json", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "tenures": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "user": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "request_user": {
        "endpoint": "request_user",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "archived": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Text fields
            "description": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            # Integer/ID fields
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "principal_entity_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "grant_request_workflow_state": {
                "data_type": "text",
                "field_type": "string",
            },
            "principal_entity_type": {"data_type": "text", "field_type": "string"},
            "request_base_request_id": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            "user_first_name": {"data_type": "text", "field_type": "string"},
            "user_last_name": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "affiliate_type_list": {"data_type": "json", "field_type": "relation"},
            "affiliate_types": {"data_type": "json", "field_type": "relation"},
            "affiliates": {"data_type": "json", "field_type": "relation"},
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "created_by_id": {"data_type": "bigint", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "fiscal_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "fiscal_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "grant_request_model_theme_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "program_org_geo_country_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "program_org_geo_state_id": {
                "data_type": "bigint",
                "field_type": "relation",
            },
            "request_id": {"data_type": "bigint", "field_type": "relation"},
            "segment": {"data_type": "json", "field_type": "relation"},
            "segment_tag_id": {"data_type": "bigint", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
            "updated_by_id": {"data_type": "bigint", "field_type": "relation"},
            "user_id": {"data_type": "bigint", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "exempt_organization": {
        "endpoint": "exempt_organization",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Amount/double fields
            "asset_amount": {"data_type": "double", "field_type": "column"},
            "income_amount": {"data_type": "double", "field_type": "column"},
            "revenue_amount": {"data_type": "double", "field_type": "column"},
            # Date fields
            "ruling_date": {"data_type": "date", "field_type": "column"},
            "tax_period": {"data_type": "date", "field_type": "column"},
            "timestamp_entered_state": {"data_type": "date", "field_type": "date"},
            # Text fields
            "accounting_period": {"data_type": "text", "field_type": "column"},
            "activity1": {"data_type": "text", "field_type": "column"},
            "activity2": {"data_type": "text", "field_type": "column"},
            "activity3": {"data_type": "text", "field_type": "column"},
            "address": {"data_type": "text", "field_type": "column"},
            "affiliation": {"data_type": "text", "field_type": "column"},
            "asset_group": {"data_type": "text", "field_type": "column"},
            "care_of_name": {"data_type": "text", "field_type": "column"},
            "city": {"data_type": "text", "field_type": "column"},
            "classification": {"data_type": "text", "field_type": "column"},
            "contributions_allowable": {"data_type": "text", "field_type": "column"},
            "contributions_allowable_notes": {
                "data_type": "text",
                "field_type": "column",
            },
            "deductibility": {"data_type": "text", "field_type": "column"},
            "ein": {"data_type": "text", "field_type": "column"},
            "exempt_organization_status": {"data_type": "text", "field_type": "column"},
            "filing_requirement": {"data_type": "text", "field_type": "column"},
            "foundation_code": {"data_type": "text", "field_type": "column"},
            "foundation_full_text": {"data_type": "text", "field_type": "column"},
            "group_exemption": {"data_type": "text", "field_type": "column"},
            "income_group": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "ntee": {"data_type": "text", "field_type": "column"},
            "organization_type": {"data_type": "text", "field_type": "column"},
            "pf_filing_requirement": {"data_type": "text", "field_type": "column"},
            "sort_name": {"data_type": "text", "field_type": "column"},
            "state": {"data_type": "text", "field_type": "column"},
            "subsection": {"data_type": "text", "field_type": "column"},
            "tax_status": {"data_type": "text", "field_type": "column"},
            "zip": {"data_type": "text", "field_type": "column"},
            # Integer fields
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            # String fields
            "previous_state": {"data_type": "text", "field_type": "string"},
            "state_description": {"data_type": "text", "field_type": "string"},
            "relationship_models": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
        },
    },
    "concept_initiative": {
        "endpoint": "concept_initiative",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Boolean fields
            "is_temp_precreate": {"data_type": "bool", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Date fields
            "timestamp_entered_state": {"data_type": "date", "field_type": "column"},
            # Integer/ID fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "initiative_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "program_id": {"data_type": "bigint", "field_type": "column"},
            "segment_id": {"data_type": "bigint", "field_type": "column"},
            "sub_initiative_id": {"data_type": "bigint", "field_type": "column"},
            "sub_program_id": {"data_type": "bigint", "field_type": "column"},
            # double fields
            "total_amount": {"data_type": "double", "field_type": "column"},
            # Text fields
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "state": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "previous_state": {"data_type": "text", "field_type": "string"},
            "request_hierarchy": {"data_type": "text", "field_type": "string"},
            "state_description": {"data_type": "text", "field_type": "string"},
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "any_etl_relationship_ids": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "created_by_id": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "initiative": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "json", "field_type": "relation"},
            "model_theme_id": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "posts": {"data_type": "json", "field_type": "relation"},
            "program": {"data_type": "json", "field_type": "relation"},
            "rd_tab_etl_relationships": {"data_type": "json", "field_type": "relation"},
            "rd_tab_initiatives": {"data_type": "json", "field_type": "relation"},
            "rd_tab_programs": {"data_type": "json", "field_type": "relation"},
            "rd_tab_sub_initiatives": {"data_type": "json", "field_type": "relation"},
            "rd_tab_sub_programs_sub_program": {
                "data_type": "json",
                "field_type": "relation",
            },
            "relationships": {"data_type": "json", "field_type": "relation"},
            "segment": {"data_type": "json", "field_type": "relation"},
            "segment_tag_id": {"data_type": "json", "field_type": "relation"},
            "sub_initiative": {"data_type": "json", "field_type": "relation"},
            "sub_program": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
            "updated_by_id": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
            "zoom_all_grant_request": {"data_type": "json", "field_type": "relation"},
            "zoom_grant_request": {"data_type": "json", "field_type": "relation"},
            "zoom_granted_request": {"data_type": "json", "field_type": "relation"},
            "zoom_model_document": {"data_type": "json", "field_type": "relation"},
            "zoom_organization": {"data_type": "json", "field_type": "relation"},
            "zoom_request_report": {"data_type": "json", "field_type": "relation"},
            "zoom_request_transaction": {"data_type": "json", "field_type": "relation"},
            "zoom_user": {"data_type": "json", "field_type": "relation"},
        },
    },
    "integration_log": {
        "endpoint": "integration_log",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Integer/ID fields
            "fluxx_entity_id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "entity_type": {"data_type": "text", "field_type": "column"},
            "exception_detail": {"data_type": "text", "field_type": "column"},
            "integration": {"data_type": "text", "field_type": "column"},
            "level": {"data_type": "text", "field_type": "column"},
            "message": {"data_type": "text", "field_type": "column"},
            "retry_json": {"data_type": "text", "field_type": "column"},
            # String fields
            "all_notes": {"data_type": "text", "field_type": "string"},
            "fluxx_entity_id_str": {"data_type": "text", "field_type": "string"},
            "fluxx_id_str": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "alert_ids_sent": {"data_type": "json", "field_type": "relation"},
            "audit_soft_deletes": {"data_type": "json", "field_type": "relation"},
            "clone_ancestries": {"data_type": "json", "field_type": "relation"},
            "code_block_conversions": {"data_type": "json", "field_type": "relation"},
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "etl_relationships": {"data_type": "json", "field_type": "relation"},
            "favorite_user_ids": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "geo_place_relationships": {"data_type": "json", "field_type": "relation"},
            "group_members": {"data_type": "json", "field_type": "relation"},
            "model_documents": {"data_type": "json", "field_type": "relation"},
            "model_emails": {"data_type": "json", "field_type": "relation"},
            "model_summaries": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
            "post_relationships": {"data_type": "json", "field_type": "relation"},
            "taggings": {"data_type": "json", "field_type": "relation"},
            "translator_assignments": {"data_type": "json", "field_type": "relation"},
            "work_tasks": {"data_type": "json", "field_type": "relation"},
            "workflow_events": {"data_type": "json", "field_type": "relation"},
        },
    },
    "machine_category": {
        "endpoint": "machine_category",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Integer/ID fields
            "created_by_id": {"data_type": "bigint", "field_type": "column"},
            "updated_by_id": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "description": {"data_type": "text", "field_type": "column"},
            "name": {"data_type": "text", "field_type": "column"},
            "workflowable_type": {"data_type": "text", "field_type": "column"},
            # Integer fields
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            # String fields
            "relationship_models": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "machine_state_categories": {"data_type": "json", "field_type": "relation"},
            "machine_states": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "updated_by": {"data_type": "json", "field_type": "relation"},
        },
    },
    "population_estimate": {
        "endpoint": "population_estimate",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Integer fields
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            "total_population": {"data_type": "bigint", "field_type": "column"},
            # double fields (for lat/lng coordinates)
            "latitude": {"data_type": "double", "field_type": "column"},
            "longitude": {"data_type": "double", "field_type": "column"},
            # Text fields
            "cbsa_division_code": {"data_type": "text", "field_type": "column"},
            "cbsa_division_title": {"data_type": "text", "field_type": "column"},
            "cbsa_title": {"data_type": "text", "field_type": "column"},
            "central_outlying_county": {"data_type": "text", "field_type": "column"},
            "county": {"data_type": "text", "field_type": "column"},
            "csa_title": {"data_type": "text", "field_type": "column"},
            "fips_county_code": {"data_type": "text", "field_type": "column"},
            "fips_state_code": {"data_type": "text", "field_type": "column"},
            "geo_state": {"data_type": "text", "field_type": "column"},
            # String fields
            "relationship_models": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "population_estimate_years": {
                "data_type": "json",
                "field_type": "relation",
            },
        },
    },
    "population_estimate_year": {
        "endpoint": "population_estimate_year",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Integer/ID fields
            "population_estimate_id": {"data_type": "bigint", "field_type": "column"},
            # Integer fields
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            "spending_year": {"data_type": "bigint", "field_type": "column"},
            "total_population": {"data_type": "bigint", "field_type": "column"},
            # double fields
            "low_medium_income": {"data_type": "double", "field_type": "column"},
            "median_household_income": {"data_type": "double", "field_type": "column"},
            # Text fields
            "core_based_statistical_area_code": {
                "data_type": "text",
                "field_type": "column",
            },
            # String fields
            "relationship_models": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "population_estimate": {"data_type": "json", "field_type": "relation"},
        },
    },
    "ui_version": {
        "endpoint": "ui_version",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            # Text fields
            "description": {"data_type": "text", "field_type": "column"},
            # Integer fields
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            # String fields
            "relationship_models": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
        },
    },
    "mac_model_type_dyn_financial_audit": {
        "endpoint": "mac_model_type_dyn_financial_audit",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            # Boolean fields
            "is_temp_precreate": {"data_type": "bool", "field_type": "column"},
            "submitted": {"data_type": "bool", "field_type": "column"},
            "approved": {"data_type": "bool", "field_type": "column"},
            # Integer/ID fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "model_theme_id": {"data_type": "bigint", "field_type": "column"},
            "created_by_id": {"data_type": "bigint", "field_type": "column"},
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            # double fields (for financial amounts)
            "amount_requested": {"data_type": "double", "field_type": "column"},
            "amount_recommended": {"data_type": "double", "field_type": "column"},
            "audit_amount": {"data_type": "double", "field_type": "column"},
            "financial_variance": {"data_type": "double", "field_type": "column"},
            # Text fields
            "state": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "audit_type": {"data_type": "text", "field_type": "column"},
            "audit_status": {"data_type": "text", "field_type": "column"},
            "financial_category": {"data_type": "text", "field_type": "column"},
            "compliance_status": {"data_type": "text", "field_type": "column"},
            # String fields
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            "relationship_models": {"data_type": "text", "field_type": "string"},
            "audit_notes": {"data_type": "text", "field_type": "string"},
            "findings_summary": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "bigint", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "audit_documents": {"data_type": "json", "field_type": "relation"},
            "financial_records": {"data_type": "json", "field_type": "relation"},
            "compliance_items": {"data_type": "json", "field_type": "relation"},
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
        },
    },
    "mac_model_type_dyn_mel": {
        "endpoint": "mac_model_type_dyn_mel",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "evaluation_date": {"data_type": "timestamp", "field_type": "column"},
            "baseline_date": {"data_type": "timestamp", "field_type": "column"},
            # Boolean fields
            "is_temp_precreate": {"data_type": "bool", "field_type": "column"},
            "submitted": {"data_type": "bool", "field_type": "column"},
            "approved": {"data_type": "bool", "field_type": "column"},
            "baseline_established": {"data_type": "bool", "field_type": "column"},
            "evaluation_complete": {"data_type": "bool", "field_type": "column"},
            # Integer/ID fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "model_theme_id": {"data_type": "bigint", "field_type": "column"},
            "created_by_id": {"data_type": "bigint", "field_type": "column"},
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            "evaluation_cycle": {"data_type": "bigint", "field_type": "column"},
            # double fields (for MEL metrics and scores)
            "baseline_value": {"data_type": "double", "field_type": "column"},
            "target_value": {"data_type": "double", "field_type": "column"},
            "actual_value": {"data_type": "double", "field_type": "column"},
            "achievement_percentage": {"data_type": "double", "field_type": "column"},
            "variance_from_target": {"data_type": "double", "field_type": "column"},
            "performance_score": {"data_type": "double", "field_type": "column"},
            # Text fields
            "state": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "indicator_type": {"data_type": "text", "field_type": "column"},
            "measurement_unit": {"data_type": "text", "field_type": "column"},
            "evaluation_status": {"data_type": "text", "field_type": "column"},
            "data_source": {"data_type": "text", "field_type": "column"},
            "collection_method": {"data_type": "text", "field_type": "column"},
            "reporting_frequency": {"data_type": "text", "field_type": "column"},
            # String fields
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            "relationship_models": {"data_type": "text", "field_type": "string"},
            "indicator_description": {"data_type": "text", "field_type": "string"},
            "evaluation_methodology": {"data_type": "text", "field_type": "string"},
            "findings_summary": {"data_type": "text", "field_type": "string"},
            "recommendations": {"data_type": "text", "field_type": "string"},
            "lessons_learned": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "bigint", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "evaluation_documents": {"data_type": "json", "field_type": "relation"},
            "data_collection_tools": {"data_type": "json", "field_type": "relation"},
            "performance_indicators": {"data_type": "json", "field_type": "relation"},
            "evaluation_reports": {"data_type": "json", "field_type": "relation"},
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
        },
    },
    "mac_model_type_dyn_tool": {
        "endpoint": "mac_model_type_dyn_tool",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "deployment_date": {"data_type": "timestamp", "field_type": "column"},
            "last_used_at": {"data_type": "timestamp", "field_type": "column"},
            # Boolean fields
            "is_temp_precreate": {"data_type": "bool", "field_type": "column"},
            "submitted": {"data_type": "bool", "field_type": "column"},
            "approved": {"data_type": "bool", "field_type": "column"},
            "is_active": {"data_type": "bool", "field_type": "column"},
            "is_deployed": {"data_type": "bool", "field_type": "column"},
            "requires_training": {"data_type": "bool", "field_type": "column"},
            # Integer/ID fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "model_theme_id": {"data_type": "bigint", "field_type": "column"},
            "created_by_id": {"data_type": "bigint", "field_type": "column"},
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            "version_number": {"data_type": "bigint", "field_type": "column"},
            "usage_count": {"data_type": "bigint", "field_type": "column"},
            # double fields (for tool metrics)
            "effectiveness_score": {"data_type": "double", "field_type": "column"},
            "user_satisfaction_rating": {
                "data_type": "double",
                "field_type": "column",
            },
            "implementation_cost": {"data_type": "double", "field_type": "column"},
            "maintenance_cost": {"data_type": "double", "field_type": "column"},
            "roi_percentage": {"data_type": "double", "field_type": "column"},
            # Text fields
            "state": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "tool_name": {"data_type": "text", "field_type": "column"},
            "tool_type": {"data_type": "text", "field_type": "column"},
            "tool_category": {"data_type": "text", "field_type": "column"},
            "deployment_status": {"data_type": "text", "field_type": "column"},
            "vendor_name": {"data_type": "text", "field_type": "column"},
            "license_type": {"data_type": "text", "field_type": "column"},
            "platform": {"data_type": "text", "field_type": "column"},
            # String fields
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            "relationship_models": {"data_type": "text", "field_type": "string"},
            "tool_description": {"data_type": "text", "field_type": "string"},
            "use_case": {"data_type": "text", "field_type": "string"},
            "implementation_notes": {"data_type": "text", "field_type": "string"},
            "user_feedback": {"data_type": "text", "field_type": "string"},
            "technical_requirements": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "bigint", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "tool_documents": {"data_type": "json", "field_type": "relation"},
            "training_materials": {"data_type": "json", "field_type": "relation"},
            "user_access_permissions": {"data_type": "json", "field_type": "relation"},
            "integration_endpoints": {"data_type": "json", "field_type": "relation"},
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
        },
    },
    "salesforce_authentication": {
        "endpoint": "salesforce_authentication",
        "fields": {
            # Primary key
            "id": {"data_type": "bigint", "field_type": "column"},
            # Timestamp fields
            "created_at": {"data_type": "timestamp", "field_type": "column"},
            "updated_at": {"data_type": "timestamp", "field_type": "column"},
            "deleted_at": {"data_type": "timestamp", "field_type": "column"},
            "locked_until": {"data_type": "timestamp", "field_type": "column"},
            "last_authenticated_at": {"data_type": "timestamp", "field_type": "column"},
            "token_expires_at": {"data_type": "timestamp", "field_type": "column"},
            "last_refresh_at": {"data_type": "timestamp", "field_type": "column"},
            # Boolean fields
            "is_temp_precreate": {"data_type": "bool", "field_type": "column"},
            "submitted": {"data_type": "bool", "field_type": "column"},
            "approved": {"data_type": "bool", "field_type": "column"},
            "is_active": {"data_type": "bool", "field_type": "column"},
            "auto_refresh_enabled": {"data_type": "bool", "field_type": "column"},
            "is_sandbox": {"data_type": "bool", "field_type": "column"},
            # Integer/ID fields
            "contig_id": {"data_type": "bigint", "field_type": "column"},
            "locked_by_id": {"data_type": "bigint", "field_type": "column"},
            "migrate_id": {"data_type": "bigint", "field_type": "column"},
            "model_theme_id": {"data_type": "bigint", "field_type": "column"},
            "created_by_id": {"data_type": "bigint", "field_type": "column"},
            "alert_ids_sent": {"data_type": "bigint", "field_type": "column"},
            "refresh_count": {"data_type": "bigint", "field_type": "column"},
            # Text fields
            "state": {"data_type": "text", "field_type": "column"},
            "migrate_source_name": {"data_type": "text", "field_type": "column"},
            "client_id": {"data_type": "text", "field_type": "column"},
            "instance_url": {"data_type": "text", "field_type": "column"},
            "auth_type": {"data_type": "text", "field_type": "column"},
            "auth_status": {"data_type": "text", "field_type": "column"},
            "environment_type": {"data_type": "text", "field_type": "column"},
            "organization_id": {"data_type": "text", "field_type": "column"},
            "user_id": {"data_type": "text", "field_type": "column"},
            "username": {"data_type": "text", "field_type": "column"},
            # String fields (sensitive data handled as text)
            "state_to_english": {"data_type": "text", "field_type": "string"},
            "filter_state": {"data_type": "text", "field_type": "string"},
            "to_s": {"data_type": "text", "field_type": "string"},
            "relationship_models": {"data_type": "text", "field_type": "string"},
            "access_token_hash": {"data_type": "text", "field_type": "string"},
            "refresh_token_hash": {"data_type": "text", "field_type": "string"},
            "scope": {"data_type": "text", "field_type": "string"},
            "connection_name": {"data_type": "text", "field_type": "string"},
            "error_message": {"data_type": "text", "field_type": "string"},
            # Relation fields
            "connection_ids": {"data_type": "json", "field_type": "relation"},
            "modifications": {"data_type": "json", "field_type": "relation"},
            "model_theme": {"data_type": "bigint", "field_type": "relation"},
            "created_by": {"data_type": "json", "field_type": "relation"},
            "auth_logs": {"data_type": "json", "field_type": "relation"},
            "api_usage_metrics": {"data_type": "json", "field_type": "relation"},
            "connected_apps": {"data_type": "json", "field_type": "relation"},
            "permission_sets": {"data_type": "json", "field_type": "relation"},
            "alert_emails": {"data_type": "json", "field_type": "relation"},
            "favorites": {"data_type": "json", "field_type": "relation"},
            "notes": {"data_type": "json", "field_type": "relation"},
        },
    },
}


@dlt.source(name="fluxx", max_table_nesting=0)
def fluxx_source(
    instance: str = dlt.config.value,
    client_id: str = dlt.secrets.value,
    client_secret: str = dlt.secrets.value,
    start_date: Optional[pendulum.DateTime] = None,
    end_date: Optional[pendulum.DateTime] = None,
    resources: Optional[list] = None,
    custom_fields: Optional[dict] = None,
) -> Iterable[DltResource]:
    """
    Returns a list of resources to load data from Fluxx Grant Management API.

    Args:
        instance: The Fluxx instance subdomain (e.g., "mycompany.preprod")
        client_id: OAuth client ID
        client_secret: OAuth client secret
        resources: List of resource names to load (defaults to all available)
        custom_fields: Dictionary mapping resource names to custom field lists

    Returns:
        Iterable[DltResource]: Selected Fluxx resources
    """

    # Get OAuth access token
    access_token = get_access_token(instance, client_id, client_secret)

    # If no resources specified, load all available
    if resources is None:
        resources = list(FLUXX_RESOURCES.keys())

    if custom_fields is None:
        custom_fields = {}

    # Create dynamic resources based on configuration
    resource_list = []
    for resource_name in resources:
        if resource_name not in FLUXX_RESOURCES:
            continue

        config = FLUXX_RESOURCES[resource_name]

        # Filter fields if custom field selection is specified
        fields_to_extract: Dict[str, Any] = config["fields"]  # type: ignore
        if resource_name in custom_fields:
            custom_field_names = custom_fields[resource_name]
            # Always include 'id' field for primary key
            if "id" not in custom_field_names:
                custom_field_names = ["id"] + custom_field_names

            # Filter the fields_to_extract to only include selected fields
            filtered_fields: Dict[str, Any] = {}
            for field_name in custom_field_names:
                if field_name in fields_to_extract:
                    filtered_fields[field_name] = fields_to_extract[field_name]
                else:
                    # If field is not in the resource configuration, log a warning but continue
                    print(
                        f"Warning: Field '{field_name}' not found in {resource_name} configuration"
                    )

            fields_to_extract = filtered_fields

        resource = create_dynamic_resource(
            resource_name=resource_name,
            endpoint=config["endpoint"],  # type: ignore
            instance=instance,
            access_token=access_token,
            start_date=start_date,
            end_date=end_date,
            fields_to_extract=fields_to_extract,
        )
        resource_list.append(resource)

    return resource_list
