import { Construct } from 'constructs';
export interface MediaPipelineInsightsTag {
    readonly key: string;
    readonly value: string;
}
export declare enum RulesType {
    KEYWORD_MATCH = "KeywordMatch",
    SENTIMENT = "Sentiment",
    ISSUE_DETECTION = "IssueDetection"
}
export interface Rules {
    readonly type: RulesType;
    readonly keywordMatchConfiguration?: KeywordMatchConfiguration;
    readonly sentimentConfiguration?: SentimentConfiguration;
    readonly issueDetectionConfiguration?: IssueDetectionConfiguration;
}
export declare enum SentimentType {
    NEGATIVE = "NEGATIVE"
}
export interface KeywordMatchConfiguration {
    readonly ruleName: string;
    readonly keywords: string[];
    readonly negate?: boolean;
}
export interface SentimentConfiguration {
    readonly ruleName: string;
    readonly sentimentType: SentimentType;
    readonly timePeriod: number;
}
export interface IssueDetectionConfiguration {
    readonly ruleName: string;
}
export declare enum ElementsType {
    AMAZON_TRANSCRIPT_CALL_ANALYTICS_PROCESS = "AmazonTranscribeCallAnalyticsProcessor",
    VOICE_ANALYTICS_PROCESSOR = "VoiceAnalyticsProcessor",
    AMAZON_TRANSCRIBE_PROCESSOR = "AmazonTranscribeProcessor",
    KINESIS_DATA_STREAM_SINK = "KinesisDataStreamSink",
    LAMBDA_FUNCTION_SINK = "LambdaFunctionSink",
    SQS_QUEUE_SINK = "SqsQueueSink",
    SNS_TOPICS_SINK = "SnsTopicSink",
    S3_RECORDING_SINK = "S3RecordingSink"
}
export declare enum LanguageCode {
    EN_US = "en-US",
    EN_GB = "en-GB",
    ES_US = "es-US",
    FR_CA = "fr-CA",
    FR_FR = "fr-FR",
    EN_AU = "en-AU",
    IT_IT = "it-IT",
    DE_DE = "de-DE",
    PT_BR = "pt-BR"
}
export declare enum VocabularyFilterMethod {
    REMOVE = "remove",
    MASK = "mask",
    TAG = "tag"
}
export declare enum PartialResultsStability {
    HIGH = "high",
    MEDIUM = "medium",
    LOW = "low"
}
export declare enum ContentIdentificationType {
    PII = "PII"
}
export declare enum ContentRedactionType {
    PII = "PII"
}
export declare enum ContentRedactionOutput {
    REDACTED = "redacted",
    REDACTED_AND_UNREDACTED = "redacted_and_unredacted"
}
export interface PostCallAnalyticsSettings {
    readonly outputLocation: string;
    readonly dataAccessRoleArn: string;
    readonly contentRedactionOutput?: ContentRedactionOutput;
    readonly outputEncryptionKMSKeyId?: string;
}
export interface AmazonTranscribeCallAnalyticsProcessorConfiguration {
    readonly languageCode: LanguageCode;
    readonly vocabularyName?: string;
    readonly vocabularyFilterName?: string;
    readonly vocabularyFilterMethod?: VocabularyFilterMethod;
    readonly languageModelName?: string;
    readonly enablePartialResultsStabilization?: boolean;
    readonly partialResultsStability?: PartialResultsStability;
    readonly contentIdentificationType?: ContentIdentificationType;
    readonly contentRedactionType?: ContentRedactionType;
    readonly piiEntityTypes?: string;
    readonly filterPartialResults?: boolean;
    readonly postCallAnalyticsSettings?: PostCallAnalyticsSettings;
    readonly callAnalyticsStreamCategories?: string[];
}
export interface AmazonTranscribeProcessorConfiguration {
    readonly languageCode: LanguageCode;
    readonly vocabularyName?: string;
    readonly vocabularyFilterName?: string;
    readonly vocabularyFilterMethod?: VocabularyFilterMethod;
    readonly showSpeakerLabel?: boolean;
    readonly enablePartialResultsStabilization?: boolean;
    readonly partialResultsStability?: PartialResultsStability;
    readonly contentIdentificationType?: ContentIdentificationType;
    readonly contentRedactionType?: ContentRedactionType;
    readonly piiEntityTypes?: string;
    readonly languageModelName?: string;
    readonly filterPartialResults?: boolean;
}
export interface KinesisDataStreamSinkConfiguration {
    readonly insightsTarget: string;
}
export interface S3RecordingSinkConfiguration {
    readonly destination: string;
}
export declare enum SpeakerSearchStatus {
    ENABLED = "Enabled",
    DISABLED = "Disabled"
}
export declare enum VoiceToneAnalysisStatus {
    ENABLED = "Enabled",
    DISABLED = "Disabled"
}
export interface VoiceAnalyticsProcessorConfiguration {
    readonly speakerSearchStatus: SpeakerSearchStatus;
    readonly voiceToneAnalysisStatus: VoiceToneAnalysisStatus;
}
export interface LambdaFunctionSinkConfiguration {
    readonly insightsTarget: string;
}
export interface SqsQueueSinkConfiguration {
    readonly insightsTarget: string;
}
export interface SnsTopicSinkConfiguration {
    readonly insightsTarget: string;
}
export interface Elements {
    readonly type: ElementsType;
    readonly amazonTranscribeCallAnalyticsProcessorConfiguration?: AmazonTranscribeCallAnalyticsProcessorConfiguration;
    readonly voiceAnalyticsProcessorConfiguration?: VoiceAnalyticsProcessorConfiguration;
    readonly amazonTranscribeProcessorConfiguration?: AmazonTranscribeProcessorConfiguration;
    readonly kinesisDataStreamSinkConfiguration?: KinesisDataStreamSinkConfiguration;
    readonly lambdaFunctionSinkConfiguration?: LambdaFunctionSinkConfiguration;
    readonly sqsQueueSinkConfiguration?: SqsQueueSinkConfiguration;
    readonly snsTopicSinkConfiguration?: SnsTopicSinkConfiguration;
    readonly s3RecordingSinkConfiguration?: S3RecordingSinkConfiguration;
}
export interface RealTimeAlertConfiguration {
    readonly disabled: boolean;
    readonly rules: Rules[];
}
export interface MediaInsightsPipelineProps {
    readonly mediaInsightsPipelineConfigurationName?: string;
    readonly realTimeAlertConfiguration?: RealTimeAlertConfiguration;
    readonly resourceAccessRoleArn: string;
    readonly elements: Elements[];
    readonly tags?: Array<MediaPipelineInsightsTag>;
    readonly clientRequestToken?: string;
}
export declare class MediaInsightsPipeline extends Construct {
    readonly mediaInsightsPipelineConfigurationArn: string;
    readonly mediaInsightsPipelineConfigurationId: string;
    readonly mediaInsightsPipelineConfigurationName: string;
    constructor(scope: Construct, id: string, props: MediaInsightsPipelineProps);
}
