"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaInsightsPipeline = exports.VoiceToneAnalysisStatus = exports.SpeakerSearchStatus = exports.ContentRedactionOutput = exports.ContentRedactionType = exports.ContentIdentificationType = exports.PartialResultsStability = exports.VocabularyFilterMethod = exports.LanguageCode = exports.ElementsType = exports.SentimentType = exports.RulesType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const mediaInsightsPipelineValidator_1 = require("./mediaInsightsPipelineValidator");
const mediaPipelinesCustomResources_1 = require("./mediaPipelinesCustomResources");
var RulesType;
(function (RulesType) {
    RulesType["KEYWORD_MATCH"] = "KeywordMatch";
    RulesType["SENTIMENT"] = "Sentiment";
    RulesType["ISSUE_DETECTION"] = "IssueDetection";
})(RulesType = exports.RulesType || (exports.RulesType = {}));
var SentimentType;
(function (SentimentType) {
    SentimentType["NEGATIVE"] = "NEGATIVE";
})(SentimentType = exports.SentimentType || (exports.SentimentType = {}));
var ElementsType;
(function (ElementsType) {
    ElementsType["AMAZON_TRANSCRIPT_CALL_ANALYTICS_PROCESS"] = "AmazonTranscribeCallAnalyticsProcessor";
    ElementsType["VOICE_ANALYTICS_PROCESSOR"] = "VoiceAnalyticsProcessor";
    ElementsType["AMAZON_TRANSCRIBE_PROCESSOR"] = "AmazonTranscribeProcessor";
    ElementsType["KINESIS_DATA_STREAM_SINK"] = "KinesisDataStreamSink";
    ElementsType["LAMBDA_FUNCTION_SINK"] = "LambdaFunctionSink";
    ElementsType["SQS_QUEUE_SINK"] = "SqsQueueSink";
    ElementsType["SNS_TOPICS_SINK"] = "SnsTopicSink";
    ElementsType["S3_RECORDING_SINK"] = "S3RecordingSink";
})(ElementsType = exports.ElementsType || (exports.ElementsType = {}));
var LanguageCode;
(function (LanguageCode) {
    LanguageCode["EN_US"] = "en-US";
    LanguageCode["EN_GB"] = "en-GB";
    LanguageCode["ES_US"] = "es-US";
    LanguageCode["FR_CA"] = "fr-CA";
    LanguageCode["FR_FR"] = "fr-FR";
    LanguageCode["EN_AU"] = "en-AU";
    LanguageCode["IT_IT"] = "it-IT";
    LanguageCode["DE_DE"] = "de-DE";
    LanguageCode["PT_BR"] = "pt-BR";
})(LanguageCode = exports.LanguageCode || (exports.LanguageCode = {}));
var VocabularyFilterMethod;
(function (VocabularyFilterMethod) {
    VocabularyFilterMethod["REMOVE"] = "remove";
    VocabularyFilterMethod["MASK"] = "mask";
    VocabularyFilterMethod["TAG"] = "tag";
})(VocabularyFilterMethod = exports.VocabularyFilterMethod || (exports.VocabularyFilterMethod = {}));
var PartialResultsStability;
(function (PartialResultsStability) {
    PartialResultsStability["HIGH"] = "high";
    PartialResultsStability["MEDIUM"] = "medium";
    PartialResultsStability["LOW"] = "low";
})(PartialResultsStability = exports.PartialResultsStability || (exports.PartialResultsStability = {}));
var ContentIdentificationType;
(function (ContentIdentificationType) {
    ContentIdentificationType["PII"] = "PII";
})(ContentIdentificationType = exports.ContentIdentificationType || (exports.ContentIdentificationType = {}));
var ContentRedactionType;
(function (ContentRedactionType) {
    ContentRedactionType["PII"] = "PII";
})(ContentRedactionType = exports.ContentRedactionType || (exports.ContentRedactionType = {}));
var ContentRedactionOutput;
(function (ContentRedactionOutput) {
    ContentRedactionOutput["REDACTED"] = "redacted";
    ContentRedactionOutput["REDACTED_AND_UNREDACTED"] = "redacted_and_unredacted";
})(ContentRedactionOutput = exports.ContentRedactionOutput || (exports.ContentRedactionOutput = {}));
var SpeakerSearchStatus;
(function (SpeakerSearchStatus) {
    SpeakerSearchStatus["ENABLED"] = "Enabled";
    SpeakerSearchStatus["DISABLED"] = "Disabled";
})(SpeakerSearchStatus = exports.SpeakerSearchStatus || (exports.SpeakerSearchStatus = {}));
var VoiceToneAnalysisStatus;
(function (VoiceToneAnalysisStatus) {
    VoiceToneAnalysisStatus["ENABLED"] = "Enabled";
    VoiceToneAnalysisStatus["DISABLED"] = "Disabled";
})(VoiceToneAnalysisStatus = exports.VoiceToneAnalysisStatus || (exports.VoiceToneAnalysisStatus = {}));
class MediaInsightsPipeline extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { mediaInsightsPipelineConfigurationName, resourceAccessRoleArn, realTimeAlertConfiguration, elements, tags, clientRequestToken, } = props;
        mediaInsightsPipelineValidator_1.mediaPipelinesInsightValidator(props);
        const mediaPipelinesInsightRequest = new mediaPipelinesCustomResources_1.MediaPipelineResources(this, 'mediaPipelinesInsightRequest', {
            resourceType: 'MediaPipelineInsights',
            uid: uid,
            properties: {
                elements: elements,
                resourceAccessRoleArn: resourceAccessRoleArn,
                tags: tags,
                clientRequestToken: clientRequestToken,
                realTimeAlertConfiguration: realTimeAlertConfiguration,
                mediaInsightsPipelineConfigurationName: mediaInsightsPipelineConfigurationName ?? uid,
            },
        });
        this.mediaInsightsPipelineConfigurationArn =
            mediaPipelinesInsightRequest.mediaPipelineCustomResource.getAttString('MediaInsightsPipelineConfigurationArn');
        this.mediaInsightsPipelineConfigurationId =
            mediaPipelinesInsightRequest.mediaPipelineCustomResource.getAttString('MediaInsightsPipelineConfigurationId');
        this.mediaInsightsPipelineConfigurationName =
            mediaPipelinesInsightRequest.mediaPipelineCustomResource.getAttString('MediaInsightsPipelineConfigurationName');
    }
}
exports.MediaInsightsPipeline = MediaInsightsPipeline;
_a = JSII_RTTI_SYMBOL_1;
MediaInsightsPipeline[_a] = { fqn: "cdk-amazon-chime-resources.MediaInsightsPipeline", version: "2.4.57" };
//# sourceMappingURL=data:application/json;base64,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