"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mediaPipelinesInsightValidator = void 0;
function mediaPipelinesInsightValidator(props) {
    if (props.elements) {
        if (!props.elements.some((element) => element.amazonTranscribeCallAnalyticsProcessorConfiguration ||
            element.amazonTranscribeProcessorConfiguration ||
            element.voiceAnalyticsProcessorConfiguration ||
            element.s3RecordingSinkConfiguration)) {
            throw new Error('MediaInsightsPipeline elements must contain at least one of amazonTranscribeCallAnalyticsProcessorConfiguration, amazonTranscribeProcessorConfiguration, voiceAnalyticsProcessorConfiguration, or s3RecordingSinkConfiguration');
        }
        if (props.elements.some((element) => element.amazonTranscribeCallAnalyticsProcessorConfiguration ||
            element.amazonTranscribeProcessorConfiguration ||
            element.voiceAnalyticsProcessorConfiguration) &&
            !props.elements.some((element) => element.kinesisDataStreamSinkConfiguration)) {
            throw new Error('A kinesisDataStreamSinkConfiguration is required if amazonTranscribeCallAnalyticsProcessorConfiguration, amazonTranscribeProcessorConfiguration, or voiceAnalyticsProcessorConfiguration are used');
        }
        if (props.elements.some((element) => element.amazonTranscribeCallAnalyticsProcessorConfiguration) &&
            props.elements.some((element) => element.amazonTranscribeProcessorConfiguration)) {
            throw new Error('Element may only contain amazonTranscribeCallAnalyticsProcessorConfiguration or amazonTranscribeProcessorConfiguration');
        }
        if (props.elements.some((element) => element.s3RecordingSinkConfiguration) &&
            props.elements.some((element) => element.amazonTranscribeProcessorConfiguration ||
                element.amazonTranscribeCallAnalyticsProcessorConfiguration ||
                element.voiceAnalyticsProcessorConfiguration)) {
            throw new Error('s3RecordingSinkConfiguration cannot be used with amazonTranscribeProcessorConfiguration, amazonTranscribeCallAnalyticsProcessorConfiguration, or voiceAnalyticsProcessorConfiguration');
        }
        if (props.elements.some((element) => element.s3RecordingSinkConfiguration) &&
            props.realTimeAlertConfiguration) {
            throw new Error('s3RecordingSinkConfiguration cannot be used with realTimeAlertConfiguration');
        }
    }
    if (props.realTimeAlertConfiguration) {
        if (props.realTimeAlertConfiguration.rules.length > 3) {
            throw new Error('A maximum of three realTimeAlert rules are allowed');
        }
        props.realTimeAlertConfiguration.rules.forEach((rule) => {
            if (rule.type == 'KeywordMatch' &&
                !rule.keywordMatchConfiguration &&
                (rule.issueDetectionConfiguration || rule.sentimentConfiguration)) {
                throw new Error('KeywordMatch type requires keywordMatchConfiguration');
            }
            if (rule.type == 'Sentiment' &&
                !rule.sentimentConfiguration &&
                (rule.issueDetectionConfiguration || rule.keywordMatchConfiguration)) {
                throw new Error('Sentiment type requires sentimentConfiguration');
            }
            if (rule.type == 'IssueDetection' &&
                !rule.issueDetectionConfiguration &&
                (rule.sentimentConfiguration || rule.keywordMatchConfiguration)) {
                throw new Error('IssueDetection type requires issueDetectionConfiguration');
            }
        });
        props.realTimeAlertConfiguration.rules.forEach((rule) => {
            if ((rule.type == 'KeywordMatch' ||
                rule.type == 'Sentiment' ||
                rule.type == 'IssueDetection') &&
                !(rule.issueDetectionConfiguration ||
                    rule.keywordMatchConfiguration ||
                    rule.sentimentConfiguration)) {
                throw new Error('Rule type must contain configuration');
            }
        });
        if (props.elements.some((element) => element.amazonTranscribeProcessorConfiguration ||
            element.amazonTranscribeCallAnalyticsProcessorConfiguration)) {
            if (props.elements.some((element) => element.amazonTranscribeProcessorConfiguration) &&
                (props.realTimeAlertConfiguration.rules.some((rule) => rule.sentimentConfiguration) ||
                    props.realTimeAlertConfiguration.rules.some((rule) => rule.issueDetectionConfiguration))) {
                throw new Error('amazonTranscribeProcessorConfiguration cannot use realTimeAlertConfiguration sentimentConfiguration or issueDetectionConfiguration');
            }
        }
        else {
            throw new Error('realTimeAlertConfiguration requires amazonTranscribeProcessorConfiguration or amazonTranscribeCallAnalyticsProcessorConfiguration');
        }
    }
    return true;
}
exports.mediaPipelinesInsightValidator = mediaPipelinesInsightValidator;
//# sourceMappingURL=data:application/json;base64,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