import { Construct } from 'constructs';
import { MessagingResources } from './messagingCustomResources';
export declare enum AppInstanceDataType {
    CHANNEL = "Channel",
    CHANNELMESSAGE = "ChannelMessage"
}
/**
 * Props for `AppInstanceStreamingConfiguration`.
 * See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_AppInstanceStreamingConfiguration.html
 */
export interface StreamingConfig {
    /**
     * The type of data to be streamed.
     */
    readonly appInstanceDataType: AppInstanceDataType;
    /**
     * The resource ARN of a Kinesis Stream.
     */
    readonly resourceArn: string;
}
export declare type StreamingConfigs = Array<StreamingConfig>;
export interface AppInstanceTags {
    readonly key: string;
    readonly value: string;
}
/**
 * Props for `AppInstance`.
 */
export interface AppInstanceProps {
    /**
     * The name of the app instance.
     * @default - None
     */
    readonly name?: string;
    /**
     * The metadata of the app instance. Limited to a 1KB string in UTF-8.
     * @default - None
     */
    readonly metadata?: string;
    /**
     * The tags for the creation request.
     *
     * @default - None
     */
    readonly tags?: Array<AppInstanceTags>;
    /**
     * The ClientRequestToken of the app instance.  This field is autopopulated if not provided.
     * @default - None
     */
    readonly clientRequestToken?: string;
}
export declare class MessagingAppInstance extends Construct {
    readonly appInstanceArn: string;
    constructor(scope: Construct, id: string, props: AppInstanceProps);
    streaming(streamingConfigs: StreamingConfigs): MessagingResources;
    retention(days: number): MessagingResources;
}
